/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.1)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#include "messagingEvents_types.h"

#include <algorithm>

namespace apache { namespace airavata { namespace model { namespace messaging { namespace event {

int _kMessageLevelValues[] = {
  MessageLevel::INFO,
  MessageLevel::DEBUG,
  MessageLevel::ERROR,
  MessageLevel::ACK
};
const char* _kMessageLevelNames[] = {
  "INFO",
  "DEBUG",
  "ERROR",
  "ACK"
};
const std::map<int, const char*> _MessageLevel_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(4, _kMessageLevelValues, _kMessageLevelNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kMessageTypeValues[] = {
  MessageType::EXPERIMENT,
  MessageType::TASK,
  MessageType::WORKFLOWNODE,
  MessageType::JOB,
  MessageType::LAUNCHTASK,
  MessageType::TERMINATETASK,
  MessageType::TASKOUTPUT
};
const char* _kMessageTypeNames[] = {
  "EXPERIMENT",
  "TASK",
  "WORKFLOWNODE",
  "JOB",
  "LAUNCHTASK",
  "TERMINATETASK",
  "TASKOUTPUT"
};
const std::map<int, const char*> _MessageType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(7, _kMessageTypeValues, _kMessageTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

const char* ExperimentStatusChangeEvent::ascii_fingerprint = "38C252E94E93B69D04EB3A6EE2F9EDFB";
const uint8_t ExperimentStatusChangeEvent::binary_fingerprint[16] = {0x38,0xC2,0x52,0xE9,0x4E,0x93,0xB6,0x9D,0x04,0xEB,0x3A,0x6E,0xE2,0xF9,0xED,0xFB};

uint32_t ExperimentStatusChangeEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_experimentId = false;
  bool isset_gatewayId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast0;
          xfer += iprot->readI32(ecast0);
          this->state = ( ::apache::airavata::model::workspace::experiment::ExperimentState::type)ecast0;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ExperimentStatusChangeEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ExperimentStatusChangeEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ExperimentStatusChangeEvent &a, ExperimentStatusChangeEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.experimentId, b.experimentId);
  swap(a.gatewayId, b.gatewayId);
}

const char* WorkflowIdentifier::ascii_fingerprint = "AB879940BD15B6B25691265F7384B271";
const uint8_t WorkflowIdentifier::binary_fingerprint[16] = {0xAB,0x87,0x99,0x40,0xBD,0x15,0xB6,0xB2,0x56,0x91,0x26,0x5F,0x73,0x84,0xB2,0x71};

uint32_t WorkflowIdentifier::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_workflowNodeId = false;
  bool isset_experimentId = false;
  bool isset_gatewayId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->workflowNodeId);
          isset_workflowNodeId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_workflowNodeId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t WorkflowIdentifier::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("WorkflowIdentifier");

  xfer += oprot->writeFieldBegin("workflowNodeId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->workflowNodeId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(WorkflowIdentifier &a, WorkflowIdentifier &b) {
  using ::std::swap;
  swap(a.workflowNodeId, b.workflowNodeId);
  swap(a.experimentId, b.experimentId);
  swap(a.gatewayId, b.gatewayId);
}

const char* WorkflowNodeStatusChangeEvent::ascii_fingerprint = "9686679C94D43D75F2B35A0BED2E4003";
const uint8_t WorkflowNodeStatusChangeEvent::binary_fingerprint[16] = {0x96,0x86,0x67,0x9C,0x94,0xD4,0x3D,0x75,0xF2,0xB3,0x5A,0x0B,0xED,0x2E,0x40,0x03};

uint32_t WorkflowNodeStatusChangeEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_workflowNodeIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast1;
          xfer += iprot->readI32(ecast1);
          this->state = ( ::apache::airavata::model::workspace::experiment::WorkflowNodeState::type)ecast1;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->workflowNodeIdentity.read(iprot);
          isset_workflowNodeIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_workflowNodeIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t WorkflowNodeStatusChangeEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("WorkflowNodeStatusChangeEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("workflowNodeIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->workflowNodeIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(WorkflowNodeStatusChangeEvent &a, WorkflowNodeStatusChangeEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.workflowNodeIdentity, b.workflowNodeIdentity);
}

const char* TaskIdentifier::ascii_fingerprint = "C93D890311F28844166CF6E571EB3AC2";
const uint8_t TaskIdentifier::binary_fingerprint[16] = {0xC9,0x3D,0x89,0x03,0x11,0xF2,0x88,0x44,0x16,0x6C,0xF6,0xE5,0x71,0xEB,0x3A,0xC2};

uint32_t TaskIdentifier::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_taskId = false;
  bool isset_workflowNodeId = false;
  bool isset_experimentId = false;
  bool isset_gatewayId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->taskId);
          isset_taskId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->workflowNodeId);
          isset_workflowNodeId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_taskId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_workflowNodeId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskIdentifier::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("TaskIdentifier");

  xfer += oprot->writeFieldBegin("taskId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->taskId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("workflowNodeId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->workflowNodeId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskIdentifier &a, TaskIdentifier &b) {
  using ::std::swap;
  swap(a.taskId, b.taskId);
  swap(a.workflowNodeId, b.workflowNodeId);
  swap(a.experimentId, b.experimentId);
  swap(a.gatewayId, b.gatewayId);
}

const char* TaskStatusChangeEvent::ascii_fingerprint = "8D18A3CD1822DBC67D7BD8CB98E7B4F1";
const uint8_t TaskStatusChangeEvent::binary_fingerprint[16] = {0x8D,0x18,0xA3,0xCD,0x18,0x22,0xDB,0xC6,0x7D,0x7B,0xD8,0xCB,0x98,0xE7,0xB4,0xF1};

uint32_t TaskStatusChangeEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_taskIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast2;
          xfer += iprot->readI32(ecast2);
          this->state = ( ::apache::airavata::model::workspace::experiment::TaskState::type)ecast2;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->taskIdentity.read(iprot);
          isset_taskIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_taskIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskStatusChangeEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("TaskStatusChangeEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("taskIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->taskIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskStatusChangeEvent &a, TaskStatusChangeEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.taskIdentity, b.taskIdentity);
}

const char* TaskStatusChangeRequestEvent::ascii_fingerprint = "8D18A3CD1822DBC67D7BD8CB98E7B4F1";
const uint8_t TaskStatusChangeRequestEvent::binary_fingerprint[16] = {0x8D,0x18,0xA3,0xCD,0x18,0x22,0xDB,0xC6,0x7D,0x7B,0xD8,0xCB,0x98,0xE7,0xB4,0xF1};

uint32_t TaskStatusChangeRequestEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_taskIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast3;
          xfer += iprot->readI32(ecast3);
          this->state = ( ::apache::airavata::model::workspace::experiment::TaskState::type)ecast3;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->taskIdentity.read(iprot);
          isset_taskIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_taskIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskStatusChangeRequestEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("TaskStatusChangeRequestEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("taskIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->taskIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskStatusChangeRequestEvent &a, TaskStatusChangeRequestEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.taskIdentity, b.taskIdentity);
}

const char* TaskOutputChangeEvent::ascii_fingerprint = "C7C71D05D69F7D8C4A11C9E432FF5A51";
const uint8_t TaskOutputChangeEvent::binary_fingerprint[16] = {0xC7,0xC7,0x1D,0x05,0xD6,0x9F,0x7D,0x8C,0x4A,0x11,0xC9,0xE4,0x32,0xFF,0x5A,0x51};

uint32_t TaskOutputChangeEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_output = false;
  bool isset_taskIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->output.clear();
            uint32_t _size4;
            ::apache::thrift::protocol::TType _etype7;
            xfer += iprot->readListBegin(_etype7, _size4);
            this->output.resize(_size4);
            uint32_t _i8;
            for (_i8 = 0; _i8 < _size4; ++_i8)
            {
              xfer += this->output[_i8].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          isset_output = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->taskIdentity.read(iprot);
          isset_taskIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_output)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_taskIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskOutputChangeEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("TaskOutputChangeEvent");

  xfer += oprot->writeFieldBegin("output", ::apache::thrift::protocol::T_LIST, 1);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->output.size()));
    std::vector< ::apache::airavata::model::appcatalog::appinterface::OutputDataObjectType> ::const_iterator _iter9;
    for (_iter9 = this->output.begin(); _iter9 != this->output.end(); ++_iter9)
    {
      xfer += (*_iter9).write(oprot);
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("taskIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->taskIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskOutputChangeEvent &a, TaskOutputChangeEvent &b) {
  using ::std::swap;
  swap(a.output, b.output);
  swap(a.taskIdentity, b.taskIdentity);
}

const char* JobIdentifier::ascii_fingerprint = "BFF0E21728CB005F9AA5774A41542B8D";
const uint8_t JobIdentifier::binary_fingerprint[16] = {0xBF,0xF0,0xE2,0x17,0x28,0xCB,0x00,0x5F,0x9A,0xA5,0x77,0x4A,0x41,0x54,0x2B,0x8D};

uint32_t JobIdentifier::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobId = false;
  bool isset_taskId = false;
  bool isset_workflowNodeId = false;
  bool isset_experimentId = false;
  bool isset_gatewayId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobId);
          isset_jobId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->taskId);
          isset_taskId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->workflowNodeId);
          isset_workflowNodeId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_taskId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_workflowNodeId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t JobIdentifier::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("JobIdentifier");

  xfer += oprot->writeFieldBegin("jobId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("taskId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->taskId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("workflowNodeId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->workflowNodeId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 5);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(JobIdentifier &a, JobIdentifier &b) {
  using ::std::swap;
  swap(a.jobId, b.jobId);
  swap(a.taskId, b.taskId);
  swap(a.workflowNodeId, b.workflowNodeId);
  swap(a.experimentId, b.experimentId);
  swap(a.gatewayId, b.gatewayId);
}

const char* ProcessSubmitEvent::ascii_fingerprint = "07A9615F837F7D0A952B595DD3020972";
const uint8_t ProcessSubmitEvent::binary_fingerprint[16] = {0x07,0xA9,0x61,0x5F,0x83,0x7F,0x7D,0x0A,0x95,0x2B,0x59,0x5D,0xD3,0x02,0x09,0x72};

uint32_t ProcessSubmitEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_taskId = false;
  bool isset_credentialToken = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->taskId);
          isset_taskId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->credentialToken);
          isset_credentialToken = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_taskId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_credentialToken)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ProcessSubmitEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ProcessSubmitEvent");

  xfer += oprot->writeFieldBegin("taskId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->taskId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("credentialToken", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->credentialToken);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ProcessSubmitEvent &a, ProcessSubmitEvent &b) {
  using ::std::swap;
  swap(a.taskId, b.taskId);
  swap(a.credentialToken, b.credentialToken);
}

const char* TaskSubmitEvent::ascii_fingerprint = "C93D890311F28844166CF6E571EB3AC2";
const uint8_t TaskSubmitEvent::binary_fingerprint[16] = {0xC9,0x3D,0x89,0x03,0x11,0xF2,0x88,0x44,0x16,0x6C,0xF6,0xE5,0x71,0xEB,0x3A,0xC2};

uint32_t TaskSubmitEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_experimentId = false;
  bool isset_taskId = false;
  bool isset_gatewayId = false;
  bool isset_tokenId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->taskId);
          isset_taskId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->tokenId);
          isset_tokenId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_taskId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_tokenId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskSubmitEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("TaskSubmitEvent");

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("taskId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->taskId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("tokenId", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->tokenId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskSubmitEvent &a, TaskSubmitEvent &b) {
  using ::std::swap;
  swap(a.experimentId, b.experimentId);
  swap(a.taskId, b.taskId);
  swap(a.gatewayId, b.gatewayId);
  swap(a.tokenId, b.tokenId);
}

const char* TaskTerminateEvent::ascii_fingerprint = "C93D890311F28844166CF6E571EB3AC2";
const uint8_t TaskTerminateEvent::binary_fingerprint[16] = {0xC9,0x3D,0x89,0x03,0x11,0xF2,0x88,0x44,0x16,0x6C,0xF6,0xE5,0x71,0xEB,0x3A,0xC2};

uint32_t TaskTerminateEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_experimentId = false;
  bool isset_taskId = false;
  bool isset_gatewayId = false;
  bool isset_tokenId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->taskId);
          isset_taskId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->tokenId);
          isset_tokenId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_taskId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_tokenId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskTerminateEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("TaskTerminateEvent");

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("taskId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->taskId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("tokenId", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->tokenId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskTerminateEvent &a, TaskTerminateEvent &b) {
  using ::std::swap;
  swap(a.experimentId, b.experimentId);
  swap(a.taskId, b.taskId);
  swap(a.gatewayId, b.gatewayId);
  swap(a.tokenId, b.tokenId);
}

const char* JobStatusChangeEvent::ascii_fingerprint = "062775D589B60D1687103FD465B0F5E8";
const uint8_t JobStatusChangeEvent::binary_fingerprint[16] = {0x06,0x27,0x75,0xD5,0x89,0xB6,0x0D,0x16,0x87,0x10,0x3F,0xD4,0x65,0xB0,0xF5,0xE8};

uint32_t JobStatusChangeEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_jobIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast10;
          xfer += iprot->readI32(ecast10);
          this->state = ( ::apache::airavata::model::workspace::experiment::JobState::type)ecast10;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->jobIdentity.read(iprot);
          isset_jobIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_jobIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t JobStatusChangeEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("JobStatusChangeEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("jobIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->jobIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(JobStatusChangeEvent &a, JobStatusChangeEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.jobIdentity, b.jobIdentity);
}

const char* JobStatusChangeRequestEvent::ascii_fingerprint = "062775D589B60D1687103FD465B0F5E8";
const uint8_t JobStatusChangeRequestEvent::binary_fingerprint[16] = {0x06,0x27,0x75,0xD5,0x89,0xB6,0x0D,0x16,0x87,0x10,0x3F,0xD4,0x65,0xB0,0xF5,0xE8};

uint32_t JobStatusChangeRequestEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_jobIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast11;
          xfer += iprot->readI32(ecast11);
          this->state = ( ::apache::airavata::model::workspace::experiment::JobState::type)ecast11;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->jobIdentity.read(iprot);
          isset_jobIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_jobIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t JobStatusChangeRequestEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("JobStatusChangeRequestEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("jobIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->jobIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(JobStatusChangeRequestEvent &a, JobStatusChangeRequestEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.jobIdentity, b.jobIdentity);
}

const char* Message::ascii_fingerprint = "6904C391426E568AF9DEAF69860C076A";
const uint8_t Message::binary_fingerprint[16] = {0x69,0x04,0xC3,0x91,0x42,0x6E,0x56,0x8A,0xF9,0xDE,0xAF,0x69,0x86,0x0C,0x07,0x6A};

uint32_t Message::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_event = false;
  bool isset_messageId = false;
  bool isset_messageType = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->event);
          isset_event = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->messageId);
          isset_messageId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast12;
          xfer += iprot->readI32(ecast12);
          this->messageType = (MessageType::type)ecast12;
          isset_messageType = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->updatedTime);
          this->__isset.updatedTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast13;
          xfer += iprot->readI32(ecast13);
          this->messageLevel = (MessageLevel::type)ecast13;
          this->__isset.messageLevel = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_event)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_messageId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_messageType)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t Message::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("Message");

  xfer += oprot->writeFieldBegin("event", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeBinary(this->event);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("messageId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->messageId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("messageType", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32((int32_t)this->messageType);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.updatedTime) {
    xfer += oprot->writeFieldBegin("updatedTime", ::apache::thrift::protocol::T_I64, 4);
    xfer += oprot->writeI64(this->updatedTime);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.messageLevel) {
    xfer += oprot->writeFieldBegin("messageLevel", ::apache::thrift::protocol::T_I32, 5);
    xfer += oprot->writeI32((int32_t)this->messageLevel);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(Message &a, Message &b) {
  using ::std::swap;
  swap(a.event, b.event);
  swap(a.messageId, b.messageId);
  swap(a.messageType, b.messageType);
  swap(a.updatedTime, b.updatedTime);
  swap(a.messageLevel, b.messageLevel);
  swap(a.__isset, b.__isset);
}

}}}}} // namespace
