/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.AlphaBean;
import org.apache.commons.beanutils.BasicDynaBean;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanWithInnerBean;
import org.apache.commons.beanutils.BetaBean;
import org.apache.commons.beanutils.DefaultBeanIntrospector;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.ExtendMapBean;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.NestedTestBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropsFirstPropertyUtilsBean;
import org.apache.commons.beanutils.SonOfAlphaBean;
import org.apache.commons.beanutils.TestBean;
import org.apache.commons.beanutils.TestBeanPackageSubclass;
import org.apache.commons.beanutils.TestBeanPublicSubclass;
import org.apache.commons.beanutils.priv.PrivateBeanFactory;
import org.apache.commons.beanutils.priv.PrivateDirect;
import org.apache.commons.beanutils.priv.PublicSubBean;

public class PropertyUtilsTestCase
extends TestCase {
    private static final String PRIVATE_DIRECT_CLASS = "org.apache.commons.beanutils.priv.PrivateDirect";
    private static final String PRIVATE_INDIRECT_CLASS = "org.apache.commons.beanutils.priv.PrivateIndirect";
    private static final String TEST_BEAN_CLASS = "org.apache.commons.beanutils.TestBean";
    protected static final String[] properties = new String[]{"booleanProperty", "booleanSecond", "doubleProperty", "dupProperty", "floatProperty", "intArray", "intIndexed", "intProperty", "listIndexed", "longProperty", "nested", "nullProperty", "readOnlyProperty", "shortProperty", "stringArray", "stringIndexed", "stringProperty", "writeOnlyProperty"};
    protected TestBean bean;
    protected TestBeanPackageSubclass beanPackageSubclass;
    protected PrivateDirect beanPrivate;
    protected PrivateDirect beanPrivateSubclass;
    protected TestBeanPublicSubclass beanPublicSubclass;
    protected String[] describes = new String[]{"booleanProperty", "booleanSecond", "doubleProperty", "floatProperty", "intArray", "intProperty", "listIndexed", "longProperty", "nested", "nullProperty", "shortProperty", "stringArray", "stringProperty"};

    private static PropertyDescriptor findNameDescriptor(PropertyDescriptor[] desc) {
        for (PropertyDescriptor element : desc) {
            if (!element.getName().equals("name")) continue;
            return element;
        }
        return null;
    }

    public static Test suite() {
        return new TestSuite(PropertyUtilsTestCase.class);
    }

    public PropertyUtilsTestCase(String name) {
        super(name);
    }

    private String keysToString(Map<?, ?> map) {
        Object[] mapKeys = map.keySet().toArray();
        Arrays.sort(mapKeys);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < mapKeys.length; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(mapKeys[i]);
        }
        return buf.toString();
    }

    public void setUp() {
        this.bean = new TestBean();
        this.beanPackageSubclass = new TestBeanPackageSubclass();
        this.beanPrivate = PrivateBeanFactory.create();
        this.beanPrivateSubclass = PrivateBeanFactory.createSubclass();
        this.beanPublicSubclass = new TestBeanPublicSubclass();
        DynaProperty[] properties = new DynaProperty[]{new DynaProperty("stringProperty", String.class), new DynaProperty("nestedBean", TestBean.class), new DynaProperty("nullDynaBean", DynaBean.class)};
        BasicDynaClass dynaClass = new BasicDynaClass("nestedDynaBean", BasicDynaBean.class, properties);
        BasicDynaBean nestedDynaBean = new BasicDynaBean((DynaClass)dynaClass);
        nestedDynaBean.set("nestedBean", (Object)this.bean);
        this.bean.setNestedDynaBean((DynaBean)nestedDynaBean);
        PropertyUtils.clearDescriptors();
    }

    public void tearDown() {
        this.bean = null;
        this.beanPackageSubclass = null;
        this.beanPrivate = null;
        this.beanPrivateSubclass = null;
        this.beanPublicSubclass = null;
        PropertyUtils.resetBeanIntrospectors();
    }

    public void testAddBeanIntrospectorNull() {
        try {
            PropertyUtils.addBeanIntrospector(null);
            PropertyUtilsTestCase.fail((String)"Could add null BeanIntrospector!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCopyPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("booleanProperty", Boolean.FALSE);
        map.put("doubleProperty", 333.0);
        map.put("dupProperty", new String[]{"New 0", "New 1", "New 2"});
        map.put("floatProperty", Float.valueOf(222.0f));
        map.put("intArray", new int[]{0, 100, 200});
        map.put("intProperty", 111);
        map.put("longProperty", 444L);
        map.put("shortProperty", (short)555);
        map.put("stringProperty", "New String Property");
        try {
            PropertyUtils.copyProperties((Object)this.bean, map);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t.toString()));
        }
        PropertyUtilsTestCase.assertEquals((String)"booleanProperty", (boolean)false, (boolean)this.bean.getBooleanProperty());
        PropertyUtilsTestCase.assertEquals((String)"doubleProperty", (double)333.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        PropertyUtilsTestCase.assertEquals((String)"floatProperty", (float)222.0f, (float)this.bean.getFloatProperty(), (float)0.005f);
        PropertyUtilsTestCase.assertEquals((String)"intProperty", (int)111, (int)this.bean.getIntProperty());
        PropertyUtilsTestCase.assertEquals((String)"longProperty", (long)444L, (long)this.bean.getLongProperty());
        PropertyUtilsTestCase.assertEquals((String)"shortProperty", (short)555, (short)this.bean.getShortProperty());
        PropertyUtilsTestCase.assertEquals((String)"stringProperty", (String)"New String Property", (String)this.bean.getStringProperty());
        String[] dupProperty = this.bean.getDupProperty();
        PropertyUtilsTestCase.assertNotNull((String)"dupProperty present", (Object)dupProperty);
        PropertyUtilsTestCase.assertEquals((String)"dupProperty length", (int)3, (int)dupProperty.length);
        PropertyUtilsTestCase.assertEquals((String)"dupProperty[0]", (String)"New 0", (String)dupProperty[0]);
        PropertyUtilsTestCase.assertEquals((String)"dupProperty[1]", (String)"New 1", (String)dupProperty[1]);
        PropertyUtilsTestCase.assertEquals((String)"dupProperty[2]", (String)"New 2", (String)dupProperty[2]);
        int[] intArray = this.bean.getIntArray();
        PropertyUtilsTestCase.assertNotNull((String)"intArray present", (Object)intArray);
        PropertyUtilsTestCase.assertEquals((String)"intArray length", (int)3, (int)intArray.length);
        PropertyUtilsTestCase.assertEquals((String)"intArray[0]", (int)0, (int)intArray[0]);
        PropertyUtilsTestCase.assertEquals((String)"intArray[1]", (int)100, (int)intArray[1]);
        PropertyUtilsTestCase.assertEquals((String)"intArray[2]", (int)200, (int)intArray[2]);
    }

    public void testCustomIntrospection() {
        PropertyDescriptor[] desc1 = PropertyUtils.getPropertyDescriptors(AlphaBean.class);
        PropertyDescriptor nameDescriptor = PropertyUtilsTestCase.findNameDescriptor(desc1);
        PropertyUtilsTestCase.assertNotNull((String)"No write method", (Object)nameDescriptor.getWriteMethod());
        BeanIntrospector bi = icontext -> {
            Set names = icontext.propertyNames();
            PropertyDescriptor[] newDescs = new PropertyDescriptor[names.size()];
            int idx = 0;
            for (String propName : names) {
                PropertyDescriptor pd = icontext.getPropertyDescriptor(propName);
                newDescs[idx] = new PropertyDescriptor(pd.getName(), pd.getReadMethod(), null);
                ++idx;
            }
            icontext.addPropertyDescriptors(newDescs);
        };
        PropertyUtils.clearDescriptors();
        PropertyUtils.addBeanIntrospector((BeanIntrospector)bi);
        PropertyDescriptor[] desc2 = PropertyUtils.getPropertyDescriptors(AlphaBean.class);
        PropertyUtilsTestCase.assertEquals((String)"Different number of properties", (int)desc1.length, (int)desc2.length);
        nameDescriptor = PropertyUtilsTestCase.findNameDescriptor(desc2);
        PropertyUtilsTestCase.assertNull((String)"Got a write method", (Object)nameDescriptor.getWriteMethod());
        PropertyUtils.removeBeanIntrospector((BeanIntrospector)bi);
    }

    public void testCustomIntrospectionEx() {
        BeanIntrospector bi = icontext -> {
            throw new IntrospectionException("TestException");
        };
        PropertyUtils.clearDescriptors();
        PropertyUtils.addBeanIntrospector((BeanIntrospector)bi);
        PropertyDescriptor[] desc = PropertyUtils.getPropertyDescriptors(AlphaBean.class);
        PropertyUtilsTestCase.assertNotNull((String)"Introspection did not work", (Object)PropertyUtilsTestCase.findNameDescriptor(desc));
        PropertyUtils.removeBeanIntrospector((BeanIntrospector)bi);
    }

    public void testDescribe() {
        Map map = null;
        try {
            map = PropertyUtils.describe((Object)this.bean);
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Threw exception " + e));
        }
        for (String describe : this.describes) {
            PropertyUtilsTestCase.assertTrue((String)("Property '" + describe + "' is present"), (boolean)map.containsKey(describe));
        }
        PropertyUtilsTestCase.assertTrue((String)"Property 'writeOnlyProperty' is not present", (!map.containsKey("writeOnlyProperty") ? 1 : 0) != 0);
        PropertyUtilsTestCase.assertEquals((String)"Value of 'booleanProperty'", (Object)Boolean.TRUE, map.get("booleanProperty"));
        PropertyUtilsTestCase.assertEquals((String)"Value of 'doubleProperty'", (Object)321.0, map.get("doubleProperty"));
        PropertyUtilsTestCase.assertEquals((String)"Value of 'floatProperty'", (Object)Float.valueOf(123.0f), map.get("floatProperty"));
        PropertyUtilsTestCase.assertEquals((String)"Value of 'intProperty'", (Object)123, map.get("intProperty"));
        PropertyUtilsTestCase.assertEquals((String)"Value of 'longProperty'", (Object)321L, map.get("longProperty"));
        PropertyUtilsTestCase.assertEquals((String)"Value of 'shortProperty'", (Object)987, map.get("shortProperty"));
        PropertyUtilsTestCase.assertEquals((String)"Value of 'stringProperty'", (String)"This is a string", (String)((String)map.get("stringProperty")));
    }

    public void testExceptionFromInvoke() throws Exception {
        try {
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"intProperty", (Object)"XXX");
        }
        catch (IllegalArgumentException t) {
            Throwable cause = (Throwable)PropertyUtils.getProperty((Object)t, (String)"cause");
            PropertyUtilsTestCase.assertNotNull((String)"Cause not found", (Object)cause);
            PropertyUtilsTestCase.assertTrue((String)("Expected cause to be IllegalArgumentException, but was: " + cause.getClass()), (boolean)(cause instanceof IllegalArgumentException));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Expected IllegalArgumentException, but threw " + t));
        }
    }

    public void testGetDescriptorArguments() {
        try {
            PropertyUtils.getPropertyDescriptor(null, (String)"stringProperty");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.getPropertyDescriptor((Object)this.bean, null);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
    }

    protected void testGetDescriptorBase(String name, String read, String write) {
        try {
            PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)name);
            if (read == null && write == null) {
                PropertyUtilsTestCase.assertNull((String)"Got descriptor", (Object)pd);
                return;
            }
            PropertyUtilsTestCase.assertNotNull((String)"Got descriptor", (Object)pd);
            Method rm = pd.getReadMethod();
            if (read != null) {
                PropertyUtilsTestCase.assertNotNull((String)"Got read method", (Object)rm);
                PropertyUtilsTestCase.assertEquals((String)"Got correct read method", (String)rm.getName(), (String)read);
            } else {
                PropertyUtilsTestCase.assertNull((String)"Got read method", (Object)rm);
            }
            Method wm = pd.getWriteMethod();
            if (write != null) {
                PropertyUtilsTestCase.assertNotNull((String)"Got write method", (Object)wm);
                PropertyUtilsTestCase.assertEquals((String)"Got correct write method", (String)wm.getName(), (String)write);
            } else {
                PropertyUtilsTestCase.assertNull((String)"Got write method", (Object)wm);
            }
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetDescriptorBoolean() {
        this.testGetDescriptorBase("booleanProperty", "getBooleanProperty", "setBooleanProperty");
    }

    public void testGetDescriptorDouble() {
        this.testGetDescriptorBase("doubleProperty", "getDoubleProperty", "setDoubleProperty");
    }

    public void testGetDescriptorFloat() {
        this.testGetDescriptorBase("floatProperty", "getFloatProperty", "setFloatProperty");
    }

    public void testGetDescriptorInt() {
        this.testGetDescriptorBase("intProperty", "getIntProperty", "setIntProperty");
    }

    public void testGetDescriptorInvalidBoolean() throws Exception {
        PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)"invalidBoolean");
        PropertyUtilsTestCase.assertNotNull((String)"invalidBoolean is a property", (Object)pd);
        PropertyUtilsTestCase.assertNotNull((String)"invalidBoolean has a getter method", (Object)pd.getReadMethod());
        PropertyUtilsTestCase.assertNull((String)"invalidBoolean has no write method", (Object)pd.getWriteMethod());
        PropertyUtilsTestCase.assertTrue((String)"invalidBoolean getter method is isInvalidBoolean or getInvalidBoolean", (boolean)Arrays.asList("isInvalidBoolean", "getInvalidBoolean").contains(pd.getReadMethod().getName()));
    }

    public void testGetDescriptorLong() {
        this.testGetDescriptorBase("longProperty", "getLongProperty", "setLongProperty");
    }

    public void testGetDescriptorMappedPeriods() {
        PropertyDescriptor desc;
        this.bean.getMappedIntProperty("xyz");
        Integer testIntegerValue = 1234;
        this.bean.setMappedIntProperty("key.with.a.dot", testIntegerValue);
        PropertyUtilsTestCase.assertEquals((String)"Can retrieve directly", (Object)testIntegerValue, (Object)this.bean.getMappedIntProperty("key.with.a.dot"));
        try {
            desc = PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)"mappedIntProperty(key.with.a.dot)");
            PropertyUtilsTestCase.assertEquals((String)"Check descriptor type (A)", Integer.TYPE, (Object)((MappedPropertyDescriptor)desc).getMappedPropertyType());
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Threw exception (A): " + e));
        }
        this.bean.setMappedObjects("nested.property", new TestBean((int)testIntegerValue));
        PropertyUtilsTestCase.assertEquals((String)"Can retrieve directly", (Object)testIntegerValue, (Object)((TestBean)this.bean.getMappedObjects("nested.property")).getIntProperty());
        try {
            desc = PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)"mappedObjects(nested.property).intProperty");
            PropertyUtilsTestCase.assertEquals((String)"Check descriptor type (B)", Integer.TYPE, desc.getPropertyType());
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Threw exception (B): " + e));
        }
    }

    public void testGetDescriptorReadOnly() {
        this.testGetDescriptorBase("readOnlyProperty", "getReadOnlyProperty", null);
    }

    public void testGetDescriptors() {
        PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors((Object)this.bean);
        PropertyUtilsTestCase.assertNotNull((String)"Got descriptors", (Object)pd);
        int[] count = new int[properties.length];
        for (PropertyDescriptor element : pd) {
            String name = element.getName();
            for (int j = 0; j < properties.length; ++j) {
                if (!name.equals(properties[j])) continue;
                int n = j;
                count[n] = count[n] + 1;
            }
        }
        for (int j = 0; j < properties.length; ++j) {
            if (count[j] < 0) {
                PropertyUtilsTestCase.fail((String)("Missing property " + properties[j]));
                continue;
            }
            if (count[j] <= 1) continue;
            PropertyUtilsTestCase.fail((String)("Duplicate property " + properties[j]));
        }
    }

    public void testGetDescriptorsArguments() {
        try {
            PropertyUtils.getPropertyDescriptors(null);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException"));
        }
    }

    public void testGetDescriptorSecond() {
        this.testGetDescriptorBase("booleanSecond", "isBooleanSecond", "setBooleanSecond");
    }

    public void testGetDescriptorShort() {
        this.testGetDescriptorBase("shortProperty", "getShortProperty", "setShortProperty");
    }

    public void testGetDescriptorString() {
        this.testGetDescriptorBase("stringProperty", "getStringProperty", "setStringProperty");
    }

    public void testGetDescriptorUnknown() {
        this.testGetDescriptorBase("unknown", null, null);
    }

    public void testGetDescriptorWriteOnly() {
        this.testGetDescriptorBase("writeOnlyProperty", null, "setWriteOnlyProperty");
    }

    public void testGetIndexedArguments() {
        try {
            PropertyUtils.getIndexedProperty(null, (String)"intArray", (int)0);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.getIndexedProperty((Object)this.bean, null, (int)0);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
        try {
            PropertyUtils.getIndexedProperty(null, (String)"intArray[0]");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 3");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 3"));
        }
        try {
            PropertyUtils.getIndexedProperty((Object)this.bean, (String)"[0]");
            PropertyUtilsTestCase.fail((String)"Should throw NoSuchMethodException 4");
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of NoSuchMethodException 4"));
        }
        try {
            PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 5");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 5"));
        }
        try {
            PropertyUtils.getIndexedProperty(null, (String)"intIndexed", (int)0);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.getIndexedProperty((Object)this.bean, null, (int)0);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
        try {
            PropertyUtils.getIndexedProperty(null, (String)"intIndexed[0]");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 3");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 3"));
        }
        try {
            PropertyUtils.getIndexedProperty((Object)this.bean, (String)"[0]");
            PropertyUtilsTestCase.fail((String)"Should throw NoSuchMethodException 4");
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of NoSuchMethodException 4"));
        }
        try {
            PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 5");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 5"));
        }
    }

    public void testGetIndexedArray() {
        String[] firstArray = new String[]{"FIRST-1", "FIRST-2", "FIRST-3"};
        String[] secondArray = new String[]{"SECOND-1", "SECOND-2", "SECOND-3", "SECOND-4"};
        String[][] mainArray = new String[][]{firstArray, secondArray};
        TestBean bean = new TestBean(mainArray);
        try {
            PropertyUtilsTestCase.assertEquals((String)"firstArray[0]", (Object)firstArray[0], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[0][0]"));
            PropertyUtilsTestCase.assertEquals((String)"firstArray[1]", (Object)firstArray[1], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[0][1]"));
            PropertyUtilsTestCase.assertEquals((String)"firstArray[2]", (Object)firstArray[2], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[0][2]"));
            PropertyUtilsTestCase.assertEquals((String)"secondArray[0]", (Object)secondArray[0], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[1][0]"));
            PropertyUtilsTestCase.assertEquals((String)"secondArray[1]", (Object)secondArray[1], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[1][1]"));
            PropertyUtilsTestCase.assertEquals((String)"secondArray[2]", (Object)secondArray[2], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[1][2]"));
            PropertyUtilsTestCase.assertEquals((String)"secondArray[3]", (Object)secondArray[3], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[1][3]"));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + ""));
        }
    }

    public void testGetIndexedList() {
        String[] firstArray = new String[]{"FIRST-1", "FIRST-2", "FIRST-3"};
        String[] secondArray = new String[]{"SECOND-1", "SECOND-2", "SECOND-3", "SECOND-4"};
        ArrayList<Object> mainList = new ArrayList<Object>();
        mainList.add(Arrays.asList(firstArray));
        mainList.add(Arrays.asList(secondArray));
        TestBean bean = new TestBean(mainList);
        try {
            PropertyUtilsTestCase.assertEquals((String)"firstArray[0]", (Object)firstArray[0], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[0][0]"));
            PropertyUtilsTestCase.assertEquals((String)"firstArray[1]", (Object)firstArray[1], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[0][1]"));
            PropertyUtilsTestCase.assertEquals((String)"firstArray[2]", (Object)firstArray[2], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[0][2]"));
            PropertyUtilsTestCase.assertEquals((String)"secondArray[0]", (Object)secondArray[0], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[1][0]"));
            PropertyUtilsTestCase.assertEquals((String)"secondArray[1]", (Object)secondArray[1], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[1][1]"));
            PropertyUtilsTestCase.assertEquals((String)"secondArray[2]", (Object)secondArray[2], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[1][2]"));
            PropertyUtilsTestCase.assertEquals((String)"secondArray[3]", (Object)secondArray[3], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[1][3]"));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + ""));
        }
    }

    public void testGetIndexedMap() {
        HashMap<String, String> firstMap = new HashMap<String, String>();
        firstMap.put("FIRST-KEY-1", "FIRST-VALUE-1");
        firstMap.put("FIRST-KEY-2", "FIRST-VALUE-2");
        HashMap<String, String> secondMap = new HashMap<String, String>();
        secondMap.put("SECOND-KEY-1", "SECOND-VALUE-1");
        secondMap.put("SECOND-KEY-2", "SECOND-VALUE-2");
        ArrayList<Object> mainList = new ArrayList<Object>();
        mainList.add(firstMap);
        mainList.add(secondMap);
        TestBean bean = new TestBean(mainList);
        try {
            PropertyUtilsTestCase.assertEquals((String)"listIndexed[0](FIRST-KEY-1)", (Object)"FIRST-VALUE-1", (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[0](FIRST-KEY-1)"));
            PropertyUtilsTestCase.assertEquals((String)"listIndexed[0](FIRST-KEY-2)", (Object)"FIRST-VALUE-2", (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[0](FIRST-KEY-2)"));
            PropertyUtilsTestCase.assertEquals((String)"listIndexed[1](SECOND-KEY-1)", (Object)"SECOND-VALUE-1", (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[1](SECOND-KEY-1)"));
            PropertyUtilsTestCase.assertEquals((String)"listIndexed[1](SECOND-KEY-2)", (Object)"SECOND-VALUE-2", (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[1](SECOND-KEY-2)"));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + ""));
        }
    }

    public void testGetIndexedValues() {
        int i;
        Object value = null;
        for (i = 0; i < 5; ++i) {
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"dupProperty", (int)i);
                PropertyUtilsTestCase.assertNotNull((String)("dupProperty returned value " + i), (Object)value);
                PropertyUtilsTestCase.assertTrue((String)("dupProperty returned String " + i), (boolean)(value instanceof String));
                PropertyUtilsTestCase.assertEquals((String)("dupProperty returned correct " + i), (String)("Dup " + i), (String)((String)value));
            }
            catch (Throwable t) {
                PropertyUtilsTestCase.fail((String)("dupProperty " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)i);
                PropertyUtilsTestCase.assertNotNull((String)("intArray returned value " + i), (Object)value);
                PropertyUtilsTestCase.assertTrue((String)("intArray returned Integer " + i), (boolean)(value instanceof Integer));
                PropertyUtilsTestCase.assertEquals((String)("intArray returned correct " + i), (int)(i * 10), (int)((Integer)value));
            }
            catch (Throwable t) {
                PropertyUtilsTestCase.fail((String)("intArray " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)i);
                PropertyUtilsTestCase.assertNotNull((String)("intIndexed returned value " + i), (Object)value);
                PropertyUtilsTestCase.assertTrue((String)("intIndexed returned Integer " + i), (boolean)(value instanceof Integer));
                PropertyUtilsTestCase.assertEquals((String)("intIndexed returned correct " + i), (int)(i * 10), (int)((Integer)value));
            }
            catch (Throwable t) {
                PropertyUtilsTestCase.fail((String)("intIndexed " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)i);
                PropertyUtilsTestCase.assertNotNull((String)("listIndexed returned value " + i), (Object)value);
                PropertyUtilsTestCase.assertTrue((String)("list returned String " + i), (boolean)(value instanceof String));
                PropertyUtilsTestCase.assertEquals((String)("listIndexed returned correct " + i), (String)("String " + i), (String)((String)value));
            }
            catch (Throwable t) {
                PropertyUtilsTestCase.fail((String)("listIndexed " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)i);
                PropertyUtilsTestCase.assertNotNull((String)("stringArray returned value " + i), (Object)value);
                PropertyUtilsTestCase.assertTrue((String)("stringArray returned String " + i), (boolean)(value instanceof String));
                PropertyUtilsTestCase.assertEquals((String)("stringArray returned correct " + i), (String)("String " + i), (String)((String)value));
            }
            catch (Throwable t) {
                PropertyUtilsTestCase.fail((String)("stringArray " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)i);
                PropertyUtilsTestCase.assertNotNull((String)("stringIndexed returned value " + i), (Object)value);
                PropertyUtilsTestCase.assertTrue((String)("stringIndexed returned String " + i), (boolean)(value instanceof String));
                PropertyUtilsTestCase.assertEquals((String)("stringIndexed returned correct " + i), (String)("String " + i), (String)((String)value));
                continue;
            }
            catch (Throwable t) {
                PropertyUtilsTestCase.fail((String)("stringIndexed " + i + " threw " + t));
            }
        }
        for (i = 0; i < 5; ++i) {
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("dupProperty[" + i + "]"));
                PropertyUtilsTestCase.assertNotNull((String)("dupProperty returned value " + i), (Object)value);
                PropertyUtilsTestCase.assertTrue((String)("dupProperty returned String " + i), (boolean)(value instanceof String));
                PropertyUtilsTestCase.assertEquals((String)("dupProperty returned correct " + i), (String)("Dup " + i), (String)((String)value));
            }
            catch (Throwable t) {
                PropertyUtilsTestCase.fail((String)("dupProperty " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("intArray[" + i + "]"));
                PropertyUtilsTestCase.assertNotNull((String)("intArray returned value " + i), (Object)value);
                PropertyUtilsTestCase.assertTrue((String)("intArray returned Integer " + i), (boolean)(value instanceof Integer));
                PropertyUtilsTestCase.assertEquals((String)("intArray returned correct " + i), (int)(i * 10), (int)((Integer)value));
            }
            catch (Throwable t) {
                PropertyUtilsTestCase.fail((String)("intArray " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("intIndexed[" + i + "]"));
                PropertyUtilsTestCase.assertNotNull((String)("intIndexed returned value " + i), (Object)value);
                PropertyUtilsTestCase.assertTrue((String)("intIndexed returned Integer " + i), (boolean)(value instanceof Integer));
                PropertyUtilsTestCase.assertEquals((String)("intIndexed returned correct " + i), (int)(i * 10), (int)((Integer)value));
            }
            catch (Throwable t) {
                PropertyUtilsTestCase.fail((String)("intIndexed " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("listIndexed[" + i + "]"));
                PropertyUtilsTestCase.assertNotNull((String)("listIndexed returned value " + i), (Object)value);
                PropertyUtilsTestCase.assertTrue((String)("listIndexed returned String " + i), (boolean)(value instanceof String));
                PropertyUtilsTestCase.assertEquals((String)("listIndexed returned correct " + i), (String)("String " + i), (String)((String)value));
            }
            catch (Throwable t) {
                PropertyUtilsTestCase.fail((String)("listIndexed " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("stringArray[" + i + "]"));
                PropertyUtilsTestCase.assertNotNull((String)("stringArray returned value " + i), (Object)value);
                PropertyUtilsTestCase.assertTrue((String)("stringArray returned String " + i), (boolean)(value instanceof String));
                PropertyUtilsTestCase.assertEquals((String)("stringArray returned correct " + i), (String)("String " + i), (String)((String)value));
            }
            catch (Throwable t) {
                PropertyUtilsTestCase.fail((String)("stringArray " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("stringIndexed[" + i + "]"));
                PropertyUtilsTestCase.assertNotNull((String)("stringIndexed returned value " + i), (Object)value);
                PropertyUtilsTestCase.assertTrue((String)("stringIndexed returned String " + i), (boolean)(value instanceof String));
                PropertyUtilsTestCase.assertEquals((String)("stringIndexed returned correct " + i), (String)("String " + i), (String)((String)value));
                continue;
            }
            catch (Throwable t) {
                PropertyUtilsTestCase.fail((String)("stringIndexed " + i + " threw " + t));
            }
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"dupProperty", (int)-1);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException i2) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"dupProperty", (int)5);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)-1);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)5);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)-1);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)5);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)-1);
            PropertyUtilsTestCase.fail((String)"Should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)5);
            PropertyUtilsTestCase.fail((String)"Should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)-1);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)5);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)-1);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)5);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
    }

    public void testGetMappedArguments() {
        try {
            PropertyUtils.getMappedProperty(null, (String)"mappedProperty", (String)"First Key");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.getMappedProperty((Object)this.bean, null, (String)"First Key");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
        try {
            PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", null);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 3");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 3"));
        }
        try {
            PropertyUtils.getMappedProperty(null, (String)"mappedProperty(First Key)");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 4");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 4"));
        }
        try {
            PropertyUtils.getMappedProperty((Object)this.bean, (String)"(Second Key)");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 5");
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of NoSuchMethodException 5"));
        }
        try {
            PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 6");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 6"));
        }
    }

    public void testGetMappedArray() {
        TestBean bean = new TestBean();
        String[] array = new String[]{"abc", "def", "ghi"};
        bean.getMapProperty().put("mappedArray", array);
        try {
            PropertyUtilsTestCase.assertEquals((Object)"abc", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedArray)[0]"));
            PropertyUtilsTestCase.assertEquals((Object)"def", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedArray)[1]"));
            PropertyUtilsTestCase.assertEquals((Object)"ghi", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedArray)[2]"));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + ""));
        }
    }

    public void testGetMappedList() {
        TestBean bean = new TestBean();
        ArrayList<String> list = new ArrayList<String>();
        list.add("klm");
        list.add("nop");
        list.add("qrs");
        bean.getMapProperty().put("mappedList", list);
        try {
            PropertyUtilsTestCase.assertEquals((Object)"klm", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedList)[0]"));
            PropertyUtilsTestCase.assertEquals((Object)"nop", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedList)[1]"));
            PropertyUtilsTestCase.assertEquals((Object)"qrs", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedList)[2]"));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + ""));
        }
    }

    public void testGetMappedMap() {
        TestBean bean = new TestBean();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sub-key-1", "sub-value-1");
        map.put("sub-key-2", "sub-value-2");
        map.put("sub-key-3", "sub-value-3");
        bean.getMapProperty().put("mappedMap", map);
        try {
            PropertyUtilsTestCase.assertEquals((Object)"sub-value-1", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedMap)(sub-key-1)"));
            PropertyUtilsTestCase.assertEquals((Object)"sub-value-2", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedMap)(sub-key-2)"));
            PropertyUtilsTestCase.assertEquals((Object)"sub-value-3", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedMap)(sub-key-3)"));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + ""));
        }
    }

    public void testGetMappedPeriods() {
        this.bean.setMappedProperty("key.with.a.dot", "Special Value");
        PropertyUtilsTestCase.assertEquals((String)"Can retrieve directly", (String)"Special Value", (String)this.bean.getMappedProperty("key.with.a.dot"));
        try {
            PropertyUtilsTestCase.assertEquals((String)"Can retrieve via getMappedProperty", (Object)"Special Value", (Object)PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"key.with.a.dot"));
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
        try {
            PropertyUtilsTestCase.assertEquals((String)"Can retrieve via getNestedProperty", (Object)"Special Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedProperty(key.with.a.dot)"));
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
        this.bean.setMappedObjects("nested.property", new TestBean());
        PropertyUtilsTestCase.assertNotNull((String)"Can retrieve directly", (Object)this.bean.getMappedObjects("nested.property"));
        try {
            PropertyUtilsTestCase.assertEquals((String)"Can retrieve nested", (Object)"This is a string", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedObjects(nested.property).stringProperty"));
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
        try {
            PropertyUtilsTestCase.assertEquals((String)"Can't retrieved nested with mapped property", (Object)"Mapped Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedNested.value(Mapped Key)"));
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
    }

    public void testGetMappedSlashes() {
        this.bean.setMappedProperty("key/with/a/slash", "Special Value");
        PropertyUtilsTestCase.assertEquals((String)"Can retrieve directly", (String)"Special Value", (String)this.bean.getMappedProperty("key/with/a/slash"));
        try {
            PropertyUtilsTestCase.assertEquals((String)"Can retrieve via getMappedProperty", (Object)"Special Value", (Object)PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"key/with/a/slash"));
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
        try {
            PropertyUtilsTestCase.assertEquals((String)"Can retrieve via getNestedProperty", (Object)"Special Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedProperty(key/with/a/slash)"));
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
        this.bean.setMappedObjects("nested/property", new TestBean());
        PropertyUtilsTestCase.assertNotNull((String)"Can retrieve directly", (Object)this.bean.getMappedObjects("nested/property"));
        try {
            PropertyUtilsTestCase.assertEquals((String)"Can retrieve nested", (Object)"This is a string", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedObjects(nested/property).stringProperty"));
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
    }

    public void testGetMappedValues() {
        Object value = null;
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"First Key");
            PropertyUtilsTestCase.assertEquals((String)"Can find first value", (Object)"First Value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding first value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Second Key");
            PropertyUtilsTestCase.assertEquals((String)"Can find second value", (Object)"Second Value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding second value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Third Key");
            PropertyUtilsTestCase.assertNull((String)"Can not find third value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding third value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(First Key)");
            PropertyUtilsTestCase.assertEquals((String)"Can find first value", (Object)"First Value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding first value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Second Key)");
            PropertyUtilsTestCase.assertEquals((String)"Can find second value", (Object)"Second Value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding second value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Third Key)");
            PropertyUtilsTestCase.assertNull((String)"Can not find third value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding third value threw " + t));
        }
        try {
            value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.First Key");
            PropertyUtilsTestCase.assertEquals((String)"Can find first value", (Object)"First Value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding first value threw " + t));
        }
        try {
            value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Second Key");
            PropertyUtilsTestCase.assertEquals((String)"Can find second value", (Object)"Second Value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding second value threw " + t));
        }
        try {
            value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Third Key");
            PropertyUtilsTestCase.assertNull((String)"Can not find third value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding third value threw " + t));
        }
    }

    public void testGetNestedArguments() {
        try {
            PropertyUtils.getNestedProperty(null, (String)"stringProperty");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.getNestedProperty((Object)this.bean, null);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
    }

    public void testGetNestedBoolean() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.booleanProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Boolean));
            PropertyUtilsTestCase.assertTrue((String)"Got correct value", (((Boolean)value).booleanValue() == this.bean.getNested().getBooleanProperty() ? 1 : 0) != 0);
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedDouble() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.doubleProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Double));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (double)((Double)value), (double)this.bean.getNested().getDoubleProperty(), (double)0.005);
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedFloat() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.floatProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Float));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (float)((Float)value).floatValue(), (float)this.bean.getNested().getFloatProperty(), (float)0.005f);
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedInt() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.intProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Integer));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (int)((Integer)value), (int)this.bean.getNested().getIntProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedLong() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.longProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Long));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (long)((Long)value), (long)this.bean.getNested().getLongProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedReadOnly() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.readOnlyProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof String));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (String)((String)value), (String)this.bean.getReadOnlyProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedShort() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.shortProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Short));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (short)((Short)value), (short)this.bean.getNested().getShortProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedString() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.stringProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof String));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (String)((String)value), (String)this.bean.getNested().getStringProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedUnknown() {
        try {
            PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.unknown");
            PropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testGetNestedWriteOnly() {
        try {
            PropertyUtils.getNestedProperty((Object)this.bean, (String)"writeOnlyProperty");
            PropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testGetPropertyType() {
        Class clazz = null;
        int[] intArray = new int[]{};
        String[] stringArray = new String[]{};
        try {
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"booleanProperty");
            PropertyUtilsTestCase.assertEquals((String)"booleanProperty type", Boolean.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"booleanSecond");
            PropertyUtilsTestCase.assertEquals((String)"booleanSecond type", Boolean.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"doubleProperty");
            PropertyUtilsTestCase.assertEquals((String)"doubleProperty type", Double.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"dupProperty");
            PropertyUtilsTestCase.assertEquals((String)"dupProperty type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"floatProperty");
            PropertyUtilsTestCase.assertEquals((String)"floatProperty type", Float.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"intArray");
            PropertyUtilsTestCase.assertEquals((String)"intArray type", intArray.getClass(), (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"intIndexed");
            PropertyUtilsTestCase.assertEquals((String)"intIndexed type", Integer.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"intProperty");
            PropertyUtilsTestCase.assertEquals((String)"intProperty type", Integer.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"listIndexed");
            PropertyUtilsTestCase.assertEquals((String)"listIndexed type", List.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"longProperty");
            PropertyUtilsTestCase.assertEquals((String)"longProperty type", Long.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"mappedProperty");
            PropertyUtilsTestCase.assertEquals((String)"mappedProperty type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"mappedIntProperty");
            PropertyUtilsTestCase.assertEquals((String)"mappedIntProperty type", Integer.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"readOnlyProperty");
            PropertyUtilsTestCase.assertEquals((String)"readOnlyProperty type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"shortProperty");
            PropertyUtilsTestCase.assertEquals((String)"shortProperty type", Short.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"stringArray");
            PropertyUtilsTestCase.assertEquals((String)"stringArray type", stringArray.getClass(), (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"stringIndexed");
            PropertyUtilsTestCase.assertEquals((String)"stringIndexed type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"stringProperty");
            PropertyUtilsTestCase.assertEquals((String)"stringProperty type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"writeOnlyProperty");
            PropertyUtilsTestCase.assertEquals((String)"writeOnlyProperty type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.booleanProperty");
            PropertyUtilsTestCase.assertEquals((String)"booleanProperty type", Boolean.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.booleanSecond");
            PropertyUtilsTestCase.assertEquals((String)"booleanSecond type", Boolean.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.doubleProperty");
            PropertyUtilsTestCase.assertEquals((String)"doubleProperty type", Double.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.dupProperty");
            PropertyUtilsTestCase.assertEquals((String)"dupProperty type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.floatProperty");
            PropertyUtilsTestCase.assertEquals((String)"floatProperty type", Float.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.intArray");
            PropertyUtilsTestCase.assertEquals((String)"intArray type", intArray.getClass(), (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.intIndexed");
            PropertyUtilsTestCase.assertEquals((String)"intIndexed type", Integer.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.intProperty");
            PropertyUtilsTestCase.assertEquals((String)"intProperty type", Integer.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.listIndexed");
            PropertyUtilsTestCase.assertEquals((String)"listIndexed type", List.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.longProperty");
            PropertyUtilsTestCase.assertEquals((String)"longProperty type", Long.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.mappedProperty");
            PropertyUtilsTestCase.assertEquals((String)"mappedProperty type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.mappedIntProperty");
            PropertyUtilsTestCase.assertEquals((String)"mappedIntProperty type", Integer.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.readOnlyProperty");
            PropertyUtilsTestCase.assertEquals((String)"readOnlyProperty type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.shortProperty");
            PropertyUtilsTestCase.assertEquals((String)"shortProperty type", Short.TYPE, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.stringArray");
            PropertyUtilsTestCase.assertEquals((String)"stringArray type", stringArray.getClass(), (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.stringIndexed");
            PropertyUtilsTestCase.assertEquals((String)"stringIndexed type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.stringProperty");
            PropertyUtilsTestCase.assertEquals((String)"stringProperty type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.writeOnlyProperty");
            PropertyUtilsTestCase.assertEquals((String)"writeOnlyProperty type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean");
            PropertyUtilsTestCase.assertEquals((String)"nestedDynaBean type", DynaBean.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean.stringProperty");
            PropertyUtilsTestCase.assertEquals((String)"nestedDynaBean.stringProperty type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean.nestedBean");
            PropertyUtilsTestCase.assertEquals((String)"nestedDynaBean.nestedBean type", TestBean.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean.nestedBean.nestedDynaBean");
            PropertyUtilsTestCase.assertEquals((String)"nestedDynaBean.nestedBean.nestedDynaBean type", DynaBean.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean.nestedBean.nestedDynaBean.stringProperty");
            PropertyUtilsTestCase.assertEquals((String)"nestedDynaBean.nestedBean.nestedDynaBean.stringPropert type", String.class, (Object)clazz);
            clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean.nullDynaBean");
            PropertyUtilsTestCase.assertEquals((String)"nestedDynaBean.nullDynaBean type", DynaBean.class, (Object)clazz);
            try {
                clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean.nullDynaBean.foo");
                PropertyUtilsTestCase.fail((String)"Expected NestedNullException for nestedDynaBean.nullDynaBean.foo");
            }
            catch (NestedNullException nestedNullException) {}
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Exception: " + e.getMessage()));
        }
    }

    public void testGetPublicSubBean_of_PackageBean() {
        PublicSubBean bean = new PublicSubBean();
        bean.setFoo("foo-start");
        bean.setBar("bar-start");
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)bean, (String)"foo");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("getProperty(foo) threw " + t));
        }
        PropertyUtilsTestCase.assertEquals((String)"foo property", (Object)"foo-start", (Object)result);
        try {
            result = PropertyUtils.getProperty((Object)bean, (String)"bar");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("getProperty(bar) threw " + t));
        }
        PropertyUtilsTestCase.assertEquals((String)"bar property", (Object)"bar-start", (Object)result);
    }

    protected void testGetReadMethod(Object bean, String[] properties, String className) {
        PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors((Object)bean);
        String[] stringArray = properties;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String propertie;
            switch (propertie = stringArray[i]) {
                case "intIndexed": {
                    continue block12;
                }
                case "stringIndexed": {
                    continue block12;
                }
                case "writeOnlyProperty": {
                    continue block12;
                }
                default: {
                    int n2 = -1;
                    for (int j = 0; j < pd.length; ++j) {
                        if (!propertie.equals(pd[j].getName())) continue;
                        n2 = j;
                        break;
                    }
                    PropertyUtilsTestCase.assertTrue((String)("PropertyDescriptor for " + propertie), (n2 >= 0 ? 1 : 0) != 0);
                    Method reader = PropertyUtils.getReadMethod((PropertyDescriptor)pd[n2]);
                    PropertyUtilsTestCase.assertNotNull((String)("Reader for " + propertie), (Object)reader);
                    Class<?> clazz = reader.getDeclaringClass();
                    PropertyUtilsTestCase.assertNotNull((String)("Declaring class for " + propertie), clazz);
                    PropertyUtilsTestCase.assertEquals((String)("Correct declaring class for " + propertie), (String)clazz.getName(), (String)className);
                    try {
                        reader.invoke(bean, (Object[])new Class[0]);
                        continue block12;
                    }
                    catch (Throwable t) {
                        PropertyUtilsTestCase.fail((String)("Call for " + propertie + ": " + t));
                    }
                }
            }
        }
    }

    public void testGetReadMethodBasic() {
        this.testGetReadMethod(this.bean, properties, TEST_BEAN_CLASS);
    }

    public void testGetReadMethodPackageSubclass() {
        this.testGetReadMethod(this.beanPackageSubclass, properties, TEST_BEAN_CLASS);
    }

    public void testGetReadMethodPublicInterface() {
        this.testGetReadMethod(this.beanPrivate, new String[]{"bar"}, PRIVATE_DIRECT_CLASS);
        this.testGetReadMethod(this.beanPrivate, new String[]{"baz"}, PRIVATE_INDIRECT_CLASS);
        this.testGetReadMethod(this.beanPrivateSubclass, new String[]{"bar"}, PRIVATE_DIRECT_CLASS);
        this.testGetReadMethod(this.beanPrivateSubclass, new String[]{"baz"}, PRIVATE_INDIRECT_CLASS);
        PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors((Object)this.beanPrivate);
        int n = -1;
        for (int i = 0; i < pd.length; ++i) {
            if (!"foo".equals(pd[i].getName())) continue;
            n = i;
            break;
        }
        PropertyUtilsTestCase.assertTrue((String)"Found foo descriptor", (n >= 0 ? 1 : 0) != 0);
        Method reader = pd[n].getReadMethod();
        PropertyUtilsTestCase.assertNotNull((String)"Found foo read method", (Object)reader);
        try {
            reader.invoke((Object)this.beanPrivate, (Object[])new Class[0]);
            PropertyUtilsTestCase.fail((String)"Foo reader did throw IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Invoke foo reader: " + t));
        }
    }

    public void testGetReadMethodPublicSubclass() {
        this.testGetReadMethod(this.beanPublicSubclass, properties, TEST_BEAN_CLASS);
    }

    public void testGetSetInnerBean() throws Exception {
        BeanWithInnerBean bean = new BeanWithInnerBean();
        PropertyUtils.setProperty((Object)bean, (String)"innerBean.fish(loiterTimer)", (Object)"5");
        String out = (String)PropertyUtils.getProperty((Object)bean.getInnerBean(), (String)"fish(loiterTimer)");
        PropertyUtilsTestCase.assertEquals((String)"(1) Inner class property set/get property failed.", (String)"5", (String)out);
        out = (String)PropertyUtils.getProperty((Object)bean, (String)"innerBean.fish(loiterTimer)");
        PropertyUtilsTestCase.assertEquals((String)"(2) Inner class property set/get property failed.", (String)"5", (String)out);
    }

    public void testGetSetParentBean() throws Exception {
        SonOfAlphaBean bean = new SonOfAlphaBean("Roger");
        String out = (String)PropertyUtils.getProperty((Object)bean, (String)"name");
        PropertyUtilsTestCase.assertEquals((String)"(1) Get/Set On Parent.", (String)"Roger", (String)out);
        PropertyUtils.setProperty((Object)bean, (String)"name", (Object)"abcd");
        PropertyUtilsTestCase.assertEquals((String)"(2) Get/Set On Parent.", (String)"abcd", (String)bean.getName());
    }

    public void testGetSimpleArguments() {
        try {
            PropertyUtils.getSimpleProperty(null, (String)"stringProperty");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.getSimpleProperty((Object)this.bean, null);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
    }

    public void testGetSimpleBoolean() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"booleanProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Boolean));
            PropertyUtilsTestCase.assertTrue((String)"Got correct value", (((Boolean)value).booleanValue() == this.bean.getBooleanProperty() ? 1 : 0) != 0);
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleDouble() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"doubleProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Double));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (double)((Double)value), (double)this.bean.getDoubleProperty(), (double)0.005);
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleFloat() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"floatProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Float));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (float)((Float)value).floatValue(), (float)this.bean.getFloatProperty(), (float)0.005f);
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleIndexed() {
        try {
            PropertyUtils.getSimpleProperty((Object)this.bean, (String)"intIndexed[0]");
            PropertyUtilsTestCase.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleInt() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"intProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Integer));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (int)((Integer)value), (int)this.bean.getIntProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleLong() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"longProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Long));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (long)((Long)value), (long)this.bean.getLongProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleNested() {
        try {
            PropertyUtils.getSimpleProperty((Object)this.bean, (String)"nested.stringProperty");
            PropertyUtilsTestCase.fail((String)"Should have thrown IllegaArgumentException");
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleReadOnly() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"readOnlyProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof String));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (String)((String)value), (String)this.bean.getReadOnlyProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleShort() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"shortProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Short));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (short)((Short)value), (short)this.bean.getShortProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleString() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringProperty");
            PropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof String));
            PropertyUtilsTestCase.assertEquals((String)"Got correct value", (String)((String)value), (String)this.bean.getStringProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleUnknown() {
        try {
            PropertyUtils.getSimpleProperty((Object)this.bean, (String)"unknown");
            PropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.assertEquals((String)("Unknown property 'unknown' on class '" + this.bean.getClass() + "'"), (String)e.getMessage());
        }
    }

    public void testGetSimpleWriteOnly() {
        try {
            PropertyUtils.getSimpleProperty((Object)this.bean, (String)"writeOnlyProperty");
            PropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.assertEquals((String)("Property 'writeOnlyProperty' has no getter method in class '" + this.bean.getClass() + "'"), (String)e.getMessage());
        }
    }

    protected void testGetWriteMethod(Object bean, String[] properties, String className) {
        PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors((Object)bean);
        String[] stringArray = properties;
        int n = stringArray.length;
        block14: for (int i = 0; i < n; ++i) {
            String propertie;
            switch (propertie = stringArray[i]) {
                case "intIndexed": {
                    continue block14;
                }
                case "listIndexed": {
                    continue block14;
                }
                case "nested": {
                    continue block14;
                }
                case "readOnlyProperty": {
                    continue block14;
                }
                case "stringIndexed": {
                    continue block14;
                }
                default: {
                    int n2 = -1;
                    for (int j = 0; j < pd.length; ++j) {
                        if (!propertie.equals(pd[j].getName())) continue;
                        n2 = j;
                        break;
                    }
                    PropertyUtilsTestCase.assertTrue((String)("PropertyDescriptor for " + propertie), (n2 >= 0 ? 1 : 0) != 0);
                    Method writer = PropertyUtils.getWriteMethod((PropertyDescriptor)pd[n2]);
                    PropertyUtilsTestCase.assertNotNull((String)("Writer for " + propertie), (Object)writer);
                    Class<?> clazz = writer.getDeclaringClass();
                    PropertyUtilsTestCase.assertNotNull((String)("Declaring class for " + propertie), clazz);
                    PropertyUtilsTestCase.assertEquals((String)("Correct declaring class for " + propertie), (String)clazz.getName(), (String)className);
                }
            }
        }
    }

    public void testGetWriteMethodBasic() {
        this.testGetWriteMethod(this.bean, properties, TEST_BEAN_CLASS);
    }

    public void testGetWriteMethodPackageSubclass() {
        this.testGetWriteMethod(this.beanPackageSubclass, properties, TEST_BEAN_CLASS);
    }

    public void testGetWriteMethodPublicSubclass() {
        this.testGetWriteMethod(this.beanPublicSubclass, properties, TEST_BEAN_CLASS);
    }

    public void testIsReadable() {
        String property = null;
        try {
            property = "stringProperty";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isReadable expeced TRUE"), (boolean)PropertyUtils.isReadable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isReadable Threw exception: " + t));
        }
        try {
            property = "stringIndexed";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isReadable expeced TRUE"), (boolean)PropertyUtils.isReadable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isReadable Threw exception: " + t));
        }
        try {
            property = "mappedProperty";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isReadable expeced TRUE"), (boolean)PropertyUtils.isReadable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isReadable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isReadable expeced TRUE"), (boolean)PropertyUtils.isReadable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isReadable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean.stringProperty";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isReadable expeced TRUE"), (boolean)PropertyUtils.isReadable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isReadable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean.nestedBean";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isReadable expeced TRUE"), (boolean)PropertyUtils.isReadable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isReadable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean.nestedBean.nestedDynaBean";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isReadable expeced TRUE"), (boolean)PropertyUtils.isReadable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isReadable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean.nestedBean.nestedDynaBean.stringProperty";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isReadable expeced TRUE"), (boolean)PropertyUtils.isReadable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isReadable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean.nullDynaBean";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isReadable expeced TRUE"), (boolean)PropertyUtils.isReadable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isReadable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean.nullDynaBean.foo";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isReadable expeced TRUE"), (boolean)PropertyUtils.isReadable((Object)this.bean, (String)property));
            PropertyUtilsTestCase.fail((String)("Property " + property + " isReadable expected NestedNullException"));
        }
        catch (NestedNullException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isReadable Threw exception: " + t));
        }
    }

    public void testIsWriteable() {
        String property = null;
        try {
            property = "stringProperty";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isWriteable expeced TRUE"), (boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isWriteable Threw exception: " + t));
        }
        try {
            property = "stringIndexed";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isWriteable expeced TRUE"), (boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isWriteable Threw exception: " + t));
        }
        try {
            property = "mappedProperty";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isWriteable expeced TRUE"), (boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isWriteable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isWriteable expeced TRUE"), (boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isWriteable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean.stringProperty";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isWriteable expeced TRUE"), (boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            t.printStackTrace();
            PropertyUtilsTestCase.fail((String)("Property " + property + " isWriteable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean.nestedBean";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isWriteable expeced TRUE"), (boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isWriteable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean.nestedBean.nestedDynaBean";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isWriteable expeced TRUE"), (boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isWriteable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean.nestedBean.nestedDynaBean.stringProperty";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isWriteable expeced TRUE"), (boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isWriteable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean.nullDynaBean";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isWriteable expeced TRUE"), (boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isWriteable Threw exception: " + t));
        }
        try {
            property = "nestedDynaBean.nullDynaBean.foo";
            PropertyUtilsTestCase.assertTrue((String)("Property " + property + " isWriteable expeced TRUE"), (boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property));
            PropertyUtilsTestCase.fail((String)("Property " + property + " isWriteable expected NestedNullException"));
        }
        catch (NestedNullException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Property " + property + " isWriteable Threw exception: " + t));
        }
    }

    public void testMapExtensionCustom() throws Exception {
        PropsFirstPropertyUtilsBean utilsBean = new PropsFirstPropertyUtilsBean();
        ExtendMapBean bean = new ExtendMapBean();
        bean.setUnusuallyNamedProperty("bean value");
        PropertyUtilsTestCase.assertEquals((String)"Set property direct failed", (String)"bean value", (String)bean.getUnusuallyNamedProperty());
        utilsBean.setSimpleProperty(bean, "unusuallyNamedProperty", "new value");
        PropertyUtilsTestCase.assertEquals((String)"Set property on map failed (1)", (String)"new value", (String)bean.getUnusuallyNamedProperty());
        utilsBean.setProperty(bean, "unusuallyNamedProperty", "next value");
        PropertyUtilsTestCase.assertEquals((String)"Set property on map failed (2)", (String)"next value", (String)bean.getUnusuallyNamedProperty());
        PropertyUtilsTestCase.assertEquals((String)"setNestedProperty on non-simple property failed", (Object)"next value", (Object)utilsBean.getNestedProperty(bean, "unusuallyNamedProperty"));
        utilsBean.setProperty(bean, "mapProperty", "value1");
        PropertyUtilsTestCase.assertEquals((String)"setNestedProperty on non-simple property failed", (Object)"value1", (Object)utilsBean.getNestedProperty(bean, "mapProperty"));
        HashMap<String, ExtendMapBean> myMap = new HashMap<String, ExtendMapBean>();
        myMap.put("thebean", bean);
        utilsBean.getNestedProperty(myMap, "thebean.mapitem");
        utilsBean.getNestedProperty(myMap, "thebean(mapitem)");
    }

    public void testMapExtensionDefault() throws Exception {
        ExtendMapBean bean = new ExtendMapBean();
        bean.setUnusuallyNamedProperty("bean value");
        PropertyUtilsTestCase.assertEquals((String)"Set property direct failed", (String)"bean value", (String)bean.getUnusuallyNamedProperty());
        PropertyUtilsTestCase.assertNull((String)"Get on unset map property failed", (Object)PropertyUtils.getNestedProperty((Object)bean, (String)"unusuallyNamedProperty"));
        PropertyUtils.setSimpleProperty((Object)bean, (String)"unusuallyNamedProperty", (Object)"new value");
        PropertyUtilsTestCase.assertEquals((String)"Set property on map failed (1)", (String)"new value", (String)bean.getUnusuallyNamedProperty());
        PropertyUtilsTestCase.assertNull((String)"Get on unset map property failed", (Object)PropertyUtils.getNestedProperty((Object)bean, (String)"unusuallyNamedProperty"));
        PropertyUtils.setProperty((Object)bean, (String)"unusuallyNamedProperty", (Object)"next value");
        PropertyUtilsTestCase.assertEquals((String)"setNestedProperty on map not visible to getNestedProperty", (Object)"next value", (Object)PropertyUtils.getNestedProperty((Object)bean, (String)"unusuallyNamedProperty"));
        PropertyUtilsTestCase.assertEquals((String)"Set nested property on map unexpected affected simple property", (String)"new value", (String)bean.getUnusuallyNamedProperty());
    }

    public void testMappedPropertyType() throws Exception {
        MappedPropertyDescriptor desc = (MappedPropertyDescriptor)PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)"mappedProperty");
        PropertyUtilsTestCase.assertEquals(String.class, (Object)desc.getMappedPropertyType());
        desc = (MappedPropertyDescriptor)PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)"mappedIntProperty");
        PropertyUtilsTestCase.assertEquals(Integer.TYPE, (Object)desc.getMappedPropertyType());
    }

    public void testNestedPropertyKeyOrIndexOnBeanImplementingMap() throws Exception {
        int index;
        HashMap map = new HashMap();
        HashMap submap = new HashMap();
        BetaBean betaBean1 = new BetaBean("test1");
        BetaBean betaBean2 = new BetaBean("test2");
        PropertyUtils.setNestedProperty(map, (String)"submap", submap);
        PropertyUtils.setNestedProperty(map, (String)"submap.beta1", (Object)betaBean1);
        PropertyUtilsTestCase.assertEquals((String)"Unexpected keys in map", (String)"submap", (String)this.keysToString(map));
        PropertyUtilsTestCase.assertEquals((String)"Unexpected keys in submap", (String)"beta1", (String)this.keysToString(submap));
        try {
            PropertyUtils.setNestedProperty(map, (String)"submap(beta2)", (Object)betaBean2);
            PropertyUtilsTestCase.fail((String)"Exception not thrown for invalid setNestedProperty syntax");
        }
        catch (IllegalArgumentException ex) {
            index = ex.getMessage().indexOf("Indexed or mapped properties are not supported");
            PropertyUtilsTestCase.assertTrue((String)"Unexpected exception message", (index >= 0 ? 1 : 0) != 0);
        }
        try {
            PropertyUtils.getNestedProperty(map, (String)"submap[3]");
            PropertyUtilsTestCase.fail((String)"Exception not thrown for invalid setNestedProperty syntax");
        }
        catch (IllegalArgumentException ex) {
            index = ex.getMessage().indexOf("Indexed or mapped properties are not supported");
            PropertyUtilsTestCase.assertTrue((String)"Unexpected exception message", (index >= 0 ? 1 : 0) != 0);
        }
    }

    public void testNestedWithIndex() throws Exception {
        NestedTestBean nestedBean = new NestedTestBean("base");
        nestedBean.init();
        nestedBean.getSimpleBeanProperty().init();
        NestedTestBean value = (NestedTestBean)PropertyUtils.getProperty((Object)nestedBean, (String)"indexedProperty[0]");
        PropertyUtilsTestCase.assertEquals((String)"Cannot get simple index(1)", (String)"Bean@0", (String)value.getName());
        PropertyUtilsTestCase.assertEquals((String)"Bug in NestedTestBean", (String)"NOT SET", (String)value.getTestString());
        value = (NestedTestBean)PropertyUtils.getProperty((Object)nestedBean, (String)"indexedProperty[1]");
        PropertyUtilsTestCase.assertEquals((String)"Cannot get simple index(1)", (String)"Bean@1", (String)value.getName());
        PropertyUtilsTestCase.assertEquals((String)"Bug in NestedTestBean", (String)"NOT SET", (String)value.getTestString());
        String prop = (String)PropertyUtils.getProperty((Object)nestedBean, (String)"indexedProperty[0].testString");
        PropertyUtilsTestCase.assertEquals((String)"Get property on indexes failed (1)", (String)"NOT SET", (String)prop);
        prop = (String)PropertyUtils.getProperty((Object)nestedBean, (String)"indexedProperty[1].testString");
        PropertyUtilsTestCase.assertEquals((String)"Get property on indexes failed (2)", (String)"NOT SET", (String)prop);
        PropertyUtils.setProperty((Object)nestedBean, (String)"indexedProperty[0].testString", (Object)"Test#1");
        PropertyUtilsTestCase.assertEquals((String)"Cannot set property on indexed bean (1)", (String)"Test#1", (String)nestedBean.getIndexedProperty(0).getTestString());
        PropertyUtils.setProperty((Object)nestedBean, (String)"indexedProperty[1].testString", (Object)"Test#2");
        PropertyUtilsTestCase.assertEquals((String)"Cannot set property on indexed bean (2)", (String)"Test#2", (String)nestedBean.getIndexedProperty(1).getTestString());
        value = (NestedTestBean)PropertyUtils.getProperty((Object)nestedBean, (String)"simpleBeanProperty");
        PropertyUtilsTestCase.assertEquals((String)"Cannot get simple bean", (String)"Simple Property Bean", (String)value.getName());
        PropertyUtilsTestCase.assertEquals((String)"Bug in NestedTestBean", (String)"NOT SET", (String)value.getTestString());
        value = (NestedTestBean)PropertyUtils.getProperty((Object)nestedBean, (String)"simpleBeanProperty.indexedProperty[3]");
        PropertyUtilsTestCase.assertEquals((String)"Cannot get index property on property", (String)"Bean@3", (String)value.getName());
        PropertyUtilsTestCase.assertEquals((String)"Bug in NestedTestBean", (String)"NOT SET", (String)value.getTestString());
        PropertyUtils.setProperty((Object)nestedBean, (String)"simpleBeanProperty.indexedProperty[3].testString", (Object)"Test#3");
        PropertyUtilsTestCase.assertEquals((String)"Cannot set property on indexed property on property", (String)"Test#3", (String)nestedBean.getSimpleBeanProperty().getIndexedProperty(3).getTestString());
    }

    public void testRemoveBeanIntrospector() {
        PropertyUtilsTestCase.assertTrue((String)"Wrong result", (boolean)PropertyUtils.removeBeanIntrospector((BeanIntrospector)DefaultBeanIntrospector.INSTANCE));
        PropertyDescriptor[] desc = PropertyUtils.getPropertyDescriptors(AlphaBean.class);
        PropertyUtilsTestCase.assertEquals((String)"Got descriptors", (int)0, (int)desc.length);
        PropertyUtils.addBeanIntrospector((BeanIntrospector)DefaultBeanIntrospector.INSTANCE);
    }

    public void testResetBeanIntrospectors() {
        PropertyUtilsTestCase.assertTrue((String)"Wrong result", (boolean)PropertyUtils.removeBeanIntrospector((BeanIntrospector)DefaultBeanIntrospector.INSTANCE));
        PropertyUtils.resetBeanIntrospectors();
        PropertyDescriptor[] desc = PropertyUtils.getPropertyDescriptors(AlphaBean.class);
        PropertyUtilsTestCase.assertTrue((String)"Got no descriptors", (desc.length > 0 ? 1 : 0) != 0);
    }

    public void testSetIndexedArguments() {
        try {
            PropertyUtils.setIndexedProperty(null, (String)"intArray", (int)0, (Object)1);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, null, (int)0, (Object)1);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
        try {
            PropertyUtils.setIndexedProperty(null, (String)"intArray[0]", (Object)1);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 3");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 3"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"[0]", (Object)1);
            PropertyUtilsTestCase.fail((String)"Should throw NoSuchMethodException 4");
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of NoSuchMethodException 4"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (Object)1);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 5");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 5"));
        }
        try {
            PropertyUtils.setIndexedProperty(null, (String)"intIndexed", (int)0, (Object)1);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, null, (int)0, (Object)1);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
        try {
            PropertyUtils.setIndexedProperty(null, (String)"intIndexed[0]", (Object)1);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 3");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 3"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"[0]", (Object)1);
            PropertyUtilsTestCase.fail((String)"Should throw NoSuchMethodException 4");
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of NoSuchMethodException 4"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (Object)1);
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 5");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 5"));
        }
    }

    public void testSetIndexedArray() {
        String[] firstArray = new String[]{"FIRST-1", "FIRST-2", "FIRST-3"};
        String[] secondArray = new String[]{"SECOND-1", "SECOND-2", "SECOND-3", "SECOND-4"};
        String[][] mainArray = new String[][]{firstArray, secondArray};
        TestBean bean = new TestBean(mainArray);
        PropertyUtilsTestCase.assertEquals((String)"BEFORE", (String)"SECOND-3", (String)bean.getString2dArray(1)[2]);
        try {
            PropertyUtils.setProperty((Object)bean, (String)"string2dArray[1][2]", (Object)"SECOND-3-UPDATED");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + ""));
        }
        PropertyUtilsTestCase.assertEquals((String)"AFTER", (String)"SECOND-3-UPDATED", (String)bean.getString2dArray(1)[2]);
    }

    public void testSetIndexedList() {
        String[] firstArray = new String[]{"FIRST-1", "FIRST-2", "FIRST-3"};
        String[] secondArray = new String[]{"SECOND-1", "SECOND-2", "SECOND-3", "SECOND-4"};
        ArrayList<Object> mainList = new ArrayList<Object>();
        mainList.add(Arrays.asList(firstArray));
        mainList.add(Arrays.asList(secondArray));
        TestBean bean = new TestBean(mainList);
        PropertyUtilsTestCase.assertEquals((String)"BEFORE", (Object)"SECOND-4", ((List)bean.getListIndexed().get(1)).get(3));
        try {
            PropertyUtils.setProperty((Object)bean, (String)"listIndexed[1][3]", (Object)"SECOND-4-UPDATED");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + ""));
        }
        PropertyUtilsTestCase.assertEquals((String)"AFTER", (Object)"SECOND-4-UPDATED", ((List)bean.getListIndexed().get(1)).get(3));
    }

    public void testSetIndexedMap() {
        HashMap<String, String> firstMap = new HashMap<String, String>();
        firstMap.put("FIRST-KEY-1", "FIRST-VALUE-1");
        firstMap.put("FIRST-KEY-2", "FIRST-VALUE-2");
        HashMap<String, String> secondMap = new HashMap<String, String>();
        secondMap.put("SECOND-KEY-1", "SECOND-VALUE-1");
        secondMap.put("SECOND-KEY-2", "SECOND-VALUE-2");
        ArrayList<Object> mainList = new ArrayList<Object>();
        mainList.add(firstMap);
        mainList.add(secondMap);
        TestBean bean = new TestBean(mainList);
        PropertyUtilsTestCase.assertEquals((String)"BEFORE", null, ((Map)bean.getListIndexed().get(0)).get("FIRST-NEW-KEY"));
        PropertyUtilsTestCase.assertEquals((String)"BEFORE", (Object)"SECOND-VALUE-1", ((Map)bean.getListIndexed().get(1)).get("SECOND-KEY-1"));
        try {
            PropertyUtils.setProperty((Object)bean, (String)"listIndexed[0](FIRST-NEW-KEY)", (Object)"FIRST-NEW-VALUE");
            PropertyUtils.setProperty((Object)bean, (String)"listIndexed[1](SECOND-KEY-1)", (Object)"SECOND-VALUE-1-UPDATED");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + ""));
        }
        PropertyUtilsTestCase.assertEquals((String)"BEFORE", (Object)"FIRST-NEW-VALUE", ((Map)bean.getListIndexed().get(0)).get("FIRST-NEW-KEY"));
        PropertyUtilsTestCase.assertEquals((String)"AFTER", (Object)"SECOND-VALUE-1-UPDATED", ((Map)bean.getListIndexed().get(1)).get("SECOND-KEY-1"));
    }

    public void testSetIndexedValues() {
        Object value = null;
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"dupProperty", (int)0, (Object)"New 0");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"dupProperty", (int)0);
            PropertyUtilsTestCase.assertNotNull((String)"Returned new value 0", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Returned String new value 0", (boolean)(value instanceof String));
            PropertyUtilsTestCase.assertEquals((String)"Returned correct new value 0", (String)"New 0", (String)((String)value));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (int)0, (Object)1);
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)0);
            PropertyUtilsTestCase.assertNotNull((String)"Returned new value 0", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Returned Integer new value 0", (boolean)(value instanceof Integer));
            PropertyUtilsTestCase.assertEquals((String)"Returned correct new value 0", (int)1, (int)((Integer)value));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (int)1, (Object)11);
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)1);
            PropertyUtilsTestCase.assertNotNull((String)"Returned new value 1", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Returned Integer new value 1", (boolean)(value instanceof Integer));
            PropertyUtilsTestCase.assertEquals((String)"Returned correct new value 1", (int)11, (int)((Integer)value));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed", (int)2, (Object)"New Value 2");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)2);
            PropertyUtilsTestCase.assertNotNull((String)"Returned new value 2", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Returned String new value 2", (boolean)(value instanceof String));
            PropertyUtilsTestCase.assertEquals((String)"Returned correct new value 2", (String)"New Value 2", (String)((String)value));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)2, (Object)"New Value 2");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)2);
            PropertyUtilsTestCase.assertNotNull((String)"Returned new value 2", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Returned String new value 2", (boolean)(value instanceof String));
            PropertyUtilsTestCase.assertEquals((String)"Returned correct new value 2", (String)"New Value 2", (String)((String)value));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)3, (Object)"New Value 3");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)3);
            PropertyUtilsTestCase.assertNotNull((String)"Returned new value 3", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Returned String new value 3", (boolean)(value instanceof String));
            PropertyUtilsTestCase.assertEquals((String)"Returned correct new value 3", (String)"New Value 3", (String)((String)value));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"dupProperty[4]", (Object)"New 4");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"dupProperty[4]");
            PropertyUtilsTestCase.assertNotNull((String)"Returned new value 4", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Returned String new value 4", (boolean)(value instanceof String));
            PropertyUtilsTestCase.assertEquals((String)"Returned correct new value 4", (String)"New 4", (String)((String)value));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray[4]", (Object)1);
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray[4]");
            PropertyUtilsTestCase.assertNotNull((String)"Returned new value 4", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Returned Integer new value 4", (boolean)(value instanceof Integer));
            PropertyUtilsTestCase.assertEquals((String)"Returned correct new value 4", (int)1, (int)((Integer)value));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed[3]", (Object)11);
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed[3]");
            PropertyUtilsTestCase.assertNotNull((String)"Returned new value 5", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Returned Integer new value 5", (boolean)(value instanceof Integer));
            PropertyUtilsTestCase.assertEquals((String)"Returned correct new value 5", (int)11, (int)((Integer)value));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed[1]", (Object)"New Value 2");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed[1]");
            PropertyUtilsTestCase.assertNotNull((String)"Returned new value 6", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Returned String new value 6", (boolean)(value instanceof String));
            PropertyUtilsTestCase.assertEquals((String)"Returned correct new value 6", (String)"New Value 2", (String)((String)value));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray[1]", (Object)"New Value 2");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray[2]");
            PropertyUtilsTestCase.assertNotNull((String)"Returned new value 6", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Returned String new value 6", (boolean)(value instanceof String));
            PropertyUtilsTestCase.assertEquals((String)"Returned correct new value 6", (String)"New Value 2", (String)((String)value));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray[0]", (Object)"New Value 3");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray[0]");
            PropertyUtilsTestCase.assertNotNull((String)"Returned new value 7", (Object)value);
            PropertyUtilsTestCase.assertTrue((String)"Returned String new value 7", (boolean)(value instanceof String));
            PropertyUtilsTestCase.assertEquals((String)"Returned correct new value 7", (String)"New Value 3", (String)((String)value));
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"dupProperty", (int)-1, (Object)"New -1");
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"dupProperty", (int)5, (Object)"New 5");
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (int)-1, (Object)0);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (int)5, (Object)0);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (int)-1, (Object)0);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (int)5, (Object)0);
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed", (int)5, (Object)"New String");
            PropertyUtilsTestCase.fail((String)"Should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed", (int)-1, (Object)"New String");
            PropertyUtilsTestCase.fail((String)"Should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)-1, (Object)"New String");
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)5, (Object)"New String");
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)-1, (Object)"New String");
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)5, (Object)"New String");
            PropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
    }

    public void testSetMappedArguments() {
        try {
            PropertyUtils.setMappedProperty(null, (String)"mappedProperty", (String)"First Key", (Object)"First Value");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, null, (String)"First Key", (Object)"First Value");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", null, (Object)"First Value");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 3");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 3"));
        }
        try {
            PropertyUtils.setMappedProperty(null, (String)"mappedProperty(First Key)", (Object)"First Value");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 4");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 4"));
        }
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, (String)"(Second Key)", (Object)"Second Value");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 5");
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of NoSuchMethodException 5"));
        }
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", (Object)"Third Value");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 6");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 6"));
        }
    }

    public void testSetMappedArray() {
        TestBean bean = new TestBean();
        String[] array = new String[]{"abc", "def", "ghi"};
        bean.getMapProperty().put("mappedArray", array);
        PropertyUtilsTestCase.assertEquals((String)"BEFORE", (String)"def", (String)((String[])bean.getMapProperty().get("mappedArray"))[1]);
        try {
            PropertyUtils.setProperty((Object)bean, (String)"mapProperty(mappedArray)[1]", (Object)"DEF-UPDATED");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + ""));
        }
        PropertyUtilsTestCase.assertEquals((String)"AFTER", (String)"DEF-UPDATED", (String)((String[])bean.getMapProperty().get("mappedArray"))[1]);
    }

    public void testSetMappedList() {
        TestBean bean = new TestBean();
        ArrayList<String> list = new ArrayList<String>();
        list.add("klm");
        list.add("nop");
        list.add("qrs");
        bean.getMapProperty().put("mappedList", list);
        PropertyUtilsTestCase.assertEquals((String)"BEFORE", (Object)"klm", ((List)bean.getMapProperty().get("mappedList")).get(0));
        try {
            PropertyUtils.setProperty((Object)bean, (String)"mapProperty(mappedList)[0]", (Object)"KLM-UPDATED");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + ""));
        }
        PropertyUtilsTestCase.assertEquals((String)"AFTER", (Object)"KLM-UPDATED", ((List)bean.getMapProperty().get("mappedList")).get(0));
    }

    public void testSetMappedMap() {
        TestBean bean = new TestBean();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sub-key-1", "sub-value-1");
        map.put("sub-key-2", "sub-value-2");
        map.put("sub-key-3", "sub-value-3");
        bean.getMapProperty().put("mappedMap", map);
        PropertyUtilsTestCase.assertEquals((String)"BEFORE", (Object)"sub-value-3", ((Map)bean.getMapProperty().get("mappedMap")).get("sub-key-3"));
        try {
            PropertyUtils.setProperty((Object)bean, (String)"mapProperty(mappedMap)(sub-key-3)", (Object)"SUB-KEY-3-UPDATED");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + ""));
        }
        PropertyUtilsTestCase.assertEquals((String)"AFTER", (Object)"SUB-KEY-3-UPDATED", ((Map)bean.getMapProperty().get("mappedMap")).get("sub-key-3"));
    }

    public void testSetMappedPeriods() {
        this.bean.setMappedProperty("key.with.a.dot", "Special Value");
        PropertyUtilsTestCase.assertEquals((String)"Can retrieve directly (A)", (String)"Special Value", (String)this.bean.getMappedProperty("key.with.a.dot"));
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"key.with.a.dot", (Object)"Updated Special Value");
            PropertyUtilsTestCase.assertEquals((String)"Check set via setMappedProperty", (String)"Updated Special Value", (String)this.bean.getMappedProperty("key.with.a.dot"));
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
        this.bean.setMappedProperty("key.with.a.dot", "Special Value");
        PropertyUtilsTestCase.assertEquals((String)"Can retrieve directly (B)", (String)"Special Value", (String)this.bean.getMappedProperty("key.with.a.dot"));
        try {
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"mappedProperty(key.with.a.dot)", (Object)"Updated Special Value");
            PropertyUtilsTestCase.assertEquals((String)"Check set via setNestedProperty (B)", (String)"Updated Special Value", (String)this.bean.getMappedProperty("key.with.a.dot"));
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
        TestBean testBean = new TestBean();
        this.bean.setMappedObjects("nested.property", testBean);
        PropertyUtilsTestCase.assertEquals((String)"Can retrieve directly (C)", (String)"This is a string", (String)testBean.getStringProperty());
        try {
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"mappedObjects(nested.property).stringProperty", (Object)"Updated String Value");
            PropertyUtilsTestCase.assertEquals((String)"Check set via setNestedProperty (C)", (String)"Updated String Value", (String)testBean.getStringProperty());
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
        this.bean.getNested().setMappedProperty("Mapped Key", "Nested Mapped Value");
        try {
            PropertyUtilsTestCase.assertEquals((String)"Can retrieve via getNestedProperty (D)", (Object)"Nested Mapped Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.mappedProperty(Mapped Key)"));
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.mappedProperty(Mapped Key)", (Object)"Updated Nested Mapped Value");
            PropertyUtilsTestCase.assertEquals((String)"Check set via setNestedProperty (D)", (Object)"Updated Nested Mapped Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.mappedProperty(Mapped Key)"));
        }
        catch (Exception e) {
            PropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
    }

    public void testSetMappedValues() {
        Object value = null;
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Fourth Key");
            PropertyUtilsTestCase.assertNull((String)"Can not find fourth value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding fourth value threw " + t));
        }
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Fourth Key", (Object)"Fourth Value");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Setting fourth value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Fourth Key");
            PropertyUtilsTestCase.assertEquals((String)"Can find fourth value", (Object)"Fourth Value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding fourth value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Fifth Key)");
            PropertyUtilsTestCase.assertNull((String)"Can not find fifth value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding fifth value threw " + t));
        }
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty(Fifth Key)", (Object)"Fifth Value");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Setting fifth value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Fifth Key)");
            PropertyUtilsTestCase.assertEquals((String)"Can find fifth value", (Object)"Fifth Value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding fifth value threw " + t));
        }
        try {
            value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Sixth Key");
            PropertyUtilsTestCase.assertNull((String)"Can not find sixth value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding fifth value threw " + t));
        }
        try {
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"mapProperty.Sixth Key", (Object)"Sixth Value");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Setting sixth value threw " + t));
        }
        try {
            value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Sixth Key");
            PropertyUtilsTestCase.assertEquals((String)"Can find sixth value", (Object)"Sixth Value", (Object)value);
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Finding sixth value threw " + t));
        }
    }

    public void testSetNestedArguments() {
        try {
            PropertyUtils.setNestedProperty(null, (String)"stringProperty", (Object)"");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.setNestedProperty((Object)this.bean, null, (Object)"");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
    }

    public void testSetNestedBoolean() {
        try {
            boolean oldValue = this.bean.getNested().getBooleanProperty();
            boolean newValue = !oldValue;
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.booleanProperty", (Object)newValue);
            PropertyUtilsTestCase.assertTrue((String)"Matched new value", (newValue == this.bean.getNested().getBooleanProperty() ? 1 : 0) != 0);
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedDouble() {
        try {
            double oldValue = this.bean.getNested().getDoubleProperty();
            double newValue = oldValue + 1.0;
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.doubleProperty", (Object)newValue);
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (double)newValue, (double)this.bean.getNested().getDoubleProperty(), (double)0.005);
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedFloat() {
        try {
            float oldValue = this.bean.getNested().getFloatProperty();
            float newValue = oldValue + 1.0f;
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.floatProperty", (Object)Float.valueOf(newValue));
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (float)newValue, (float)this.bean.getNested().getFloatProperty(), (float)0.005f);
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedInt() {
        try {
            int oldValue = this.bean.getNested().getIntProperty();
            int newValue = oldValue + 1;
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.intProperty", (Object)newValue);
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (int)newValue, (int)this.bean.getNested().getIntProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedLong() {
        try {
            long oldValue = this.bean.getNested().getLongProperty();
            long newValue = oldValue + 1L;
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.longProperty", (Object)newValue);
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (long)newValue, (long)this.bean.getNested().getLongProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedReadOnly() {
        try {
            String oldValue = this.bean.getNested().getWriteOnlyPropertyValue();
            String newValue = oldValue + " Extra Value";
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.readOnlyProperty", (Object)newValue);
            PropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testSetNestedShort() {
        try {
            short oldValue;
            short newValue = oldValue = this.bean.getNested().getShortProperty();
            newValue = (short)(newValue + 1);
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.shortProperty", (Object)newValue);
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (short)newValue, (short)this.bean.getNested().getShortProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedString() {
        try {
            String oldValue = this.bean.getNested().getStringProperty();
            String newValue = oldValue + " Extra Value";
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.stringProperty", (Object)newValue);
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (String)newValue, (String)this.bean.getNested().getStringProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedUnknown() {
        try {
            String newValue = "New String Value";
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.unknown", (Object)"New String Value");
            PropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testSetNestedWriteOnly() {
        try {
            String oldValue = this.bean.getNested().getWriteOnlyPropertyValue();
            String newValue = oldValue + " Extra Value";
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.writeOnlyProperty", (Object)newValue);
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (String)newValue, (String)this.bean.getNested().getWriteOnlyPropertyValue());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNoGetter() throws Exception {
        BetaBean bean = new BetaBean("Cedric");
        bean.setNoGetterProperty("Sigma");
        PropertyUtilsTestCase.assertEquals((String)"BetaBean test failed", (String)"Sigma", (String)bean.getSecret());
        PropertyUtilsTestCase.assertNotNull((String)"Descriptor is null", (Object)PropertyUtils.getPropertyDescriptor((Object)bean, (String)"noGetterProperty"));
        BeanUtils.setProperty((Object)bean, (String)"noGetterProperty", (Object)"Omega");
        PropertyUtilsTestCase.assertEquals((String)"Cannot set no-getter property", (String)"Omega", (String)bean.getSecret());
        PropertyUtilsTestCase.assertNotNull((String)"Map Descriptor is null", (Object)PropertyUtils.getPropertyDescriptor((Object)bean, (String)"noGetterMappedProperty"));
        PropertyUtils.setMappedProperty((Object)bean, (String)"noGetterMappedProperty", (String)"Epsilon", (Object)"Epsilon");
        PropertyUtilsTestCase.assertEquals((String)"Cannot set mapped no-getter property", (String)"MAP:Epsilon", (String)bean.getSecret());
    }

    public void testSetPublicSubBean_of_PackageBean() {
        PublicSubBean bean = new PublicSubBean();
        bean.setFoo("foo-start");
        bean.setBar("bar-start");
        try {
            PropertyUtils.setProperty((Object)bean, (String)"foo", (Object)"foo-updated");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("setProperty(foo) threw " + t));
        }
        PropertyUtilsTestCase.assertEquals((String)"foo property", (String)"foo-updated", (String)bean.getFoo());
        try {
            PropertyUtils.setProperty((Object)bean, (String)"bar", (Object)"bar-updated");
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("setProperty(bar) threw " + t));
        }
        PropertyUtilsTestCase.assertEquals((String)"bar property", (String)"bar-updated", (String)bean.getBar());
    }

    public void testSetSimpleArguments() {
        try {
            PropertyUtils.setSimpleProperty(null, (String)"stringProperty", (Object)"");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.setSimpleProperty((Object)this.bean, null, (Object)"");
            PropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            PropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
    }

    public void testSetSimpleBoolean() {
        try {
            boolean oldValue = this.bean.getBooleanProperty();
            boolean newValue = !oldValue;
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"booleanProperty", (Object)newValue);
            PropertyUtilsTestCase.assertTrue((String)"Matched new value", (newValue == this.bean.getBooleanProperty() ? 1 : 0) != 0);
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleDouble() {
        try {
            double oldValue = this.bean.getDoubleProperty();
            double newValue = oldValue + 1.0;
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"doubleProperty", (Object)newValue);
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (double)newValue, (double)this.bean.getDoubleProperty(), (double)0.005);
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleFloat() {
        try {
            float oldValue = this.bean.getFloatProperty();
            float newValue = oldValue + 1.0f;
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"floatProperty", (Object)Float.valueOf(newValue));
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (float)newValue, (float)this.bean.getFloatProperty(), (float)0.005f);
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleIndexed() {
        try {
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"stringIndexed[0]", (Object)"New String Value");
            PropertyUtilsTestCase.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleInt() {
        try {
            int oldValue = this.bean.getIntProperty();
            int newValue = oldValue + 1;
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"intProperty", (Object)newValue);
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (int)newValue, (int)this.bean.getIntProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleLong() {
        try {
            long oldValue = this.bean.getLongProperty();
            long newValue = oldValue + 1L;
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"longProperty", (Object)newValue);
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (long)newValue, (long)this.bean.getLongProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleNested() {
        try {
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"nested.stringProperty", (Object)"New String Value");
            PropertyUtilsTestCase.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleReadOnly() {
        try {
            String oldValue = this.bean.getWriteOnlyPropertyValue();
            String newValue = oldValue + " Extra Value";
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"readOnlyProperty", (Object)newValue);
            PropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.assertEquals((String)("Property 'readOnlyProperty' has no setter method in class '" + this.bean.getClass() + "'"), (String)e.getMessage());
        }
    }

    public void testSetSimpleShort() {
        try {
            short oldValue;
            short newValue = oldValue = this.bean.getShortProperty();
            newValue = (short)(newValue + 1);
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"shortProperty", (Object)newValue);
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (short)newValue, (short)this.bean.getShortProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleString() {
        try {
            String oldValue = this.bean.getStringProperty();
            String newValue = oldValue + " Extra Value";
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"stringProperty", (Object)newValue);
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (String)newValue, (String)this.bean.getStringProperty());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleUnknown() {
        try {
            String newValue = "New String Value";
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"unknown", (Object)"New String Value");
            PropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.assertEquals((String)("Unknown property 'unknown' on class '" + this.bean.getClass() + "'"), (String)e.getMessage());
        }
    }

    public void testSetSimpleWriteOnly() {
        try {
            String oldValue = this.bean.getWriteOnlyPropertyValue();
            String newValue = oldValue + " Extra Value";
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"writeOnlyProperty", (Object)newValue);
            PropertyUtilsTestCase.assertEquals((String)"Matched new value", (String)newValue, (String)this.bean.getWriteOnlyPropertyValue());
        }
        catch (IllegalAccessException e) {
            PropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            PropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            PropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            PropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testThrowNestedNull() throws Exception {
        NestedTestBean nestedBean = new NestedTestBean("base");
        try {
            PropertyUtils.getProperty((Object)nestedBean, (String)"simpleBeanProperty.indexedProperty[0]");
            PropertyUtilsTestCase.fail((String)"NestedNullException not thrown");
        }
        catch (NestedNullException nestedNullException) {
            // empty catch block
        }
    }
}

