/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.TesterClassLoader;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;
import org.apache.commons.dbcp2.managed.DataSourceXAConnectionFactory;
import org.apache.commons.dbcp2.managed.ManagedDataSource;
import org.apache.commons.dbcp2.managed.TesterBasicXAConnection;
import org.apache.commons.dbcp2.transaction.TransactionAdapter;
import org.apache.commons.dbcp2.transaction.TransactionManagerAdapter;
import org.apache.commons.dbcp2.transaction.TransactionSynchronizationRegistryAdapter;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSynchronizationOrder {
    private boolean transactionManagerRegistered;
    private boolean transactionSynchronizationRegistryRegistered;
    private TransactionManager transactionManager;
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private XADataSource xads;
    private BasicManagedDataSource bmds;
    private BasicDataSource bds;

    @BeforeEach
    public void setup() {
        this.transactionManager = new TransactionManagerAdapter(){
            private Transaction transaction;

            @Override
            public void begin() throws NotSupportedException, SystemException {
                this.transaction = new TransactionAdapter(){

                    @Override
                    public boolean enlistResource(XAResource xaResource) throws IllegalStateException, RollbackException, SystemException {
                        return true;
                    }

                    @Override
                    public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, RollbackException, SystemException {
                        TestSynchronizationOrder.this.transactionManagerRegistered = true;
                    }
                };
            }

            @Override
            public Transaction getTransaction() throws SystemException {
                return this.transaction;
            }
        };
        this.transactionSynchronizationRegistry = new TransactionSynchronizationRegistryAdapter(){

            @Override
            public void registerInterposedSynchronization(Synchronization synchronization) {
                TestSynchronizationOrder.this.transactionSynchronizationRegistryRegistered = true;
            }
        };
        this.bmds = new BasicManagedDataSource();
        this.bmds.setTransactionManager(this.transactionManager);
        this.bmds.setTransactionSynchronizationRegistry(this.transactionSynchronizationRegistry);
        this.bmds.setXADataSource("notnull");
        this.bds = new BasicDataSource();
        this.bds.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
        this.bds.setUrl("jdbc:apache:commons:testdriver");
        this.bds.setMaxTotal(10);
        this.bds.setMaxWait(Duration.ofMillis(100L));
        this.bds.setDefaultAutoCommit(Boolean.TRUE);
        this.bds.setDefaultReadOnly(Boolean.FALSE);
        this.bds.setDefaultTransactionIsolation(2);
        this.bds.setDefaultCatalog("test catalog");
        this.bds.setUsername("userName");
        this.bds.setPassword("password");
        this.bds.setValidationQuery("SELECT DUMMY FROM DUAL");
        this.bds.setConnectionInitSqls(Arrays.asList("SELECT 1", "SELECT 2"));
        this.bds.setDriverClassLoader((ClassLoader)new TesterClassLoader());
        this.bds.setJmxName("org.apache.commons.dbcp2:name=test");
        final AtomicInteger closeCounter = new AtomicInteger();
        InvocationHandler handle = new InvocationHandler(){

            protected XAConnection getXAConnection() throws SQLException {
                return new TesterBasicXAConnection(TestSynchronizationOrder.this.bds.getConnection(), closeCounter);
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName;
                switch (methodName = method.getName()) {
                    case "hashCode": {
                        return System.identityHashCode(proxy);
                    }
                    case "equals": {
                        return proxy == args[0];
                    }
                    case "getXAConnection": {
                        return this.getXAConnection();
                    }
                }
                try {
                    return method.invoke((Object)TestSynchronizationOrder.this.bds, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        };
        this.xads = (XADataSource)Proxy.newProxyInstance(TestSynchronizationOrder.class.getClassLoader(), new Class[]{XADataSource.class}, handle);
        this.bmds.setXaDataSourceInstance(this.xads);
    }

    @AfterEach
    public void tearDown() throws SQLException {
        this.bds.close();
        this.bmds.close();
    }

    @Test
    public void testInterposedSynchronization() throws Exception {
        DataSourceXAConnectionFactory xaConnectionFactory = new DataSourceXAConnectionFactory(this.transactionManager, this.xads, this.transactionSynchronizationRegistry);
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)xaConnectionFactory, null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setDefaultReadOnly(Boolean.TRUE);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            factory.setPool((ObjectPool)pool);
            pool.setMaxTotal(10);
            pool.setMaxWait(Duration.ofSeconds(1L));
            try (ManagedDataSource ds = new ManagedDataSource((ObjectPool)pool, xaConnectionFactory.getTransactionRegistry());){
                ds.setAccessToUnderlyingConnectionAllowed(true);
                this.transactionManager.begin();
                try (Connection connectionA = ds.getConnection();){
                    Assertions.assertInstanceOf(DelegatingConnection.class, (Object)connectionA);
                }
                this.transactionManager.commit();
                Assertions.assertFalse((boolean)this.transactionManagerRegistered);
                Assertions.assertTrue((boolean)this.transactionSynchronizationRegistryRegistered);
            }
        }
    }

    @Test
    public void testSessionSynchronization() throws Exception {
        DataSourceXAConnectionFactory xaConnectionFactory = new DataSourceXAConnectionFactory(this.transactionManager, this.xads);
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)xaConnectionFactory, null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setDefaultReadOnly(Boolean.TRUE);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            factory.setPool((ObjectPool)pool);
            pool.setMaxTotal(10);
            pool.setMaxWait(Duration.ofSeconds(1L));
            try (ManagedDataSource ds = new ManagedDataSource((ObjectPool)pool, xaConnectionFactory.getTransactionRegistry());){
                ds.setAccessToUnderlyingConnectionAllowed(true);
                this.transactionManager.begin();
                try (Connection connectionA = ds.getConnection();){
                    Assertions.assertInstanceOf(DelegatingConnection.class, (Object)connectionA);
                }
                this.transactionManager.commit();
                Assertions.assertTrue((boolean)this.transactionManagerRegistered);
                Assertions.assertFalse((boolean)this.transactionSynchronizationRegistryRegistered);
            }
        }
    }
}

