/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.jackrabbit.oak.spi.commit;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

import static java.util.Objects.requireNonNull;

public enum ResetCommitAttributeHook implements CommitHook {
    INSTANCE;

    @NotNull
    @Override
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info)
            throws CommitFailedException {
        //Reset the attributes upon each commit attempt
        resetAttributes(info);
        return after;
    }

    private static void resetAttributes(CommitInfo info) {
        SimpleCommitContext attrs = (SimpleCommitContext) info.getInfo().get(CommitContext.NAME);
        //As per implementation this should not be null
        requireNonNull(attrs, "No commit attribute instance found in info map").clear();
    }
}
