/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.JTextComponentFormatter;
import org.apache.log4j.chainsaw.help.HelpManager;

class ChainsawAbout
extends JDialog {
    private static final Logger LOG = Logger.getLogger(ChainsawAbout.class);
    private final JEditorPane editPane = new JEditorPane("text/html", "");
    private final JScrollPane scrollPane = new JScrollPane(this.editPane, 21, 31);
    private final String url = ChainsawAbout.class.getName().replace('.', '/') + ".html";
    private boolean sleep = false;
    private final Object guard = new Object();

    ChainsawAbout(JFrame parent) {
        super(parent, "About Chainsaw v2", true);
        this.setBackground(Color.white);
        this.getContentPane().setLayout(new BorderLayout());
        JButton closeButton = new JButton(" Close ");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChainsawAbout.this.setVisible(false);
            }
        });
        closeButton.setDefaultCapable(true);
        try {
            this.editPane.setPage(this.getClass().getClassLoader().getResource(this.url));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to find the About panel HTML", e);
        }
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)closeButton, "South");
        JTextComponentFormatter.applySystemFontAndSize(this.editPane);
        this.editPane.setEditable(false);
        this.editPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpManager.getInstance().setHelpURL(e.getURL());
                }
            }
        });
        this.setSize(320, 240);
        new Thread(new Scroller()).start();
        this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
        this.setLocationRelativeTo(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.sleep = !visible;
        Object object = this.guard;
        synchronized (object) {
            this.guard.notifyAll();
        }
    }

    private class Scroller
    implements Runnable {
        private Scroller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (ChainsawAbout.this.sleep) {
                            Object object = ChainsawAbout.this.guard;
                            synchronized (object) {
                                ChainsawAbout.this.guard.wait();
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ChainsawAbout.this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
                                }
                            });
                            continue;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ChainsawAbout.this.scrollPane.getViewport().setViewPosition(new Point(0, ((ChainsawAbout)ChainsawAbout.this).scrollPane.getViewport().getViewPosition().y + 1));
                            }
                        });
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    LOG.error("Error during scrolling", e);
                    continue;
                }
                break;
            }
        }
    }
}

