/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializationMethodInvoker;
import com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SerializableConverter
implements Converter {
    private final SerializationMethodInvoker serializationMethodInvoker = new SerializationMethodInvoker();
    private final Mapper mapper;
    private final ReflectionProvider reflectionProvider;
    private static final String ELEMENT_NULL = "null";
    private static final String ELEMENT_DEFAULT = "default";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_SERIALIZATION = "serialization";
    private static final String ATTRIBUTE_VALUE_CUSTOM = "custom";
    private static final String ELEMENT_FIELDS = "fields";
    private static final String ELEMENT_FIELD = "field";
    private static final String ATTRIBUTE_NAME = "name";
    static /* synthetic */ Class class$java$io$Serializable;

    public SerializableConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        this.mapper = mapper;
        this.reflectionProvider = reflectionProvider;
    }

    public boolean canConvert(Class type) {
        return (class$java$io$Serializable == null ? (class$java$io$Serializable = SerializableConverter.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(type) && (this.serializationMethodInvoker.supportsReadObject(type, true) || this.serializationMethodInvoker.supportsWriteObject(type, true));
    }

    public void marshal(Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        final Object replacedSource = this.serializationMethodInvoker.callWriteReplace(source);
        if (replacedSource.getClass() != source.getClass()) {
            writer.addAttribute(this.mapper.attributeForReadResolveField(), this.mapper.serializedClass(replacedSource.getClass()));
        }
        writer.addAttribute(ATTRIBUTE_SERIALIZATION, ATTRIBUTE_VALUE_CUSTOM);
        final Class[] currentType = new Class[1];
        final boolean[] writtenClassWrapper = new boolean[]{false};
        CustomObjectOutputStream.StreamCallback callback = new CustomObjectOutputStream.StreamCallback(){

            public void writeToStream(Object object) {
                if (object == null) {
                    writer.startNode(SerializableConverter.ELEMENT_NULL);
                    writer.endNode();
                } else {
                    writer.startNode(SerializableConverter.this.mapper.serializedClass(object.getClass()));
                    context.convertAnother(object);
                    writer.endNode();
                }
            }

            public void writeFieldsToStream(Map fields) {
                ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(currentType[0]);
                writer.startNode(SerializableConverter.ELEMENT_DEFAULT);
                Iterator iterator = fields.keySet().iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    ObjectStreamField field = objectStreamClass.getField(name);
                    Object value = fields.get(name);
                    if (field == null) {
                        throw new ObjectAccessException("Class " + value.getClass().getName() + " may not write a field named '" + name + "'");
                    }
                    if (value == null) continue;
                    writer.startNode(SerializableConverter.this.mapper.serializedMember(currentType[0], name));
                    if (field.getType() != value.getClass() && !field.getType().isPrimitive()) {
                        writer.addAttribute(SerializableConverter.ATTRIBUTE_CLASS, SerializableConverter.this.mapper.serializedClass(value.getClass()));
                    }
                    context.convertAnother(value);
                    writer.endNode();
                }
                writer.endNode();
            }

            public void defaultWriteObject() {
                boolean writtenDefaultFields = false;
                ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(currentType[0]);
                if (objectStreamClass == null) {
                    return;
                }
                ObjectStreamField[] fields = objectStreamClass.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    ObjectStreamField field = fields[i];
                    Object value = SerializableConverter.this.readField(field, currentType[0], replacedSource);
                    if (value == null) continue;
                    if (!writtenClassWrapper[0]) {
                        writer.startNode(SerializableConverter.this.mapper.serializedClass(currentType[0]));
                        writtenClassWrapper[0] = true;
                    }
                    if (!writtenDefaultFields) {
                        writer.startNode(SerializableConverter.ELEMENT_DEFAULT);
                        writtenDefaultFields = true;
                    }
                    writer.startNode(SerializableConverter.this.mapper.serializedMember(currentType[0], field.getName()));
                    Class<?> actualType = value.getClass();
                    Class defaultType = SerializableConverter.this.mapper.defaultImplementationOf(field.getType());
                    if (!actualType.equals(defaultType)) {
                        writer.addAttribute(SerializableConverter.ATTRIBUTE_CLASS, SerializableConverter.this.mapper.serializedClass(actualType));
                    }
                    context.convertAnother(value);
                    writer.endNode();
                }
                if (writtenClassWrapper[0] && !writtenDefaultFields) {
                    writer.startNode(SerializableConverter.ELEMENT_DEFAULT);
                    writer.endNode();
                } else if (writtenDefaultFields) {
                    writer.endNode();
                }
            }

            public void flush() {
                writer.flush();
            }

            public void close() {
                throw new UnsupportedOperationException("Objects are not allowed to call ObjectOutputStream.close() from writeObject()");
            }
        };
        try {
            Iterator classHieararchy = this.hierarchyFor(replacedSource.getClass());
            while (classHieararchy.hasNext()) {
                currentType[0] = (Class)classHieararchy.next();
                if (this.serializationMethodInvoker.supportsWriteObject(currentType[0], false)) {
                    writtenClassWrapper[0] = true;
                    writer.startNode(this.mapper.serializedClass(currentType[0]));
                    CustomObjectOutputStream objectOutputStream = CustomObjectOutputStream.getInstance(context, callback);
                    this.serializationMethodInvoker.callWriteObject(currentType[0], replacedSource, objectOutputStream);
                    writer.endNode();
                    continue;
                }
                if (this.serializationMethodInvoker.supportsReadObject(currentType[0], false)) {
                    writtenClassWrapper[0] = true;
                    writer.startNode(this.mapper.serializedClass(currentType[0]));
                    callback.defaultWriteObject();
                    writer.endNode();
                    continue;
                }
                writtenClassWrapper[0] = false;
                callback.defaultWriteObject();
                if (!writtenClassWrapper[0]) continue;
                writer.endNode();
            }
        }
        catch (IOException e) {
            throw new ObjectAccessException("Could not call defaultWriteObject()", e);
        }
    }

    private Object readField(ObjectStreamField field, Class type, Object instance) {
        try {
            Field javaField = type.getDeclaredField(field.getName());
            javaField.setAccessible(true);
            return javaField.get(instance);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), e);
        }
        catch (NoSuchFieldException e) {
            throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), e);
        }
        catch (SecurityException e) {
            throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), e);
        }
    }

    private Iterator hierarchyFor(Class type) {
        ArrayList result = new ArrayList();
        while (type != null) {
            result.add(type);
            type = type.getSuperclass();
        }
        Collections.reverse(result);
        return result.iterator();
    }

    public Object unmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context) {
        String resolvesAttribute = reader.getAttribute(this.mapper.attributeForReadResolveField());
        Class requiredType = resolvesAttribute != null ? this.mapper.realClass(resolvesAttribute) : context.getRequiredType();
        final Object result = this.reflectionProvider.newInstance(requiredType);
        final Class[] currentType = new Class[1];
        if (!ATTRIBUTE_VALUE_CUSTOM.equals(reader.getAttribute(ATTRIBUTE_SERIALIZATION))) {
            throw new ConversionException("Cannot deserialize object with new readObject()/writeObject() methods");
        }
        CustomObjectInputStream.StreamCallback callback = new CustomObjectInputStream.StreamCallback(){

            public Object readFromStream() {
                reader.moveDown();
                Class type = SerializableConverter.this.mapper.realClass(reader.getNodeName());
                Object value = context.convertAnother(result, type);
                reader.moveUp();
                return value;
            }

            public Map readFieldsFromStream() {
                HashMap<String, Object> result2 = new HashMap<String, Object>();
                reader.moveDown();
                if (reader.getNodeName().equals(SerializableConverter.ELEMENT_FIELDS)) {
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if (!reader.getNodeName().equals(SerializableConverter.ELEMENT_FIELD)) {
                            throw new ConversionException("Expected <field/> element inside <field/>");
                        }
                        String name = reader.getAttribute(SerializableConverter.ATTRIBUTE_NAME);
                        Class type = SerializableConverter.this.mapper.realClass(reader.getAttribute(SerializableConverter.ATTRIBUTE_CLASS));
                        Object value = context.convertAnother(result2, type);
                        result2.put(name, value);
                        reader.moveUp();
                    }
                } else if (reader.getNodeName().equals(SerializableConverter.ELEMENT_DEFAULT)) {
                    ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(currentType[0]);
                    while (reader.hasMoreChildren()) {
                        Class<?> type;
                        reader.moveDown();
                        String name = reader.getNodeName();
                        String typeName = reader.getAttribute(SerializableConverter.ATTRIBUTE_CLASS);
                        if (typeName != null) {
                            type = SerializableConverter.this.mapper.realClass(typeName);
                        } else {
                            ObjectStreamField field = objectStreamClass.getField(name);
                            if (field == null) {
                                throw new ObjectAccessException("Class " + currentType[0] + " does not contain a field named '" + name + "'");
                            }
                            type = field.getType();
                        }
                        Object value = context.convertAnother(result2, type);
                        result2.put(name, value);
                        reader.moveUp();
                    }
                } else {
                    throw new ConversionException("Expected <fields/> or <default/> element when calling ObjectInputStream.readFields()");
                }
                reader.moveUp();
                return result2;
            }

            public void defaultReadObject() {
                if (!reader.hasMoreChildren()) {
                    return;
                }
                reader.moveDown();
                if (!reader.getNodeName().equals(SerializableConverter.ELEMENT_DEFAULT)) {
                    throw new ConversionException("Expected <default/> element in readObject() stream");
                }
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    String fieldName = SerializableConverter.this.mapper.realMember(currentType[0], reader.getNodeName());
                    String classAttribute = reader.getAttribute(SerializableConverter.ATTRIBUTE_CLASS);
                    Class type = classAttribute != null ? SerializableConverter.this.mapper.realClass(classAttribute) : SerializableConverter.this.mapper.defaultImplementationOf(SerializableConverter.this.reflectionProvider.getFieldType(result, fieldName, currentType[0]));
                    Object value = context.convertAnother(result, type);
                    SerializableConverter.this.reflectionProvider.writeField(result, fieldName, value, currentType[0]);
                    reader.moveUp();
                }
                reader.moveUp();
            }

            public void registerValidation(final ObjectInputValidation validation, int priority) {
                context.addCompletionCallback(new Runnable(){

                    public void run() {
                        try {
                            validation.validateObject();
                        }
                        catch (InvalidObjectException e) {
                            throw new ObjectAccessException("Cannot validate object : " + e.getMessage(), e);
                        }
                    }
                }, priority);
            }

            public void close() {
                throw new UnsupportedOperationException("Objects are not allowed to call ObjectInputStream.close() from readObject()");
            }
        };
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            currentType[0] = this.mapper.defaultImplementationOf(this.mapper.realClass(reader.getNodeName()));
            if (this.serializationMethodInvoker.supportsReadObject(currentType[0], false)) {
                CustomObjectInputStream objectInputStream = CustomObjectInputStream.getInstance(context, callback);
                this.serializationMethodInvoker.callReadObject(currentType[0], result, objectInputStream);
            } else {
                try {
                    callback.defaultReadObject();
                }
                catch (IOException e) {
                    throw new ObjectAccessException("Could not call defaultWriteObject()", e);
                }
            }
            reader.moveUp();
        }
        return this.serializationMethodInvoker.callReadResolve(result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

