/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class LogFilePatternReceiver
extends Receiver {
    private final List keywords = new ArrayList();
    private static final String PROP_START = "PROP(";
    private static final String PROP_END = ")";
    private static final String LOGGER = "LOGGER";
    private static final String MESSAGE = "MESSAGE";
    private static final String TIMESTAMP = "TIMESTAMP";
    private static final String NDC = "NDC";
    private static final String LEVEL = "LEVEL";
    private static final String THREAD = "THREAD";
    private static final String CLASS = "CLASS";
    private static final String FILE = "FILE";
    private static final String LINE = "LINE";
    private static final String METHOD = "METHOD";
    private static final String NEWLINE = "(NL)";
    private static final String DEFAULT_HOST = "file";
    private static final String EXCEPTION_PATTERN = "^\\s+at.*";
    private static final String REGEXP_DEFAULT_WILDCARD = ".*?";
    private static final String REGEXP_GREEDY_WILDCARD = ".*";
    private static final String PATTERN_WILDCARD = "*";
    private static final String NOSPACE_GROUP = "(\\s*?\\S*?\\s*?)";
    private static final String DEFAULT_GROUP = "(.*?)";
    private static final String GREEDY_GROUP = "(.*)";
    private static final String MULTIPLE_SPACES_REGEXP = "[ ]+";
    private static final String NEWLINE_REGEXP = "\n";
    private final String newLine = System.getProperty("line.separator");
    private final String[] emptyException = new String[]{""};
    private SimpleDateFormat dateFormat;
    private String timestampFormat;
    private String logFormat;
    private String customLevelDefinitions;
    private String fileURL;
    private String host;
    private String path;
    private boolean tailing;
    private String filterExpression;
    private long waitMillis = 2000L;
    private String group;
    private static final String VALID_DATEFORMAT_CHARS = "GyYMwWDdFEuaHkKhmsSzZX";
    private static final String VALID_DATEFORMAT_CHAR_PATTERN = "[GyYMwWDdFEuaHkKhmsSzZX]";
    private Rule expressionRule;
    private Map currentMap;
    private List additionalLines;
    private List matchingKeywords;
    private String regexp;
    private Reader reader;
    private Pattern regexpPattern;
    private Pattern exceptionPattern;
    private String timestampPatternText;
    private boolean useCurrentThread;
    public static final int MISSING_FILE_RETRY_MILLIS = 10000;
    private boolean appendNonMatches;
    private final Map customLevelDefinitionMap = new HashMap();
    private int lineCount = 1;

    public LogFilePatternReceiver() {
        this.keywords.add(TIMESTAMP);
        this.keywords.add(LOGGER);
        this.keywords.add(LEVEL);
        this.keywords.add(THREAD);
        this.keywords.add(CLASS);
        this.keywords.add(FILE);
        this.keywords.add(LINE);
        this.keywords.add(METHOD);
        this.keywords.add(MESSAGE);
        this.keywords.add(NDC);
        try {
            this.exceptionPattern = Pattern.compile(EXCEPTION_PATTERN);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String fileURL) {
        this.fileURL = fileURL;
    }

    public void setCustomLevelDefinitions(String customLevelDefinitions) {
        this.customLevelDefinitions = customLevelDefinitions;
    }

    public String getCustomLevelDefinitions() {
        return this.customLevelDefinitions;
    }

    public boolean isAppendNonMatches() {
        return this.appendNonMatches;
    }

    public void setAppendNonMatches(boolean appendNonMatches) {
        this.appendNonMatches = appendNonMatches;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    public boolean isTailing() {
        return this.tailing;
    }

    public void setTailing(boolean tailing) {
        this.tailing = tailing;
    }

    public final boolean isUseCurrentThread() {
        return this.useCurrentThread;
    }

    public final void setUseCurrentThread(boolean useCurrentThread) {
        this.useCurrentThread = useCurrentThread;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public long getWaitMillis() {
        return this.waitMillis;
    }

    public void setWaitMillis(long waitMillis) {
        this.waitMillis = waitMillis;
    }

    private int getExceptionLine() {
        for (int i = 0; i < this.additionalLines.size(); ++i) {
            Matcher exceptionMatcher = this.exceptionPattern.matcher((String)this.additionalLines.get(i));
            if (!exceptionMatcher.matches()) continue;
            return i;
        }
        return -1;
    }

    private String buildMessage(String firstMessageLine, int exceptionLine) {
        if (this.additionalLines.size() == 0) {
            return firstMessageLine;
        }
        StringBuffer message = new StringBuffer();
        if (firstMessageLine != null) {
            message.append(firstMessageLine);
        }
        int linesToProcess = exceptionLine == -1 ? this.additionalLines.size() : exceptionLine;
        for (int i = 0; i < linesToProcess; ++i) {
            message.append(this.newLine);
            message.append(this.additionalLines.get(i));
        }
        return message.toString();
    }

    private String[] buildException(int exceptionLine) {
        if (exceptionLine == -1) {
            return this.emptyException;
        }
        String[] exception = new String[this.additionalLines.size() - exceptionLine - 1];
        for (int i = 0; i < exception.length; ++i) {
            exception[i] = (String)this.additionalLines.get(i + exceptionLine);
        }
        return exception;
    }

    private LoggingEvent buildEvent() {
        if (this.currentMap.size() == 0) {
            if (this.additionalLines.size() > 0) {
                Iterator iter = this.additionalLines.iterator();
                while (iter.hasNext()) {
                    this.getLogger().debug("found non-matching line: " + iter.next());
                }
            }
            this.additionalLines.clear();
            return null;
        }
        int exceptionLine = this.getExceptionLine();
        String[] exception = this.buildException(exceptionLine);
        if (this.additionalLines.size() > 0 && exception.length > 0) {
            this.currentMap.put(MESSAGE, this.buildMessage((String)this.currentMap.get(MESSAGE), exceptionLine));
        }
        LoggingEvent event = this.convertToEvent(this.currentMap, exception);
        this.currentMap.clear();
        this.additionalLines.clear();
        return event;
    }

    protected void process(BufferedReader bufferedReader) throws IOException {
        String line;
        while ((line = bufferedReader.readLine()) != null) {
            for (int i = 1; i < this.lineCount; ++i) {
                String thisLine = bufferedReader.readLine();
                if (thisLine == null) continue;
                line = line + this.newLine + thisLine;
            }
            Matcher eventMatcher = this.regexpPattern.matcher(line);
            if (line.trim().equals("")) continue;
            Matcher exceptionMatcher = this.exceptionPattern.matcher(line);
            if (eventMatcher.matches()) {
                LoggingEvent event = this.buildEvent();
                if (event != null && this.passesExpression(event)) {
                    this.doPost(event);
                }
                this.currentMap.putAll(this.processEvent(eventMatcher.toMatchResult()));
                continue;
            }
            if (exceptionMatcher.matches()) {
                this.additionalLines.add(line);
                continue;
            }
            if (this.appendNonMatches) {
                LoggingEvent event;
                String lastTime = (String)this.currentMap.get(TIMESTAMP);
                if (this.currentMap.size() > 0 && (event = this.buildEvent()) != null && this.passesExpression(event)) {
                    this.doPost(event);
                }
                if (lastTime != null) {
                    this.currentMap.put(TIMESTAMP, lastTime);
                }
                this.currentMap.put(MESSAGE, line);
                continue;
            }
            this.additionalLines.add(line);
        }
        LoggingEvent event = this.buildEvent();
        if (event != null && this.passesExpression(event)) {
            this.doPost(event);
        }
    }

    protected void createPattern() {
        this.regexpPattern = Pattern.compile(this.regexp);
    }

    private boolean passesExpression(LoggingEvent event) {
        if (event != null && this.expressionRule != null) {
            return this.expressionRule.evaluate(event, null);
        }
        return true;
    }

    private Map processEvent(MatchResult result) {
        HashMap map = new HashMap();
        for (int i = 1; i < result.groupCount() + 1; ++i) {
            Object key = this.matchingKeywords.get(i - 1);
            String value = result.group(i);
            map.put(key, value);
        }
        return map;
    }

    private String convertTimestamp() {
        String result = "";
        if (this.timestampFormat != null) {
            result = this.timestampFormat.replaceAll(Pattern.quote("+"), "[+]");
            result = result.replaceAll(VALID_DATEFORMAT_CHAR_PATTERN, "\\\\S+");
            result = result.replaceAll(Pattern.quote("."), "\\\\.");
        }
        return result;
    }

    protected void setHost(String host) {
        this.host = host;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    protected void initialize() {
        int i;
        if (this.host == null && this.path == null) {
            try {
                URL url = new URL(this.fileURL);
                this.host = url.getHost();
                this.path = url.getPath();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
        if (this.host == null || this.host.trim().equals("")) {
            this.host = DEFAULT_HOST;
        }
        if (this.path == null || this.path.trim().equals("")) {
            this.path = this.fileURL;
        }
        this.currentMap = new HashMap();
        this.additionalLines = new ArrayList();
        this.matchingKeywords = new ArrayList();
        if (this.timestampFormat != null) {
            this.dateFormat = new SimpleDateFormat(this.quoteTimeStampChars(this.timestampFormat));
            this.timestampPatternText = this.convertTimestamp();
        }
        this.updateCustomLevelDefinitionMap();
        try {
            if (this.filterExpression != null) {
                this.expressionRule = ExpressionRule.getRule((String)this.filterExpression);
            }
        }
        catch (Exception e) {
            this.getLogger().warn((Object)("Invalid filter expression: " + this.filterExpression), e);
        }
        ArrayList<String> buildingKeywords = new ArrayList<String>();
        String newPattern = this.logFormat;
        int index = 0;
        while (index > -1) {
            index = newPattern.indexOf(NEWLINE);
            if (index <= -1) continue;
            ++this.lineCount;
            newPattern = this.singleReplace(newPattern, NEWLINE, NEWLINE_REGEXP);
        }
        String current = newPattern;
        ArrayList<String> propertyNames = new ArrayList<String>();
        index = 0;
        while (index > -1) {
            if (current.indexOf(PROP_START) > -1 && current.indexOf(PROP_END) > -1) {
                index = current.indexOf(PROP_START);
                String longPropertyName = current.substring(current.indexOf(PROP_START), current.indexOf(PROP_END) + 1);
                String shortProp = this.getShortPropertyName(longPropertyName);
                buildingKeywords.add(shortProp);
                propertyNames.add(longPropertyName);
                current = current.substring(longPropertyName.length() + 1 + index);
                newPattern = this.singleReplace(newPattern, longPropertyName, new Integer(buildingKeywords.size() - 1).toString());
                continue;
            }
            index = -1;
        }
        for (String keyword : this.keywords) {
            int index2 = newPattern.indexOf(keyword);
            if (index2 <= -1) continue;
            buildingKeywords.add(keyword);
            newPattern = this.singleReplace(newPattern, keyword, new Integer(buildingKeywords.size() - 1).toString());
        }
        String buildingInt = "";
        for (i = 0; i < newPattern.length(); ++i) {
            String thisValue = String.valueOf(newPattern.substring(i, i + 1));
            if (this.isInteger(thisValue)) {
                buildingInt = buildingInt + thisValue;
                continue;
            }
            if (this.isInteger(buildingInt)) {
                this.matchingKeywords.add(buildingKeywords.get(Integer.parseInt(buildingInt)));
            }
            buildingInt = "";
        }
        if (this.isInteger(buildingInt)) {
            this.matchingKeywords.add(buildingKeywords.get(Integer.parseInt(buildingInt)));
        }
        newPattern = this.replaceMetaChars(newPattern);
        newPattern = newPattern.replaceAll(MULTIPLE_SPACES_REGEXP, MULTIPLE_SPACES_REGEXP);
        newPattern = newPattern.replaceAll(Pattern.quote(PATTERN_WILDCARD), REGEXP_DEFAULT_WILDCARD);
        for (i = 0; i < buildingKeywords.size(); ++i) {
            String keyword = (String)buildingKeywords.get(i);
            newPattern = i == buildingKeywords.size() - 1 ? this.singleReplace(newPattern, String.valueOf(i), GREEDY_GROUP) : (TIMESTAMP.equals(keyword) ? this.singleReplace(newPattern, String.valueOf(i), "(" + this.timestampPatternText + PROP_END) : (LOGGER.equals(keyword) || LEVEL.equals(keyword) ? this.singleReplace(newPattern, String.valueOf(i), NOSPACE_GROUP) : this.singleReplace(newPattern, String.valueOf(i), DEFAULT_GROUP)));
        }
        this.regexp = newPattern;
        this.getLogger().debug("regexp is " + this.regexp);
    }

    private void updateCustomLevelDefinitionMap() {
        if (this.customLevelDefinitions != null) {
            StringTokenizer entryTokenizer = new StringTokenizer(this.customLevelDefinitions, ",");
            this.customLevelDefinitionMap.clear();
            while (entryTokenizer.hasMoreTokens()) {
                StringTokenizer innerTokenizer = new StringTokenizer(entryTokenizer.nextToken(), "=");
                this.customLevelDefinitionMap.put(innerTokenizer.nextToken(), Level.toLevel((String)innerTokenizer.nextToken()));
            }
        }
    }

    private boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private String quoteTimeStampChars(String input) {
        StringBuffer result = new StringBuffer();
        boolean lastCharIsDateFormat = false;
        for (int i = 0; i < input.length(); ++i) {
            String thisVal = input.substring(i, i + 1);
            boolean thisCharIsDateFormat = VALID_DATEFORMAT_CHARS.contains(thisVal);
            if (!thisCharIsDateFormat && (i == 0 || lastCharIsDateFormat)) {
                result.append("'");
            }
            if (thisCharIsDateFormat && i > 0 && !lastCharIsDateFormat) {
                result.append("'");
            }
            lastCharIsDateFormat = thisCharIsDateFormat;
            result.append(thisVal);
        }
        if (!lastCharIsDateFormat) {
            result.append("'");
        }
        return result.toString();
    }

    private String singleReplace(String inputString, String oldString, String newString) {
        int propLength = oldString.length();
        int startPos = inputString.indexOf(oldString);
        if (startPos == -1) {
            this.getLogger().info("string: " + oldString + " not found in input: " + inputString + " - returning input");
            return inputString;
        }
        if (startPos == 0) {
            inputString = inputString.substring(propLength);
            inputString = newString + inputString;
        } else {
            inputString = inputString.substring(0, startPos) + newString + inputString.substring(startPos + propLength);
        }
        return inputString;
    }

    private String getShortPropertyName(String longPropertyName) {
        String currentProp = longPropertyName.substring(longPropertyName.indexOf(PROP_START));
        String prop = currentProp.substring(0, currentProp.indexOf(PROP_END) + 1);
        String shortProp = prop.substring(PROP_START.length(), prop.length() - 1);
        return shortProp;
    }

    private String replaceMetaChars(String input) {
        input = input.replaceAll("\\\\", "\\\\\\");
        input = input.replaceAll(Pattern.quote("]"), "\\\\]");
        input = input.replaceAll(Pattern.quote("["), "\\\\[");
        input = input.replaceAll(Pattern.quote("^"), "\\\\^");
        input = input.replaceAll(Pattern.quote("$"), "\\\\$");
        input = input.replaceAll(Pattern.quote("."), "\\\\.");
        input = input.replaceAll(Pattern.quote("|"), "\\\\|");
        input = input.replaceAll(Pattern.quote("?"), "\\\\?");
        input = input.replaceAll(Pattern.quote("+"), "\\\\+");
        input = input.replaceAll(Pattern.quote("("), "\\\\(");
        input = input.replaceAll(Pattern.quote(PROP_END), "\\\\)");
        input = input.replaceAll(Pattern.quote("-"), "\\\\-");
        input = input.replaceAll(Pattern.quote("{"), "\\\\{");
        input = input.replaceAll(Pattern.quote("}"), "\\\\}");
        input = input.replaceAll(Pattern.quote("#"), "\\\\#");
        return input;
    }

    private LoggingEvent convertToEvent(Map fieldMap, String[] exception) {
        Level levelImpl;
        if (fieldMap == null) {
            return null;
        }
        if (!fieldMap.containsKey(LOGGER)) {
            fieldMap.put(LOGGER, "Unknown");
        }
        if (exception == null) {
            exception = this.emptyException;
        }
        Logger logger = null;
        long timeStamp = 0L;
        String level = null;
        String threadName = null;
        String message = null;
        String ndc = null;
        String className = null;
        String methodName = null;
        String eventFileName = null;
        String lineNumber = null;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        logger = Logger.getLogger((String)((String)fieldMap.remove(LOGGER)));
        if (this.dateFormat != null && fieldMap.containsKey(TIMESTAMP)) {
            try {
                timeStamp = this.dateFormat.parse((String)fieldMap.remove(TIMESTAMP)).getTime();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (timeStamp == 0L) {
            timeStamp = System.currentTimeMillis();
        }
        if ((message = (String)fieldMap.remove(MESSAGE)) == null) {
            message = "";
        }
        if ((level = (String)fieldMap.remove(LEVEL)) == null) {
            levelImpl = Level.DEBUG;
        } else {
            levelImpl = (Level)this.customLevelDefinitionMap.get(level);
            if (levelImpl == null && !level.equals((levelImpl = Level.toLevel((String)level.trim())).toString()) && levelImpl == null) {
                levelImpl = Level.DEBUG;
                this.getLogger().debug("found unexpected level: " + level + ", logger: " + logger.getName() + ", msg: " + message);
                message = level + " " + message;
            }
        }
        threadName = (String)fieldMap.remove(THREAD);
        ndc = (String)fieldMap.remove(NDC);
        className = (String)fieldMap.remove(CLASS);
        methodName = (String)fieldMap.remove(METHOD);
        eventFileName = (String)fieldMap.remove(FILE);
        lineNumber = (String)fieldMap.remove(LINE);
        properties.put("hostname", this.host);
        properties.put("application", this.path);
        properties.put("receiver", this.getName());
        if (this.group != null) {
            properties.put("group", this.group);
        }
        properties.putAll(fieldMap);
        LocationInfo info = null;
        info = eventFileName != null || className != null || methodName != null || lineNumber != null ? new LocationInfo(eventFileName, className, methodName, lineNumber) : LocationInfo.NA_LOCATION_INFO;
        LoggingEvent event = new LoggingEvent(null, (Category)logger, timeStamp, levelImpl, (Object)message, threadName, new ThrowableInformation(exception), ndc, info, properties);
        return event;
    }

    @Override
    public void shutdown() {
        this.getLogger().info(this.getPath() + " shutdown");
        this.active = false;
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void activateOptions() {
        this.getLogger().info("activateOptions");
        this.active = true;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var2_5;
                LogFilePatternReceiver.this.initialize();
                while (LogFilePatternReceiver.this.reader == null) {
                    LogFilePatternReceiver.this.getLogger().info("attempting to load file: " + LogFilePatternReceiver.this.getFileURL());
                    try {
                        LogFilePatternReceiver.this.reader = new InputStreamReader(new URL(LogFilePatternReceiver.this.getFileURL()).openStream(), "UTF-8");
                    }
                    catch (FileNotFoundException fnfe) {
                        LogFilePatternReceiver.this.getLogger().info("file not available - will try again");
                        var2_5 = this;
                        synchronized (var2_5) {
                            try {
                                this.wait(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (IOException ioe) {
                        LogFilePatternReceiver.this.getLogger().warn((Object)"unable to load file", ioe);
                        return;
                    }
                }
                try {
                    BufferedReader bufferedReader = new BufferedReader(LogFilePatternReceiver.this.reader);
                    LogFilePatternReceiver.this.createPattern();
                    do {
                        LogFilePatternReceiver.this.process(bufferedReader);
                        try {
                            var2_5 = this;
                            synchronized (var2_5) {
                                this.wait(LogFilePatternReceiver.this.waitMillis);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!LogFilePatternReceiver.this.tailing) continue;
                        LogFilePatternReceiver.this.getLogger().debug("tailing file");
                    } while (LogFilePatternReceiver.this.tailing);
                }
                catch (IOException ioe) {
                    LogFilePatternReceiver.this.getLogger().info("stream closed");
                }
                LogFilePatternReceiver.this.getLogger().debug("processing " + LogFilePatternReceiver.this.path + " complete");
                LogFilePatternReceiver.this.shutdown();
            }
        };
        if (this.useCurrentThread) {
            runnable.run();
        } else {
            new Thread(runnable, "LogFilePatternReceiver-" + this.getName()).start();
        }
    }
}

