/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs.provider.bzip2.BZip2Constants;
import org.apache.commons.vfs.provider.bzip2.CRC;

class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    private static final int LOWER_BYTE_MASK = 255;
    private static final int UPPER_BYTE_MASK = -256;
    private static final int SETMASK = 0x200000;
    private static final int CLEARMASK = -2097153;
    private static final int GREATER_ICOST = 15;
    private static final int LESSER_ICOST = 0;
    private static final int SMALL_THRESH = 20;
    private static final int DEPTH_THRESH = 10;
    private static final int QSORT_STACK_SIZE = 1000;
    private CRC m_crc = new CRC();
    private boolean[] m_inUse = new boolean[256];
    private char[] m_seqToUnseq = new char[256];
    private char[] m_unseqToSeq = new char[256];
    private char[] m_selector = new char[18002];
    private char[] m_selectorMtf = new char[18002];
    private int[] m_mtfFreq = new int[258];
    private int m_currentChar = -1;
    private int m_runLength;
    private boolean m_closed;
    private int[] m_incs = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    private boolean m_blockRandomised;
    private int m_blockSize100k;
    private int m_bsBuff;
    private int m_bsLive;
    private int m_last;
    private int m_origPtr;
    private int m_allowableBlockSize;
    private char[] m_block;
    private int m_blockCRC;
    private int m_combinedCRC;
    private OutputStream m_bsStream;
    private boolean m_firstAttempt;
    private int[] m_ftab;
    private int m_nInUse;
    private int m_nMTF;
    private int[] m_quadrant;
    private short[] m_szptr;
    private int m_workDone;
    private int m_workFactor;
    private int m_workLimit;
    private int[] m_zptr;

    CBZip2OutputStream(OutputStream output) throws IOException {
        this(output, 9);
    }

    CBZip2OutputStream(OutputStream output, int blockSize) throws IOException {
        this.bsSetStream(output);
        this.m_workFactor = 50;
        int outBlockSize = blockSize;
        if (outBlockSize > 9) {
            outBlockSize = 9;
        }
        if (outBlockSize < 1) {
            outBlockSize = 1;
        }
        this.m_blockSize100k = outBlockSize;
        this.allocateCompressStructures();
        this.initialize();
        this.initBlock();
    }

    private static void hbMakeCodeLengths(char[] len, int[] freq, int alphaSize, int maxLen) {
        int i;
        int[] heap = new int[260];
        int[] weights = new int[516];
        int[] parent = new int[516];
        for (i = 0; i < alphaSize; ++i) {
            weights[i + 1] = (freq[i] == 0 ? 1 : freq[i]) << 8;
        }
        block1: while (true) {
            int j;
            int zz;
            int nNodes = alphaSize;
            int nHeap = 0;
            heap[0] = 0;
            weights[0] = 0;
            parent[0] = -2;
            for (i = 1; i <= alphaSize; ++i) {
                parent[i] = -1;
                heap[++nHeap] = i;
                zz = nHeap;
                int tmp = heap[zz];
                while (weights[tmp] < weights[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
            }
            if (nHeap >= 260) {
                CBZip2OutputStream.panic();
            }
            while (nHeap > 1) {
                int weight;
                int n1 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                int yy = 0;
                int tmp = 0;
                zz = 1;
                tmp = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weights[heap[yy + 1]] < weights[heap[yy]]) {
                        ++yy;
                    }
                    if (weights[tmp] < weights[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp;
                int n2 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                yy = 0;
                tmp = 0;
                zz = 1;
                tmp = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weights[heap[yy + 1]] < weights[heap[yy]]) {
                        ++yy;
                    }
                    if (weights[tmp] < weights[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp;
                parent[n1] = ++nNodes;
                parent[n2] = nNodes;
                int v1 = weights[n1];
                int v2 = weights[n2];
                weights[nNodes] = weight = CBZip2OutputStream.calculateWeight(v1, v2);
                parent[nNodes] = -1;
                heap[++nHeap] = nNodes;
                int zz2 = 0;
                int tmp2 = 0;
                zz2 = nHeap;
                tmp2 = heap[zz2];
                while (weights[tmp2] < weights[heap[zz2 >> 1]]) {
                    heap[zz2] = heap[zz2 >> 1];
                    zz2 >>= 1;
                }
                heap[zz2] = tmp2;
            }
            if (nNodes >= 516) {
                CBZip2OutputStream.panic();
            }
            boolean tooLong = false;
            for (i = 1; i <= alphaSize; ++i) {
                j = 0;
                int k = i;
                while (parent[k] >= 0) {
                    k = parent[k];
                    ++j;
                }
                len[i - 1] = (char)j;
                if (j <= maxLen) continue;
                tooLong = true;
            }
            if (!tooLong) break;
            i = 1;
            while (true) {
                if (i >= alphaSize) continue block1;
                j = weights[i] >> 8;
                j = 1 + j / 2;
                weights[i] = j << 8;
                ++i;
            }
            break;
        }
    }

    private static int calculateWeight(int v1, int v2) {
        int upper = (v1 & 0xFFFFFF00) + (v2 & 0xFFFFFF00);
        int v1Lower = v1 & 0xFF;
        int v2Lower = v2 & 0xFF;
        int nnnn = v1Lower > v2Lower ? v1Lower : v2Lower;
        return upper | 1 + nnnn;
    }

    private static void panic() {
        System.out.println("panic");
    }

    public void close() throws IOException {
        if (this.m_closed) {
            return;
        }
        if (this.m_runLength > 0) {
            this.writeRun();
        }
        this.m_currentChar = -1;
        this.endBlock();
        this.endCompression();
        this.m_closed = true;
        super.close();
        this.m_bsStream.close();
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public void flush() throws IOException {
        super.flush();
        this.m_bsStream.flush();
    }

    public void write(int bv) throws IOException {
        int b = (256 + bv) % 256;
        if (this.m_currentChar != -1) {
            if (this.m_currentChar == b) {
                ++this.m_runLength;
                if (this.m_runLength > 254) {
                    this.writeRun();
                    this.m_currentChar = -1;
                    this.m_runLength = 0;
                }
            } else {
                this.writeRun();
                this.m_runLength = 1;
                this.m_currentChar = b;
            }
        } else {
            this.m_currentChar = b;
            ++this.m_runLength;
        }
    }

    private void allocateCompressStructures() {
        int n = 100000 * this.m_blockSize100k;
        this.m_block = new char[n + 1 + 20];
        this.m_quadrant = new int[n + 20];
        this.m_zptr = new int[n];
        this.m_ftab = new int[65537];
        if (this.m_block == null || this.m_quadrant == null || this.m_zptr == null || this.m_ftab == null) {
            // empty if block
        }
        this.m_szptr = new short[2 * n];
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.m_bsLive > 0) {
            int ch = this.m_bsBuff >> 24;
            this.m_bsStream.write(ch);
            this.m_bsBuff <<= 8;
            this.m_bsLive -= 8;
        }
    }

    private void bsPutIntVS(int numBits, int c) throws IOException {
        this.bsW(numBits, c);
    }

    private void bsPutUChar(int c) throws IOException {
        this.bsW(8, c);
    }

    private void bsPutint(int u) throws IOException {
        this.bsW(8, u >> 24 & 0xFF);
        this.bsW(8, u >> 16 & 0xFF);
        this.bsW(8, u >> 8 & 0xFF);
        this.bsW(8, u & 0xFF);
    }

    private void bsSetStream(OutputStream f) {
        this.m_bsStream = f;
        this.m_bsLive = 0;
        this.m_bsBuff = 0;
    }

    private void bsW(int n, int v) throws IOException {
        while (this.m_bsLive >= 8) {
            int ch = this.m_bsBuff >> 24;
            this.m_bsStream.write(ch);
            this.m_bsBuff <<= 8;
            this.m_bsLive -= 8;
        }
        this.m_bsBuff |= v << 32 - this.m_bsLive - n;
        this.m_bsLive += n;
    }

    private void doReversibleTransformation() {
        this.m_workLimit = this.m_workFactor * this.m_last;
        this.m_workDone = 0;
        this.m_blockRandomised = false;
        this.m_firstAttempt = true;
        this.mainSort();
        if (this.m_workDone > this.m_workLimit && this.m_firstAttempt) {
            this.randomiseBlock();
            this.m_workLimit = 0;
            this.m_workDone = 0;
            this.m_blockRandomised = true;
            this.m_firstAttempt = false;
            this.mainSort();
        }
        this.m_origPtr = -1;
        for (int i = 0; i <= this.m_last; ++i) {
            if (this.m_zptr[i] != 0) continue;
            this.m_origPtr = i;
            break;
        }
        if (this.m_origPtr == -1) {
            CBZip2OutputStream.panic();
        }
    }

    private void endBlock() throws IOException {
        this.m_blockCRC = this.m_crc.getFinalCRC();
        this.m_combinedCRC = this.m_combinedCRC << 1 | this.m_combinedCRC >>> 31;
        this.m_combinedCRC ^= this.m_blockCRC;
        this.doReversibleTransformation();
        this.bsPutUChar(49);
        this.bsPutUChar(65);
        this.bsPutUChar(89);
        this.bsPutUChar(38);
        this.bsPutUChar(83);
        this.bsPutUChar(89);
        this.bsPutint(this.m_blockCRC);
        if (this.m_blockRandomised) {
            this.bsW(1, 1);
        } else {
            this.bsW(1, 0);
        }
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUChar(23);
        this.bsPutUChar(114);
        this.bsPutUChar(69);
        this.bsPutUChar(56);
        this.bsPutUChar(80);
        this.bsPutUChar(144);
        this.bsPutint(this.m_combinedCRC);
        this.bsFinishedWithStream();
    }

    private boolean fullGtU(int i1, int i2) {
        char c1 = this.m_block[i1 + 1];
        char c2 = this.m_block[i2 + 1];
        if (c1 != c2) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        ++i1;
        ++i2;
        int k = this.m_last + 1;
        do {
            if ((c1 = this.m_block[i1 + 1]) != (c2 = this.m_block[i2 + 1])) {
                return c1 > c2;
            }
            int s1 = this.m_quadrant[i1];
            int s2 = this.m_quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.m_quadrant[i1];
            s2 = this.m_quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.m_quadrant[i1];
            s2 = this.m_quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.m_quadrant[i1];
            s2 = this.m_quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            ++i2;
            if (++i1 > this.m_last) {
                i1 -= this.m_last;
                --i1;
            }
            if (i2 > this.m_last) {
                i2 -= this.m_last;
                --i2;
            }
            ++this.m_workDone;
        } while ((k -= 4) >= 0);
        return false;
    }

    private void generateMTFValues() {
        int i;
        char[] yy = new char[256];
        this.makeMaps();
        int EOB = this.m_nInUse + 1;
        for (i = 0; i <= EOB; ++i) {
            this.m_mtfFreq[i] = 0;
        }
        int wr = 0;
        int zPend = 0;
        for (i = 0; i < this.m_nInUse; ++i) {
            yy[i] = (char)i;
        }
        for (i = 0; i <= this.m_last; ++i) {
            char ll_i = this.m_unseqToSeq[this.m_block[this.m_zptr[i]]];
            int j = 0;
            char tmp = yy[j];
            while (ll_i != tmp) {
                char tmp2 = tmp;
                tmp = yy[++j];
                yy[j] = tmp2;
            }
            yy[0] = tmp;
            if (j == 0) {
                ++zPend;
                continue;
            }
            if (zPend > 0) {
                --zPend;
                while (true) {
                    switch (zPend % 2) {
                        case 0: {
                            this.m_szptr[wr] = 0;
                            ++wr;
                            this.m_mtfFreq[0] = this.m_mtfFreq[0] + 1;
                            break;
                        }
                        case 1: {
                            this.m_szptr[wr] = 1;
                            ++wr;
                            this.m_mtfFreq[1] = this.m_mtfFreq[1] + 1;
                        }
                    }
                    if (zPend < 2) break;
                    zPend = (zPend - 2) / 2;
                }
                zPend = 0;
            }
            this.m_szptr[wr] = (short)(j + 1);
            ++wr;
            int n = j + 1;
            this.m_mtfFreq[n] = this.m_mtfFreq[n] + 1;
        }
        if (zPend > 0) {
            --zPend;
            while (true) {
                switch (zPend % 2) {
                    case 0: {
                        this.m_szptr[wr] = 0;
                        ++wr;
                        this.m_mtfFreq[0] = this.m_mtfFreq[0] + 1;
                        break;
                    }
                    case 1: {
                        this.m_szptr[wr] = 1;
                        ++wr;
                        this.m_mtfFreq[1] = this.m_mtfFreq[1] + 1;
                    }
                }
                if (zPend < 2) break;
                zPend = (zPend - 2) / 2;
            }
        }
        this.m_szptr[wr] = (short)EOB;
        int n = EOB;
        this.m_mtfFreq[n] = this.m_mtfFreq[n] + 1;
        this.m_nMTF = ++wr;
    }

    private void hbAssignCodes(int[] code, char[] length, int minLen, int maxLen, int alphaSize) {
        int vec = 0;
        for (int n = minLen; n <= maxLen; ++n) {
            for (int i = 0; i < alphaSize; ++i) {
                if (length[i] != n) continue;
                code[i] = vec++;
            }
            vec <<= 1;
        }
    }

    private void initBlock() {
        this.m_crc.initialiseCRC();
        this.m_last = -1;
        for (int i = 0; i < 256; ++i) {
            this.m_inUse[i] = false;
        }
        this.m_allowableBlockSize = 100000 * this.m_blockSize100k - 20;
    }

    private void initialize() throws IOException {
        this.bsPutUChar(104);
        this.bsPutUChar(48 + this.m_blockSize100k);
        this.m_combinedCRC = 0;
    }

    private void mainSort() {
        int i;
        int[] runningOrder = new int[256];
        int[] copy = new int[256];
        boolean[] bigDone = new boolean[256];
        for (i = 0; i < 20; ++i) {
            this.m_block[this.m_last + i + 2] = this.m_block[i % (this.m_last + 1) + 1];
        }
        for (i = 0; i <= this.m_last + 20; ++i) {
            this.m_quadrant[i] = 0;
        }
        this.m_block[0] = this.m_block[this.m_last + 1];
        if (this.m_last < 4000) {
            for (i = 0; i <= this.m_last; ++i) {
                this.m_zptr[i] = i;
            }
            this.m_firstAttempt = false;
            this.m_workDone = 0;
            this.m_workLimit = 0;
            this.simpleSort(0, this.m_last, 0);
        } else {
            int j;
            char c2;
            for (i = 0; i <= 255; ++i) {
                bigDone[i] = false;
            }
            for (i = 0; i <= 65536; ++i) {
                this.m_ftab[i] = 0;
            }
            char c1 = this.m_block[0];
            for (i = 0; i <= this.m_last; ++i) {
                c2 = this.m_block[i + 1];
                int n = (c1 << 8) + c2;
                this.m_ftab[n] = this.m_ftab[n] + 1;
                c1 = c2;
            }
            for (i = 1; i <= 65536; ++i) {
                int n = i;
                this.m_ftab[n] = this.m_ftab[n] + this.m_ftab[i - 1];
            }
            c1 = this.m_block[1];
            i = 0;
            while (i < this.m_last) {
                c2 = this.m_block[i + 2];
                j = (c1 << 8) + c2;
                c1 = c2;
                int n = j;
                this.m_ftab[n] = this.m_ftab[n] - 1;
                this.m_zptr[this.m_ftab[j]] = i++;
            }
            int n = j = (this.m_block[this.m_last + 1] << 8) + this.m_block[1];
            this.m_ftab[n] = this.m_ftab[n] - 1;
            this.m_zptr[this.m_ftab[j]] = this.m_last;
            for (i = 0; i <= 255; ++i) {
                runningOrder[i] = i;
            }
            int h = 1;
            while ((h = 3 * h + 1) <= 256) {
            }
            do {
                for (i = h /= 3; i <= 255; ++i) {
                    int vv = runningOrder[i];
                    j = i;
                    while (this.m_ftab[runningOrder[j - h] + 1 << 8] - this.m_ftab[runningOrder[j - h] << 8] > this.m_ftab[vv + 1 << 8] - this.m_ftab[vv << 8]) {
                        runningOrder[j] = runningOrder[j - h];
                        if ((j -= h) > h - 1) continue;
                    }
                    runningOrder[j] = vv;
                }
            } while (h != 1);
            for (i = 0; i <= 255; ++i) {
                int ss = runningOrder[i];
                for (j = 0; j <= 255; ++j) {
                    int sb = (ss << 8) + j;
                    if ((this.m_ftab[sb] & 0x200000) == 0x200000) continue;
                    int hi = (this.m_ftab[sb + 1] & 0xFFDFFFFF) - 1;
                    int lo = this.m_ftab[sb] & 0xFFDFFFFF;
                    if (hi > lo) {
                        this.qSort3(lo, hi, 2);
                        if (this.m_workDone > this.m_workLimit && this.m_firstAttempt) {
                            return;
                        }
                    }
                    int n2 = sb;
                    this.m_ftab[n2] = this.m_ftab[n2] | 0x200000;
                }
                bigDone[ss] = true;
                if (i < 255) {
                    int bbStart = this.m_ftab[ss << 8] & 0xFFDFFFFF;
                    int bbSize = (this.m_ftab[ss + 1 << 8] & 0xFFDFFFFF) - bbStart;
                    int shifts = 0;
                    while (bbSize >> shifts > 65534) {
                        ++shifts;
                    }
                    for (j = 0; j < bbSize; ++j) {
                        int qVal;
                        int a2update = this.m_zptr[bbStart + j];
                        this.m_quadrant[a2update] = qVal = j >> shifts;
                        if (a2update >= 20) continue;
                        this.m_quadrant[a2update + this.m_last + 1] = qVal;
                    }
                    if (bbSize - 1 >> shifts > 65535) {
                        CBZip2OutputStream.panic();
                    }
                }
                for (j = 0; j <= 255; ++j) {
                    copy[j] = this.m_ftab[(j << 8) + ss] & 0xFFDFFFFF;
                }
                for (j = this.m_ftab[ss << 8] & 0xFFDFFFFF; j < (this.m_ftab[ss + 1 << 8] & 0xFFDFFFFF); ++j) {
                    c1 = this.m_block[this.m_zptr[j]];
                    if (bigDone[c1]) continue;
                    this.m_zptr[copy[c1]] = this.m_zptr[j] == 0 ? this.m_last : this.m_zptr[j] - 1;
                    char c = c1;
                    copy[c] = copy[c] + 1;
                }
                for (j = 0; j <= 255; ++j) {
                    int n3 = (j << 8) + ss;
                    this.m_ftab[n3] = this.m_ftab[n3] | 0x200000;
                }
            }
        }
    }

    private void makeMaps() {
        this.m_nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.m_inUse[i]) continue;
            this.m_seqToUnseq[this.m_nInUse] = (char)i;
            this.m_unseqToSeq[i] = (char)this.m_nInUse;
            ++this.m_nInUse;
        }
    }

    private char med3(char a, char b, char c) {
        char t;
        if (a > b) {
            t = a;
            a = b;
            b = t;
        }
        if (b > c) {
            t = b;
            b = c;
            c = t;
        }
        if (a > b) {
            b = a;
        }
        return b;
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutIntVS(24, this.m_origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void qSort3(int loSt, int hiSt, int dSt) {
        StackElem[] stack = new StackElem[1000];
        for (int count = 0; count < 1000; ++count) {
            stack[count] = new StackElem();
        }
        int sp = 0;
        stack[sp].m_ll = loSt;
        stack[sp].m_hh = hiSt;
        stack[sp].m_dd = dSt;
        ++sp;
        while (sp > 0) {
            int n;
            if (sp >= 1000) {
                CBZip2OutputStream.panic();
            }
            int lo = stack[--sp].m_ll;
            int hi = stack[sp].m_hh;
            int d = stack[sp].m_dd;
            if (hi - lo < 20 || d > 10) {
                this.simpleSort(lo, hi, d);
                if (this.m_workDone <= this.m_workLimit || !this.m_firstAttempt) continue;
                return;
            }
            char med = this.med3(this.m_block[this.m_zptr[lo] + d + 1], this.m_block[this.m_zptr[hi] + d + 1], this.m_block[this.m_zptr[lo + hi >> 1] + d + 1]);
            int unLo = lo;
            int ltLo = lo;
            int unHi = hi;
            int gtHi = hi;
            while (true) {
                int temp;
                if (unLo <= unHi) {
                    n = this.m_block[this.m_zptr[unLo] + d + 1] - med;
                    if (n == 0) {
                        temp = 0;
                        temp = this.m_zptr[unLo];
                        this.m_zptr[unLo] = this.m_zptr[ltLo];
                        this.m_zptr[ltLo] = temp;
                        ++ltLo;
                        ++unLo;
                        continue;
                    }
                    if (n <= 0) {
                        ++unLo;
                        continue;
                    }
                }
                while (unLo <= unHi) {
                    n = this.m_block[this.m_zptr[unHi] + d + 1] - med;
                    if (n == 0) {
                        temp = 0;
                        temp = this.m_zptr[unHi];
                        this.m_zptr[unHi] = this.m_zptr[gtHi];
                        this.m_zptr[gtHi] = temp;
                        --gtHi;
                        --unHi;
                        continue;
                    }
                    if (n < 0) break;
                    --unHi;
                }
                if (unLo > unHi) break;
                temp = 0;
                temp = this.m_zptr[unLo];
                this.m_zptr[unLo] = this.m_zptr[unHi];
                this.m_zptr[unHi] = temp;
                ++unLo;
                --unHi;
            }
            if (gtHi < ltLo) {
                stack[sp].m_ll = lo;
                stack[sp].m_hh = hi;
                stack[sp].m_dd = d + 1;
                ++sp;
                continue;
            }
            n = ltLo - lo < unLo - ltLo ? ltLo - lo : unLo - ltLo;
            this.vswap(lo, unLo - n, n);
            int m = hi - gtHi < gtHi - unHi ? hi - gtHi : gtHi - unHi;
            this.vswap(unLo, hi - m + 1, m);
            n = lo + unLo - ltLo - 1;
            m = hi - (gtHi - unHi) + 1;
            stack[sp].m_ll = lo;
            stack[sp].m_hh = n;
            stack[sp].m_dd = d;
            stack[++sp].m_ll = n + 1;
            stack[sp].m_hh = m - 1;
            stack[sp].m_dd = d + 1;
            stack[++sp].m_ll = m;
            stack[sp].m_hh = hi;
            stack[sp].m_dd = d;
            ++sp;
        }
    }

    private void randomiseBlock() {
        int i;
        int rNToGo = 0;
        int rTPos = 0;
        for (i = 0; i < 256; ++i) {
            this.m_inUse[i] = false;
        }
        for (i = 0; i <= this.m_last; ++i) {
            if (rNToGo == 0) {
                rNToGo = (char)RAND_NUMS[rTPos];
                if (++rTPos == 512) {
                    rTPos = 0;
                }
            }
            int n = i + 1;
            this.m_block[n] = (char)(this.m_block[n] ^ (--rNToGo == 1 ? (char)'\u0001' : '\u0000'));
            int n2 = i + 1;
            this.m_block[n2] = (char)(this.m_block[n2] & 0xFF);
            this.m_inUse[this.m_block[i + 1]] = true;
        }
    }

    private void sendMTFValues() throws IOException {
        int j;
        int i;
        int ge;
        int v;
        int t;
        char[][] len = new char[6][258];
        int nSelectors = 0;
        int alphaSize = this.m_nInUse + 2;
        for (t = 0; t < 6; ++t) {
            for (v = 0; v < alphaSize; ++v) {
                len[t][v] = 15;
            }
        }
        if (this.m_nMTF <= 0) {
            CBZip2OutputStream.panic();
        }
        int nGroups = this.m_nMTF < 200 ? 2 : (this.m_nMTF < 600 ? 3 : (this.m_nMTF < 1200 ? 4 : (this.m_nMTF < 2400 ? 5 : 6)));
        int nPart = nGroups;
        int remF = this.m_nMTF;
        int gs = 0;
        while (nPart > 0) {
            int aFreq;
            int tFreq = remF / nPart;
            ge = gs - 1;
            for (aFreq = 0; aFreq < tFreq && ge < alphaSize - 1; aFreq += this.m_mtfFreq[++ge]) {
            }
            if (ge > gs && nPart != nGroups && nPart != 1 && (nGroups - nPart) % 2 == 1) {
                aFreq -= this.m_mtfFreq[ge];
                --ge;
            }
            for (v = 0; v < alphaSize; ++v) {
                len[nPart - 1][v] = v >= gs && v <= ge ? 0 : 15;
            }
            --nPart;
            gs = ge + 1;
            remF -= aFreq;
        }
        int[][] rfreq = new int[6][258];
        int[] fave = new int[6];
        short[] cost = new short[6];
        for (int iter = 0; iter < 4; ++iter) {
            for (t = 0; t < nGroups; ++t) {
                fave[t] = 0;
            }
            for (t = 0; t < nGroups; ++t) {
                for (v = 0; v < alphaSize; ++v) {
                    rfreq[t][v] = 0;
                }
            }
            nSelectors = 0;
            gs = 0;
            while (gs < this.m_nMTF) {
                ge = gs + 50 - 1;
                if (ge >= this.m_nMTF) {
                    ge = this.m_nMTF - 1;
                }
                for (t = 0; t < nGroups; ++t) {
                    cost[t] = 0;
                }
                if (nGroups == 6) {
                    short cost0 = 0;
                    short cost1 = 0;
                    short cost2 = 0;
                    short cost3 = 0;
                    short cost4 = 0;
                    short cost5 = 0;
                    for (i = gs; i <= ge; ++i) {
                        short icv = this.m_szptr[i];
                        cost0 = (short)(cost0 + len[0][icv]);
                        cost1 = (short)(cost1 + len[1][icv]);
                        cost2 = (short)(cost2 + len[2][icv]);
                        cost3 = (short)(cost3 + len[3][icv]);
                        cost4 = (short)(cost4 + len[4][icv]);
                        cost5 = (short)(cost5 + len[5][icv]);
                    }
                    cost[0] = cost0;
                    cost[1] = cost1;
                    cost[2] = cost2;
                    cost[3] = cost3;
                    cost[4] = cost4;
                    cost[5] = cost5;
                } else {
                    for (i = gs; i <= ge; ++i) {
                        short icv = this.m_szptr[i];
                        for (t = 0; t < nGroups; ++t) {
                            int n = t;
                            cost[n] = (short)(cost[n] + len[t][icv]);
                        }
                    }
                }
                short s = 999999999;
                int bt = -1;
                for (t = 0; t < nGroups; ++t) {
                    if (cost[t] >= s) continue;
                    s = cost[t];
                    bt = t;
                }
                int n = bt;
                fave[n] = fave[n] + 1;
                this.m_selector[nSelectors] = (char)bt;
                ++nSelectors;
                for (i = gs; i <= ge; ++i) {
                    int[] nArray = rfreq[bt];
                    short s2 = this.m_szptr[i];
                    nArray[s2] = nArray[s2] + 1;
                }
                gs = ge + 1;
            }
            for (t = 0; t < nGroups; ++t) {
                CBZip2OutputStream.hbMakeCodeLengths(len[t], rfreq[t], alphaSize, 20);
            }
        }
        rfreq = null;
        fave = null;
        cost = null;
        if (nGroups >= 8) {
            CBZip2OutputStream.panic();
        }
        if (nSelectors >= 32768 || nSelectors > 18002) {
            CBZip2OutputStream.panic();
        }
        char[] pos = new char[6];
        for (i = 0; i < nGroups; ++i) {
            pos[i] = (char)i;
        }
        for (i = 0; i < nSelectors; ++i) {
            char ll_i = this.m_selector[i];
            j = 0;
            char tmp = pos[j];
            while (ll_i != tmp) {
                char tmp2 = tmp;
                tmp = pos[++j];
                pos[j] = tmp2;
            }
            pos[0] = tmp;
            this.m_selectorMtf[i] = (char)j;
        }
        int[][] code = new int[6][258];
        for (t = 0; t < nGroups; ++t) {
            char minLen = ' ';
            char maxLen = '\u0000';
            for (i = 0; i < alphaSize; ++i) {
                if (len[t][i] > maxLen) {
                    maxLen = len[t][i];
                }
                if (len[t][i] >= minLen) continue;
                minLen = len[t][i];
            }
            if (maxLen > '\u0014') {
                CBZip2OutputStream.panic();
            }
            if (minLen < '\u0001') {
                CBZip2OutputStream.panic();
            }
            this.hbAssignCodes(code[t], len[t], minLen, maxLen, alphaSize);
        }
        boolean[] inUse16 = new boolean[16];
        for (i = 0; i < 16; ++i) {
            inUse16[i] = false;
            for (j = 0; j < 16; ++j) {
                if (!this.m_inUse[i * 16 + j]) continue;
                inUse16[i] = true;
            }
        }
        for (i = 0; i < 16; ++i) {
            if (inUse16[i]) {
                this.bsW(1, 1);
                continue;
            }
            this.bsW(1, 0);
        }
        for (i = 0; i < 16; ++i) {
            if (!inUse16[i]) continue;
            for (j = 0; j < 16; ++j) {
                if (this.m_inUse[i * 16 + j]) {
                    this.bsW(1, 1);
                    continue;
                }
                this.bsW(1, 0);
            }
        }
        this.bsW(3, nGroups);
        this.bsW(15, nSelectors);
        for (i = 0; i < nSelectors; ++i) {
            for (j = 0; j < this.m_selectorMtf[i]; ++j) {
                this.bsW(1, 1);
            }
            this.bsW(1, 0);
        }
        for (t = 0; t < nGroups; ++t) {
            int curr = len[t][0];
            this.bsW(5, curr);
            for (i = 0; i < alphaSize; ++i) {
                while (curr < len[t][i]) {
                    this.bsW(2, 2);
                    ++curr;
                }
                while (curr > len[t][i]) {
                    this.bsW(2, 3);
                    --curr;
                }
                this.bsW(1, 0);
            }
        }
        int selCtr = 0;
        gs = 0;
        while (gs < this.m_nMTF) {
            ge = gs + 50 - 1;
            if (ge >= this.m_nMTF) {
                ge = this.m_nMTF - 1;
            }
            for (i = gs; i <= ge; ++i) {
                this.bsW(len[this.m_selector[selCtr]][this.m_szptr[i]], code[this.m_selector[selCtr]][this.m_szptr[i]]);
            }
            gs = ge + 1;
            ++selCtr;
        }
        if (selCtr != nSelectors) {
            CBZip2OutputStream.panic();
        }
    }

    private void simpleSort(int lo, int hi, int d) {
        int bigN = hi - lo + 1;
        if (bigN < 2) {
            return;
        }
        int hp = 0;
        while (this.m_incs[hp] < bigN) {
            ++hp;
        }
        --hp;
        while (hp >= 0) {
            int h = this.m_incs[hp];
            for (int i = lo + h; i <= hi; ++i) {
                int v = this.m_zptr[i];
                int j = i;
                while (this.fullGtU(this.m_zptr[j - h] + d, v + d)) {
                    this.m_zptr[j] = this.m_zptr[j - h];
                    if ((j -= h) > lo + h - 1) continue;
                }
                this.m_zptr[j] = v;
                if (++i > hi) break;
                v = this.m_zptr[i];
                j = i;
                while (this.fullGtU(this.m_zptr[j - h] + d, v + d)) {
                    this.m_zptr[j] = this.m_zptr[j - h];
                    if ((j -= h) > lo + h - 1) continue;
                }
                this.m_zptr[j] = v;
                if (++i > hi) break;
                v = this.m_zptr[i];
                j = i;
                while (this.fullGtU(this.m_zptr[j - h] + d, v + d)) {
                    this.m_zptr[j] = this.m_zptr[j - h];
                    if ((j -= h) > lo + h - 1) continue;
                }
                this.m_zptr[j] = v;
                if (this.m_workDone <= this.m_workLimit || !this.m_firstAttempt) continue;
                return;
            }
            --hp;
        }
    }

    private void vswap(int p1, int p2, int n) {
        int temp = 0;
        while (n > 0) {
            temp = this.m_zptr[p1];
            this.m_zptr[p1] = this.m_zptr[p2];
            this.m_zptr[p2] = temp;
            ++p1;
            ++p2;
            --n;
        }
    }

    private void writeRun() throws IOException {
        if (this.m_last < this.m_allowableBlockSize) {
            this.m_inUse[this.m_currentChar] = true;
            for (int i = 0; i < this.m_runLength; ++i) {
                this.m_crc.updateCRC((char)this.m_currentChar);
            }
            switch (this.m_runLength) {
                case 1: {
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    break;
                }
                case 2: {
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    break;
                }
                case 3: {
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    break;
                }
                default: {
                    this.m_inUse[this.m_runLength - 4] = true;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)(this.m_runLength - 4);
                    break;
                }
            }
        } else {
            this.endBlock();
            this.initBlock();
            this.writeRun();
        }
    }

    private static class StackElem {
        int m_dd;
        int m_hh;
        int m_ll;

        private StackElem() {
        }
    }
}

