/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class RuleMediator
extends AbstractRule {
    private Rule loggerRule;
    private Rule filterRule;
    private Rule findRule;
    private final PropertyChangeListener ruleChangerNotifier = new RuleChangerNotifier();
    private boolean findRuleRequired;

    public RuleMediator(boolean findRuleRequired) {
        this.findRuleRequired = findRuleRequired;
    }

    public boolean evaluate(LoggingEvent e, Map matches) {
        if (this.findRuleRequired) {
            if (this.findRule == null) {
                return false;
            }
            if (!this.findRule.evaluate(e, null)) {
                return false;
            }
        }
        return !(this.loggerRule != null && !this.loggerRule.evaluate(e, null) || this.filterRule != null && !this.filterRule.evaluate(e, null));
    }

    public boolean isFindRuleRequired() {
        return this.findRuleRequired;
    }

    public void setFilterRule(Rule r) {
        Rule oldFilterRule = this.filterRule;
        this.filterRule = r;
        this.firePropertyChange("filterRule", oldFilterRule, this.filterRule);
    }

    public void setFindRule(Rule r) {
        Rule oldFindRule = this.findRule;
        this.findRule = r;
        this.firePropertyChange("findRule", oldFindRule, this.findRule);
    }

    public void setLoggerRule(Rule r) {
        Rule oldLoggerRule = this.loggerRule;
        this.loggerRule = r;
        if (oldLoggerRule != null) {
            oldLoggerRule.removePropertyChangeListener(this.ruleChangerNotifier);
        }
        this.loggerRule.addPropertyChangeListener(this.ruleChangerNotifier);
        this.firePropertyChange("loggerRule", oldLoggerRule, this.loggerRule);
    }

    private class RuleChangerNotifier
    implements PropertyChangeListener {
        private RuleChangerNotifier() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RuleMediator.this.firePropertyChange(evt);
        }
    }
}

