/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.db.ConnectionSource;
import org.apache.log4j.plugins.Pauseable;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.scheduler.Job;
import org.apache.log4j.scheduler.Scheduler;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;

public class CustomSQLDBReceiver
extends Receiver
implements Pauseable,
UnrecognizedElementHandler {
    protected volatile Connection connection = null;
    protected String sqlStatement = "";
    static int DEFAULT_REFRESH_MILLIS = 1000;
    int refreshMillis = DEFAULT_REFRESH_MILLIS;
    protected String idField = null;
    int lastID = -1;
    private static final String WHERE_CLAUSE = " WHERE ";
    private static final String AND_CLAUSE = " AND ";
    private boolean whereExists = false;
    private boolean paused = false;
    private ConnectionSource connectionSource;
    public static final String LOG4J_ID_KEY = "log4jid";
    private Job customReceiverJob;

    public void activateOptions() {
        if (this.connectionSource == null) {
            throw new IllegalStateException("CustomSQLDBReceiver cannot function without a connection source");
        }
        this.whereExists = this.sqlStatement.toUpperCase().contains(WHERE_CLAUSE);
        this.customReceiverJob = new CustomReceiverJob();
        if (this.repository == null) {
            throw new IllegalStateException("CustomSQLDBReceiver cannot function without a reference to its owning repository");
        }
        if (this.repository instanceof LoggerRepositoryEx) {
            Scheduler scheduler = ((LoggerRepositoryEx)this.repository).getScheduler();
            scheduler.schedule(this.customReceiverJob, System.currentTimeMillis() + 500L, this.refreshMillis);
        }
    }

    void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void setRefreshMillis(int refreshMillis) {
        this.refreshMillis = refreshMillis;
    }

    public int getRefreshMillis() {
        return this.refreshMillis;
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.connection = null;
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void shutdown() {
        this.getLogger().info("removing receiverJob from the Scheduler.");
        if (this.repository instanceof LoggerRepositoryEx) {
            Scheduler scheduler = ((LoggerRepositoryEx)this.repository).getScheduler();
            scheduler.delete(this.customReceiverJob);
        }
        this.lastID = -1;
    }

    public void setSql(String s) {
        this.sqlStatement = s;
    }

    public String getSql() {
        return this.sqlStatement;
    }

    public void setIDField(String id) {
        this.idField = id;
    }

    public String getIDField() {
        return this.idField;
    }

    @Override
    public synchronized void setPaused(boolean p) {
        this.paused = p;
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused;
    }

    public boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        if ("connectionSource".equals(element.getNodeName())) {
            Object instance = DOMConfigurator.parseElement((Element)element, (Properties)props, ConnectionSource.class);
            if (instance instanceof ConnectionSource) {
                ConnectionSource source = (ConnectionSource)instance;
                source.activateOptions();
                this.setConnectionSource(source);
            }
            return true;
        }
        return false;
    }

    class CustomReceiverJob
    implements Job {
        CustomReceiverJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            int oldLastID = CustomSQLDBReceiver.this.lastID;
            try {
                CustomSQLDBReceiver.this.connection = CustomSQLDBReceiver.this.connectionSource.getConnection();
                Statement statement = CustomSQLDBReceiver.this.connection.createStatement();
                String currentSQLStatement = CustomSQLDBReceiver.this.whereExists ? CustomSQLDBReceiver.this.sqlStatement + CustomSQLDBReceiver.AND_CLAUSE + CustomSQLDBReceiver.this.idField + " > " + CustomSQLDBReceiver.this.lastID : CustomSQLDBReceiver.this.sqlStatement + CustomSQLDBReceiver.WHERE_CLAUSE + CustomSQLDBReceiver.this.idField + " > " + CustomSQLDBReceiver.this.lastID;
                ResultSet rs = statement.executeQuery(currentSQLStatement);
                int i = 0;
                while (rs.next()) {
                    if (++i == 1000) {
                        CustomReceiverJob customReceiverJob = this;
                        synchronized (customReceiverJob) {
                            try {
                                this.wait(300L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            i = 0;
                        }
                    }
                    Logger eventLogger = Logger.getLogger((String)rs.getString("LOGGER"));
                    long timeStamp = rs.getTimestamp("TIMESTAMP").getTime();
                    String level = rs.getString("LEVEL");
                    String threadName = rs.getString("THREAD");
                    String message = rs.getString("MESSAGE");
                    String ndc = rs.getString("NDC");
                    String mdcString = rs.getString("MDC");
                    Hashtable<String, String> mdc = new Hashtable<String, String>();
                    if (mdcString != null) {
                        if (mdcString.contains("{{") && mdcString.contains("}}")) {
                            mdcString = mdcString.substring(mdcString.indexOf("{{") + 2, mdcString.indexOf("}}"));
                        }
                        StringTokenizer tok = new StringTokenizer(mdcString, ",");
                        while (tok.countTokens() > 1) {
                            mdc.put(tok.nextToken(), tok.nextToken());
                        }
                    }
                    String[] throwable = new String[]{rs.getString("THROWABLE")};
                    String className = rs.getString("CLASS");
                    String methodName = rs.getString("METHOD");
                    String fileName = rs.getString("FILE");
                    String lineNumber = rs.getString("LINE");
                    String propertiesString = rs.getString("PROPERTIES");
                    Hashtable<String, String> properties = new Hashtable<String, String>();
                    if (propertiesString != null) {
                        if (propertiesString.contains("{{") && propertiesString.contains("}}")) {
                            propertiesString = propertiesString.substring(propertiesString.indexOf("{{") + 2, propertiesString.indexOf("}}"));
                        }
                        StringTokenizer tok2 = new StringTokenizer(propertiesString, ",");
                        while (tok2.countTokens() > 1) {
                            String tokenName = tok2.nextToken();
                            String value = tok2.nextToken();
                            if (tokenName.equals(CustomSQLDBReceiver.LOG4J_ID_KEY)) {
                                try {
                                    int thisInt = Integer.parseInt(value);
                                    value = String.valueOf(thisInt);
                                    if (thisInt > CustomSQLDBReceiver.this.lastID) {
                                        CustomSQLDBReceiver.this.lastID = thisInt;
                                    }
                                }
                                catch (Exception thisInt) {
                                    // empty catch block
                                }
                            }
                            properties.put(tokenName, value);
                        }
                    }
                    Level levelImpl = Level.toLevel((String)level);
                    LocationInfo locationInfo = new LocationInfo(fileName, className, methodName, lineNumber);
                    ThrowableInformation throwableInfo = new ThrowableInformation(throwable);
                    properties.putAll(mdc);
                    LoggingEvent event = new LoggingEvent(eventLogger.getName(), (Category)eventLogger, timeStamp, levelImpl, (Object)message, threadName, throwableInfo, ndc, locationInfo, properties);
                    CustomSQLDBReceiver.this.doPost(event);
                }
                if (CustomSQLDBReceiver.this.lastID != oldLastID) {
                    CustomSQLDBReceiver.this.getLogger().debug("lastID: " + CustomSQLDBReceiver.this.lastID);
                }
                statement.close();
            }
            catch (SQLException sqle) {
                CustomSQLDBReceiver.this.getLogger().error((Object)"*************Problem receiving events", sqle);
            }
            finally {
                CustomSQLDBReceiver.this.closeConnection();
            }
            CustomReceiverJob customReceiverJob = this;
            synchronized (customReceiverJob) {
                while (CustomSQLDBReceiver.this.isPaused()) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

