/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.net.ssl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Random;
import org.apache.logging.log4j.core.test.net.ssl.TlsSyslogMessageFormat;

@SuppressFBWarnings(value={"PREDICTABLE_RANDOM"})
public class TlsSyslogTestUtil {
    public static final String ABC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMBERS = "0123456789";
    public static final String WHITESPACES = " \t\n";
    public static final String CHARSET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final String LEGACY_BSD_SYSLOG_CHARSET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 \t";
    public static final String SYSLOG_CHARSET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 \t\n";

    public static ArrayList<String> generateMessages(int numberOfMessages) {
        return TlsSyslogTestUtil.generateMessages(numberOfMessages, CHARSET);
    }

    public static ArrayList<String> generateMessages(int numberOfMessages, TlsSyslogMessageFormat format) {
        switch (format) {
            case SYSLOG: {
                return TlsSyslogTestUtil.generateMessages(numberOfMessages, SYSLOG_CHARSET);
            }
            case LEGACY_BSD: {
                return TlsSyslogTestUtil.generateMessages(numberOfMessages, LEGACY_BSD_SYSLOG_CHARSET);
            }
        }
        throw new IllegalArgumentException();
    }

    private static ArrayList<String> generateMessages(int numberOfMessages, String charSet) {
        ArrayList<String> messageList = new ArrayList<String>(numberOfMessages);
        for (int i = 0; i < numberOfMessages; ++i) {
            String message = TlsSyslogTestUtil.createRandomMessage(charSet);
            messageList.add(message);
        }
        return messageList;
    }

    private static String createRandomMessage(String charset) {
        char[] chars = charset.toCharArray();
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < random.nextInt(10000); ++i) {
            char c = chars[random.nextInt(chars.length)];
            sb.append(c);
        }
        String output = sb.toString();
        return output;
    }

    public static int getRandomInt(int max) {
        Random random = new Random();
        int n = random.nextInt(max);
        if (n < 0) {
            return -n;
        }
        return n;
    }
}

