/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.compress.commons;

import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.CompressorStreamProvider;
import org.apache.commons.compress.compressors.lzma.LZMAUtils;
import org.apache.commons.compress.compressors.xz.XZUtils;
import org.apache.commons.compress.compressors.zstandard.ZstdUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.compress.commons.CommonsCompressActionFactory;
import org.apache.logging.log4j.core.appender.rolling.action.CompressActionFactory;
import org.apache.logging.log4j.core.appender.rolling.action.CompressActionFactoryProvider;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Ordered;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;
import org.jspecify.annotations.Nullable;

@Plugin
@Namespace(value="compress")
@Ordered(value=0)
public final class CommonsCompressActionFactoryProvider
implements CompressActionFactoryProvider {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String COMMONS_COMPRESS_DOCUMENTATION = "See https://commons.apache.org/proper/commons-compress/index.html for more information.";
    private final CompressorStreamFactory factory = new CompressorStreamFactory();

    private static void missingDependencyWarning(String algorithm) {
        LOGGER.warn("{} compression is not available due to a missing dependency. {}", (Object)algorithm, (Object)COMMONS_COMPRESS_DOCUMENTATION);
    }

    private @Nullable CompressorStreamProvider getCompressorStreamProvider(String algorithm) {
        switch (Strings.toRootLowerCase((String)algorithm)) {
            case "lzma": {
                if (LZMAUtils.isLZMACompressionAvailable()) break;
                CommonsCompressActionFactoryProvider.missingDependencyWarning("LZMA");
                return null;
            }
            case "pack200": {
                LOGGER.warn("Pack200 compression is not suitable for log files and will not be used.");
                return null;
            }
            case "xz": {
                if (XZUtils.isXZCompressionAvailable()) break;
                CommonsCompressActionFactoryProvider.missingDependencyWarning("XZ");
                return null;
            }
            case "zstd": {
                if (ZstdUtils.isZstdCompressionAvailable()) break;
                CommonsCompressActionFactoryProvider.missingDependencyWarning("Zstd");
                return null;
            }
        }
        return (CompressorStreamProvider)CompressorStreamFactory.findAvailableCompressorOutputStreamProviders().get(Strings.toRootUpperCase((String)algorithm));
    }

    public @Nullable CompressActionFactory createFactoryForAlgorithm(String algorithm) {
        CompressorStreamProvider provider = this.getCompressorStreamProvider(algorithm);
        if (provider != null) {
            return new CommonsCompressActionFactory(algorithm, provider);
        }
        return null;
    }
}

