/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.HttpManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.net.ssl.LaxHostnameVerifier;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;

public class HttpURLConnectionManager
extends HttpManager {
    private static final Charset CHARSET = StandardCharsets.US_ASCII;
    private final URL url;
    private final boolean isHttps;
    private final String method;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final Property[] headers;
    private final SslConfiguration sslConfiguration;
    private final boolean verifyHostname;

    public HttpURLConnectionManager(Configuration configuration, LoggerContext loggerContext, String name, URL url, String method, int connectTimeoutMillis, int readTimeoutMillis, Property[] headers, SslConfiguration sslConfiguration, boolean verifyHostname) {
        super(configuration, loggerContext, name);
        this.url = url;
        if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
            throw new ConfigurationException("URL must have scheme http or https");
        }
        this.isHttps = this.url.getProtocol().equalsIgnoreCase("https");
        this.method = Objects.requireNonNull(method, "method");
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.headers = headers != null ? headers : new Property[]{};
        this.sslConfiguration = sslConfiguration;
        if (this.sslConfiguration != null && !this.isHttps) {
            throw new ConfigurationException("SSL configuration can only be specified with URL scheme https");
        }
        this.verifyHostname = verifyHostname;
    }

    @Override
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="This connection URL is specified in a configuration file.")
    public void send(Layout layout, LogEvent event) throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)this.url.openConnection();
        urlConnection.setAllowUserInteraction(false);
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setRequestMethod(this.method);
        if (this.connectTimeoutMillis > 0) {
            urlConnection.setConnectTimeout(this.connectTimeoutMillis);
        }
        if (this.readTimeoutMillis > 0) {
            urlConnection.setReadTimeout(this.readTimeoutMillis);
        }
        if (layout.getContentType() != null) {
            urlConnection.setRequestProperty("Content-Type", layout.getContentType());
        }
        for (Property header : this.headers) {
            urlConnection.setRequestProperty(header.getName(), header.isValueNeedsLookup() ? this.getConfiguration().getStrSubstitutor().replace(event, header.getValue()) : header.getValue());
        }
        if (this.sslConfiguration != null) {
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(this.sslConfiguration.getSslContext().getSocketFactory());
        }
        if (this.isHttps && !this.verifyHostname) {
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
        }
        byte[] msg = layout.toByteArray(event);
        urlConnection.setFixedLengthStreamingMode(msg.length);
        urlConnection.connect();
        try (OutputStream os = urlConnection.getOutputStream();){
            os.write(msg);
        }
        try (InputStream is = urlConnection.getInputStream();){
            is.readAllBytes();
        }
        catch (IOException e) {
            StringBuilder errorMessage = new StringBuilder();
            try (InputStream es = urlConnection.getErrorStream();){
                errorMessage.append(urlConnection.getResponseCode());
                if (urlConnection.getResponseMessage() != null) {
                    errorMessage.append(' ').append(urlConnection.getResponseMessage());
                }
                if (es != null) {
                    errorMessage.append(" - ");
                    errorMessage.append(new String(es.readAllBytes(), CHARSET));
                }
            }
            if (urlConnection.getResponseCode() > -1) {
                throw new IOException(errorMessage.toString());
            }
            throw e;
        }
    }
}

