/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.security.Principal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.VersionProperties;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.FileInfoExtractor;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.extensions.openssh.OpenSSHLimitsExtensionInfo;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.client.impl.SftpPathImpl;
import org.apache.sshd.sftp.common.SftpConstants;
import org.apache.sshd.sftp.common.SftpException;
import org.apache.sshd.sftp.common.SftpHelper;
import org.apache.sshd.sftp.common.extensions.AclSupportedParser;
import org.apache.sshd.sftp.common.extensions.SpaceAvailableExtensionInfo;
import org.apache.sshd.sftp.common.extensions.openssh.AbstractOpenSSHExtensionParser;
import org.apache.sshd.sftp.server.DirectoryHandle;
import org.apache.sshd.sftp.server.Handle;
import org.apache.sshd.sftp.server.InvalidHandleException;
import org.apache.sshd.sftp.server.SftpErrorStatusDataHandler;
import org.apache.sshd.sftp.server.SftpEventListener;
import org.apache.sshd.sftp.server.SftpFileSystemAccessor;
import org.apache.sshd.sftp.server.SftpSubsystemConfigurator;
import org.apache.sshd.sftp.server.SftpSubsystemEnvironment;
import org.apache.sshd.sftp.server.SftpSubsystemProxy;
import org.apache.sshd.sftp.server.UnsupportedAttributePolicy;

public abstract class AbstractSftpSubsystemHelper
extends AbstractLoggingBean
implements SftpSubsystemProxy {
    public static final NavigableMap<String, OptionalFeature> DEFAULT_SUPPORTED_CLIENT_EXTENSIONS = MapEntryUtils.NavigableMapBuilder.builder().put((Object)"version-select", (Object)OptionalFeature.TRUE).put((Object)"copy-file", (Object)OptionalFeature.TRUE).put((Object)"md5-hash", (Object)BuiltinDigests.md5).put((Object)"md5-hash-handle", (Object)BuiltinDigests.md5).put((Object)"check-file-handle", (Object)OptionalFeature.any((Collection)BuiltinDigests.VALUES)).put((Object)"check-file-name", (Object)OptionalFeature.any((Collection)BuiltinDigests.VALUES)).put((Object)"copy-data", (Object)OptionalFeature.TRUE).put((Object)"space-available", (Object)OptionalFeature.TRUE).immutable();
    public static final List<AbstractOpenSSHExtensionParser.OpenSSHExtension> DEFAULT_OPEN_SSH_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(new AbstractOpenSSHExtensionParser.OpenSSHExtension("fsync@openssh.com", "1"), new AbstractOpenSSHExtensionParser.OpenSSHExtension("hardlink@openssh.com", "1"), new AbstractOpenSSHExtensionParser.OpenSSHExtension("lsetstat@openssh.com", "1"), new AbstractOpenSSHExtensionParser.OpenSSHExtension("posix-rename@openssh.com", "1"), new AbstractOpenSSHExtensionParser.OpenSSHExtension("limits@openssh.com", "1")));
    public static final List<String> DEFAULT_OPEN_SSH_EXTENSIONS_NAMES = Collections.unmodifiableList(NamedResource.getNameList(DEFAULT_OPEN_SSH_EXTENSIONS));
    public static final Set<Integer> DEFAULT_ACL_SUPPORTED_MASK = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(1, 2, 4, 8)));
    private final ChannelSession channelSession;
    private final UnsupportedAttributePolicy unsupportedAttributePolicy;
    private final Collection<SftpEventListener> sftpEventListeners = new CopyOnWriteArraySet<SftpEventListener>();
    private final SftpEventListener sftpEventListenerProxy;
    private final SftpFileSystemAccessor fileSystemAccessor;
    private final SftpErrorStatusDataHandler errorStatusDataHandler;

    protected AbstractSftpSubsystemHelper(ChannelSession channelSession, SftpSubsystemConfigurator configurator) {
        this.channelSession = Objects.requireNonNull(channelSession, "No channel session provided");
        this.unsupportedAttributePolicy = Objects.requireNonNull(configurator.getUnsupportedAttributePolicy(), "No unsupported attribute policy provided");
        this.fileSystemAccessor = Objects.requireNonNull(configurator.getFileSystemAccessor(), "No file system accessor");
        this.sftpEventListenerProxy = (SftpEventListener)EventListenerUtils.proxyWrapper(SftpEventListener.class, this.sftpEventListeners);
        this.errorStatusDataHandler = Objects.requireNonNull(configurator.getErrorStatusDataHandler(), "No error status data handler");
    }

    public ChannelSession getServerChannelSession() {
        return this.channelSession;
    }

    @Override
    public UnsupportedAttributePolicy getUnsupportedAttributePolicy() {
        return this.unsupportedAttributePolicy;
    }

    @Override
    public SftpFileSystemAccessor getFileSystemAccessor() {
        return this.fileSystemAccessor;
    }

    @Override
    public SftpEventListener getSftpEventListenerProxy() {
        return this.sftpEventListenerProxy;
    }

    @Override
    public boolean addSftpEventListener(SftpEventListener listener) {
        return this.sftpEventListeners.add(SftpEventListener.validateListener(listener));
    }

    @Override
    public boolean removeSftpEventListener(SftpEventListener listener) {
        if (listener == null) {
            return false;
        }
        return this.sftpEventListeners.remove(SftpEventListener.validateListener(listener));
    }

    @Override
    public SftpErrorStatusDataHandler getErrorStatusDataHandler() {
        return this.errorStatusDataHandler;
    }

    protected Boolean validateProposedVersion(Buffer buffer, int id, String proposal) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        ServerSession session = this.getServerSession();
        if (debugEnabled) {
            this.log.debug("validateProposedVersion({})[id={}] SSH_FXP_EXTENDED(version-select) (version={})", new Object[]{session, id, proposal});
        }
        if (GenericUtils.length((CharSequence)proposal) != 1) {
            return Boolean.FALSE;
        }
        char digit = proposal.charAt(0);
        if (digit < '0' || digit > '9') {
            return Boolean.FALSE;
        }
        int proposed = digit - 48;
        Map.Entry<Integer, String> result = this.checkVersionCompatibility(buffer, id, proposed, 4);
        if (result == null) {
            return null;
        }
        int negotiated = result.getKey();
        if (negotiated != proposed) {
            if (debugEnabled) {
                this.log.debug("validateProposedVersion({})[id={}] SSH_FXP_EXTENDED(version-select) proposed={} different than negotiated={}", new Object[]{session, id, proposed, negotiated});
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Map.Entry<Integer, String> checkVersionCompatibility(Buffer buffer, int id, int proposed, int failureOpcode) throws IOException {
        boolean traceEnabled;
        int low = 3;
        int hig = 6;
        String available = SftpSubsystemEnvironment.ALL_SFTP_IMPL;
        ServerSession session = this.getServerSession();
        Integer sftpVersion = (Integer)SftpModuleProperties.SFTP_VERSION.getOrNull((PropertyResolver)session);
        if (sftpVersion != null) {
            int forcedValue = sftpVersion;
            if (forcedValue < 3 || forcedValue > 6) {
                throw new IllegalStateException("Forced SFTP version (" + sftpVersion + ") not within supported values: " + available);
            }
            low = hig = sftpVersion.intValue();
            available = sftpVersion.toString();
        }
        if (traceEnabled = this.log.isTraceEnabled()) {
            this.log.trace("checkVersionCompatibility({})[id={}] - proposed={}, available={}", new Object[]{session, id, proposed, available});
        }
        if (proposed < low) {
            this.sendStatus(this.prepareReply(buffer), id, failureOpcode, "Proposed version (" + proposed + ") not in supported range: " + available);
            return null;
        }
        if (proposed > hig) {
            if (traceEnabled) {
                this.log.trace("checkVersionCompatibility({})[id={}] - replace proposed={} with negotiated={} due to available={}", new Object[]{session, id, proposed, hig, available});
            }
            proposed = hig;
        }
        return new AbstractMap.SimpleImmutableEntry<Integer, String>(proposed, available);
    }

    protected void process(Buffer buffer) throws IOException {
        ServerSession session = this.getServerSession();
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("process({})[length={}, type={}, id={}] processing", new Object[]{session, length, SftpConstants.getCommandMessageName(type), id});
        }
        try {
            SftpEventListener listener = this.getSftpEventListenerProxy();
            listener.received(session, type, id);
        }
        catch (IOException | RuntimeException e) {
            if (type == 1) {
                throw e;
            }
            this.sendStatus(this.prepareReply(buffer), id, e, type, new Object[0]);
            return;
        }
        this.doProcess(buffer, length, type, id);
    }

    protected void doProcess(Buffer buffer, int length, int type, int id) throws IOException {
        switch (type) {
            case 1: {
                this.doInit(buffer, id);
                break;
            }
            case 3: {
                this.doOpen(buffer, id);
                break;
            }
            case 4: {
                this.doClose(buffer, id);
                break;
            }
            case 5: {
                this.doRead(buffer, id);
                break;
            }
            case 6: {
                this.doWrite(buffer, id);
                break;
            }
            case 7: {
                this.doLStat(buffer, id);
                break;
            }
            case 8: {
                this.doFStat(buffer, id);
                break;
            }
            case 9: {
                this.doSetStat(buffer, id, "", type, null);
                break;
            }
            case 10: {
                this.doFSetStat(buffer, id);
                break;
            }
            case 11: {
                this.doOpenDir(buffer, id);
                break;
            }
            case 12: {
                this.doReadDir(buffer, id);
                break;
            }
            case 13: {
                this.doRemove(buffer, id);
                break;
            }
            case 14: {
                this.doMakeDirectory(buffer, id);
                break;
            }
            case 15: {
                this.doRemoveDirectory(buffer, id);
                break;
            }
            case 16: {
                this.doRealPath(buffer, id);
                break;
            }
            case 17: {
                this.doStat(buffer, id);
                break;
            }
            case 18: {
                this.doRename(buffer, id);
                break;
            }
            case 19: {
                this.doReadLink(buffer, id);
                break;
            }
            case 20: {
                this.doSymLink(buffer, id);
                break;
            }
            case 21: {
                this.doLink(buffer, id);
                break;
            }
            case 22: {
                this.doBlock(buffer, id);
                break;
            }
            case 23: {
                this.doUnblock(buffer, id);
                break;
            }
            case 200: {
                this.doExtended(buffer, id);
                break;
            }
            default: {
                this.doUnsupported(buffer, length, type, id);
            }
        }
    }

    protected void doUnsupported(Buffer buffer, int length, int type, int id) throws IOException {
        String name = SftpConstants.getCommandMessageName(type);
        this.log.warn("process({})[length={}, type={}, id={}] unknown command", new Object[]{this.getServerSession(), length, name, id});
        this.sendStatus(this.prepareReply(buffer), id, 8, "Command " + name + " is unsupported or not implemented");
    }

    protected abstract void doInit(Buffer var1, int var2) throws IOException;

    protected void doVersionSelect(Buffer buffer, int id) throws IOException {
        String proposed = buffer.getString();
        this.doVersionSelect(buffer, id, proposed);
    }

    protected abstract void doVersionSelect(Buffer var1, int var2, String var3) throws IOException;

    protected void doOpen(Buffer buffer, int id) throws IOException {
        String handle;
        String path = buffer.getString();
        int access = 0;
        int version = this.getVersion();
        if (version >= 5 && (access = buffer.getInt()) == 0) {
            access = 129;
        }
        int pflags = buffer.getInt();
        if (version < 5) {
            int flags = pflags == 0 ? 1 : pflags;
            pflags = 0;
            switch (flags & 3) {
                case 1: {
                    access |= 0x81;
                    break;
                }
                case 2: {
                    access |= 0x102;
                    break;
                }
                default: {
                    access |= 0x81;
                    access |= 0x102;
                }
            }
            if ((flags & 4) != 0) {
                access |= 4;
                pflags |= 0x18;
            }
            pflags = (flags & 8) != 0 ? ((flags & 0x20) != 0 ? (pflags |= 0) : ((flags & 0x10) != 0 ? (pflags |= 1) : (pflags |= 3))) : ((flags & 0x10) != 0 ? (pflags |= 4) : (pflags |= 2));
        }
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            handle = this.doOpen(id, path, pflags, access, attrs);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 3, path);
            return;
        }
        this.sendHandle(this.prepareReply(buffer), id, handle);
    }

    protected abstract String doOpen(int var1, String var2, int var3, int var4, Map<String, Object> var5) throws IOException;

    protected <E extends IOException> E signalOpenFailure(int id, String pathValue, Path path, boolean isDir, E thrown) throws IOException {
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("signalOpenFailure(id={})[{}] signal {} for {}: {}", new Object[]{id, pathValue, thrown.getClass().getSimpleName(), path, thrown.getMessage()});
        }
        listener.openFailed(session, pathValue, path, isDir, thrown);
        return thrown;
    }

    protected void doClose(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        try {
            this.doClose(id, handle);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 4, handle);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "", "");
    }

    protected abstract void doClose(int var1, String var2) throws IOException;

    protected void doRead(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long offset = buffer.getLong();
        int requestedLength = buffer.getInt();
        ServerSession session = this.getServerSession();
        int maxAllowed = (Integer)SftpModuleProperties.MAX_READDATA_PACKET_LENGTH.getRequired((PropertyResolver)session);
        int readLen = Math.min(requestedLength, maxAllowed);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doRead({})[id={}]({})[offset={}] - req={}, max={}, effective={}", new Object[]{session, id, handle, offset, requestedLength, maxAllowed, readLen});
        }
        try {
            Boolean eof;
            int version;
            ValidateUtils.checkTrue((readLen >= 0 ? 1 : 0) != 0, (String)"Illegal requested read length: %d", (long)readLen);
            buffer = this.prepareReply(buffer);
            buffer.ensureCapacity(readLen + 64, IntUnaryOperator.identity());
            buffer.putByte((byte)103);
            buffer.putInt((long)id);
            int lenPos = buffer.wpos();
            buffer.putUInt(0L);
            AtomicReference<Boolean> eofRef = new AtomicReference<Boolean>();
            int startPos = buffer.wpos();
            int len = this.doRead(id, handle, offset, readLen, buffer.array(), startPos, eofRef);
            if (len < 0) {
                throw new EOFException("Unable to read " + readLen + " bytes from offset=" + offset + " of " + handle);
            }
            buffer.wpos(startPos + len);
            BufferUtils.updateLengthPlaceholder((Buffer)buffer, (int)lenPos, (long)len);
            if (len < readLen && (version = this.getVersion()) >= 6 && (eof = eofRef.get()) != null) {
                buffer.putBoolean(eof.booleanValue());
            }
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 5, handle, offset, requestedLength);
            return;
        }
        this.send(buffer);
    }

    protected abstract int doRead(int var1, String var2, long var3, int var5, byte[] var6, int var7, AtomicReference<Boolean> var8) throws IOException;

    protected void doWrite(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long offset = buffer.getLong();
        int length = buffer.getInt();
        try {
            this.doWrite(id, handle, offset, length, buffer.array(), buffer.rpos(), buffer.available());
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 6, handle, offset, length);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doWrite(int var1, String var2, long var3, int var5, byte[] var6, int var7, int var8) throws IOException;

    protected void doLStat(Buffer buffer, int id) throws IOException {
        Map<String, Object> attrs;
        String path = buffer.getString();
        int flags = 65535;
        int version = this.getVersion();
        if (version >= 4) {
            flags = buffer.getInt();
        }
        try {
            attrs = this.doLStat(id, path, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 7, path, flags);
            return;
        }
        this.sendAttrs(this.prepareReply(buffer), id, attrs);
    }

    protected Map<String, Object> doLStat(int id, String path, int flags) throws IOException {
        Path p = this.resolveFile(path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doLStat({})[id={}] SSH_FXP_LSTAT (path={}[{}], flags=0x{})", new Object[]{this.getServerSession(), id, path, p, Integer.toHexString(flags)});
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        boolean followLinks = this.resolvePathResolutionFollowLinks(7, "", p);
        LinkOption[] options = accessor.resolveFileAccessLinkOptions(this, p, 7, "", false);
        return this.resolveFileAttributes(p, flags, !followLinks, options);
    }

    protected void doSetStat(Buffer buffer, int id, String extension, int cmd, Boolean followLinks) throws IOException {
        String path = buffer.getString();
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            this.doSetStat(id, path, cmd, extension, attrs, followLinks);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 9, path);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doSetStat(int id, String path, int cmd, String extension, Map<String, ?> attrs, Boolean followLinks) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doSetStat({})[id={}, cmd={}, extension={}]  (path={}, attrs={}, followLinks={})", new Object[]{this.getServerSession(), id, cmd, extension, path, attrs, followLinks});
        }
        Path p = this.resolveFile(path);
        if (followLinks == null) {
            followLinks = this.resolvePathResolutionFollowLinks(9, extension, p);
        }
        this.doSetAttributes(cmd, extension, p, attrs, followLinks);
    }

    protected void doFStat(Buffer buffer, int id) throws IOException {
        Map<String, Object> attrs;
        String handle = buffer.getString();
        int flags = 65535;
        int version = this.getVersion();
        if (version >= 4) {
            flags = buffer.getInt();
        }
        try {
            attrs = this.doFStat(id, handle, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 8, handle, flags);
            return;
        }
        this.sendAttrs(this.prepareReply(buffer), id, attrs);
    }

    protected abstract Map<String, Object> doFStat(int var1, String var2, int var3) throws IOException;

    protected void doFSetStat(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            this.doFSetStat(id, handle, attrs);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 10, handle, attrs);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doFSetStat(int var1, String var2, Map<String, ?> var3) throws IOException;

    protected void doOpenDir(Buffer buffer, int id) throws IOException {
        String handle;
        String path = buffer.getString();
        try {
            Path p = this.resolveNormalizedLocation(path);
            if (this.log.isDebugEnabled()) {
                this.log.debug("doOpenDir({})[id={}] SSH_FXP_OPENDIR (path={})[{}]", new Object[]{this.getServerSession(), id, path, p});
            }
            LinkOption[] options = this.getPathResolutionLinkOption(11, "", p);
            handle = this.doOpenDir(id, path, p, options);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 11, path);
            return;
        }
        this.sendHandle(this.prepareReply(buffer), id, handle);
    }

    protected abstract String doOpenDir(int var1, String var2, Path var3, LinkOption ... var4) throws IOException;

    protected abstract void doReadDir(Buffer var1, int var2) throws IOException;

    protected void doLink(Buffer buffer, int id) throws IOException {
        String targetPath = buffer.getString();
        String linkPath = buffer.getString();
        boolean symLink = buffer.getBoolean();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doLink({})[id={}] SSH_FXP_LINK linkpath={}, targetpath={}, symlink={}", new Object[]{this.getServerSession(), id, linkPath, targetPath, symLink});
            }
            this.doLink(id, targetPath, linkPath, symLink);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 21, targetPath, linkPath, symLink);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doLink(int id, String targetPath, String linkPath, boolean symLink) throws IOException {
        this.createLink(id, targetPath, linkPath, symLink);
    }

    protected void doSymLink(Buffer buffer, int id) throws IOException {
        String targetPath = buffer.getString();
        String linkPath = buffer.getString();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doSymLink({})[id={}] SSH_FXP_SYMLINK linkpath={}, targetpath={}", new Object[]{this.getServerSession(), id, targetPath, linkPath});
            }
            this.doSymLink(id, targetPath, linkPath);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 20, targetPath, linkPath);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doSymLink(int id, String targetPath, String linkPath) throws IOException {
        this.createLink(id, targetPath, linkPath, true);
    }

    protected abstract void createLink(int var1, String var2, String var3, boolean var4) throws IOException;

    protected void doOpenSSHHardLink(Buffer buffer, int id) throws IOException {
        String srcFile = buffer.getString();
        String dstFile = buffer.getString();
        try {
            this.doOpenSSHHardLink(id, srcFile, dstFile);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 200, "hardlink@openssh.com", srcFile, dstFile);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doOpenSSHLimits(Buffer buffer, int id) throws IOException {
        OpenSSHLimitsExtensionInfo info = this.getOpenSSHLimitsExtensionInfo(id, this.getServerChannelSession());
        buffer = this.prepareReply(buffer);
        buffer.putByte((byte)-55);
        buffer.putInt((long)id);
        info.encode(buffer);
        this.send(buffer);
    }

    protected OpenSSHLimitsExtensionInfo getOpenSSHLimitsExtensionInfo(int id, ChannelSession channel) throws IOException {
        return new OpenSSHLimitsExtensionInfo((PropertyResolver)channel);
    }

    protected void doOpenSSHHardLink(int id, String srcFile, String dstFile) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpenSSHHardLink({})[id={}] SSH_FXP_EXTENDED[{}] (src={}, dst={})", new Object[]{this.getServerSession(), id, "hardlink@openssh.com", srcFile, dstFile});
        }
        this.createLink(id, srcFile, dstFile, false);
    }

    protected void doSpaceAvailable(Buffer buffer, int id) throws IOException {
        SpaceAvailableExtensionInfo info;
        String path = buffer.getString();
        try {
            info = this.doSpaceAvailable(id, path);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 200, "space-available", path);
            return;
        }
        buffer = this.prepareReply(buffer);
        buffer.putByte((byte)-55);
        buffer.putInt((long)id);
        SpaceAvailableExtensionInfo.encode(buffer, info);
        this.send(buffer);
    }

    protected SpaceAvailableExtensionInfo doSpaceAvailable(int id, String path) throws IOException {
        Path nrm = this.resolveNormalizedLocation(path);
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doSpaceAvailable({})[id={}] path={}[{}]", new Object[]{session, id, path, nrm});
        }
        FileStore store = Files.getFileStore(nrm);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doSpaceAvailable({})[id={}] path={}[{}] - {}[{}]", new Object[]{session, id, path, nrm, store.name(), store.type()});
        }
        return new SpaceAvailableExtensionInfo(store);
    }

    protected void doTextSeek(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long line = buffer.getLong();
        try {
            this.doTextSeek(id, handle, line);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 200, "text-seek", handle, line);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doTextSeek(int var1, String var2, long var3) throws IOException;

    protected void doOpenSSHFsync(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        try {
            this.doOpenSSHFsync(id, handle);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 200, "fsync@openssh.com", handle);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doOpenSSHFsync(int var1, String var2) throws IOException;

    protected void doCheckFileHash(Buffer buffer, int id, String targetType) throws IOException {
        String target = buffer.getString();
        String algList = buffer.getString();
        String[] algos = GenericUtils.split((String)algList, (char)',');
        long startOffset = buffer.getLong();
        long length = buffer.getLong();
        int blockSize = buffer.getInt();
        try {
            buffer = this.prepareReply(buffer);
            buffer.putByte((byte)-55);
            buffer.putInt((long)id);
            buffer.putString("check-file");
            this.doCheckFileHash(id, targetType, target, Arrays.asList(algos), startOffset, length, blockSize, buffer);
        }
        catch (Exception e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 200, targetType, target, algList, startOffset, length, blockSize);
            return;
        }
        this.send(buffer);
    }

    protected void doCheckFileHash(int id, Path file, NamedFactory<? extends Digest> factory, long startOffset, long length, int blockSize, Buffer buffer) throws Exception {
        ValidateUtils.checkTrue((startOffset >= 0L ? 1 : 0) != 0, (String)"Invalid start offset: %d", (long)startOffset);
        ValidateUtils.checkTrue((length >= 0L ? 1 : 0) != 0, (String)"Invalid length: %d", (long)length);
        ValidateUtils.checkTrue((blockSize == 0 || blockSize >= 256 ? 1 : 0) != 0, (String)"Invalid block size: %d", (long)blockSize);
        Objects.requireNonNull(factory, "No digest factory provided");
        buffer.putString(factory.getName());
        long effectiveLength = length;
        long totalLength = Files.size(file);
        if (effectiveLength == 0L) {
            effectiveLength = totalLength - startOffset;
        } else {
            long maxRead = startOffset + length;
            if (maxRead > totalLength) {
                effectiveLength = totalLength - startOffset;
            }
        }
        ValidateUtils.checkTrue((effectiveLength > 0L ? 1 : 0) != 0, (String)"Non-positive effective hash data length: %d", (long)effectiveLength);
        byte[] digestBuf = blockSize == 0 ? new byte[Math.min((int)effectiveLength, 8192)] : new byte[Math.min((int)effectiveLength, blockSize)];
        ByteBuffer wb = ByteBuffer.wrap(digestBuf);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        ServerSession session = this.getServerSession();
        try (SeekableByteChannel channel = accessor.openFile(this, null, file, null, Collections.emptySet(), new FileAttribute[0]);){
            channel.position(startOffset);
            Digest digest = (Digest)factory.create();
            digest.init();
            boolean traceEnabled = this.log.isTraceEnabled();
            if (blockSize == 0) {
                while (effectiveLength > 0L) {
                    int remainLen = Math.min(digestBuf.length, (int)effectiveLength);
                    ByteBuffer bb = wb;
                    if (remainLen < digestBuf.length) {
                        bb = ByteBuffer.wrap(digestBuf, 0, remainLen);
                    }
                    bb.clear();
                    int readLen = channel.read(bb);
                    if (readLen < 0) break;
                    effectiveLength -= (long)readLen;
                    digest.update(digestBuf, 0, readLen);
                }
                byte[] hashValue = digest.digest();
                if (traceEnabled) {
                    this.log.trace("doCheckFileHash({})[{}] offset={}, length={} - algo={}, hash={}", new Object[]{session, file, startOffset, length, digest.getAlgorithm(), BufferUtils.toHex((char)':', (byte[])hashValue)});
                }
                buffer.putBytes(hashValue);
            } else {
                int count = 0;
                while (effectiveLength > 0L) {
                    int remainLen = Math.min(digestBuf.length, (int)effectiveLength);
                    ByteBuffer bb = wb;
                    if (remainLen < digestBuf.length) {
                        bb = ByteBuffer.wrap(digestBuf, 0, remainLen);
                    }
                    bb.clear();
                    int readLen = channel.read(bb);
                    if (readLen < 0) break;
                    effectiveLength -= (long)readLen;
                    digest.update(digestBuf, 0, readLen);
                    byte[] hashValue = digest.digest();
                    if (traceEnabled) {
                        this.log.trace("doCheckFileHash({})({})[{}] offset={}, length={} - algo={}, hash={}", new Object[]{session, file, count, startOffset, length, digest.getAlgorithm(), BufferUtils.toHex((char)':', (byte[])hashValue)});
                    }
                    buffer.putBytes(hashValue);
                    ++count;
                }
            }
            accessor.closeFile(this, null, file, null, channel, Collections.emptySet());
        }
    }

    protected void doMD5Hash(Buffer buffer, int id, String targetType) throws IOException {
        byte[] hashValue;
        String target = buffer.getString();
        long startOffset = buffer.getLong();
        long length = buffer.getLong();
        byte[] quickCheckHash = buffer.getBytes();
        try {
            hashValue = this.doMD5Hash(id, targetType, target, startOffset, length, quickCheckHash);
            if (this.log.isTraceEnabled()) {
                this.log.trace("doMD5Hash({})({})[{}] offset={}, length={}, quick-hash={} - hash={}", new Object[]{this.getServerSession(), targetType, target, startOffset, length, BufferUtils.toHex((char)':', (byte[])quickCheckHash), BufferUtils.toHex((char)':', (byte[])hashValue)});
            }
        }
        catch (Exception e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 200, targetType, target, startOffset, length, quickCheckHash);
            return;
        }
        buffer = this.prepareReply(buffer);
        buffer.putByte((byte)-55);
        buffer.putInt((long)id);
        buffer.putString(targetType);
        buffer.putBytes(hashValue);
        this.send(buffer);
    }

    protected abstract byte[] doMD5Hash(int var1, String var2, String var3, long var4, long var6, byte[] var8) throws Exception;

    protected byte[] doMD5Hash(int id, Path path, long startOffset, long length, byte[] quickCheckHash) throws Exception {
        ValidateUtils.checkTrue((startOffset >= 0L ? 1 : 0) != 0, (String)"Invalid start offset: %d", (long)startOffset);
        ValidateUtils.checkTrue((length > 0L ? 1 : 0) != 0, (String)"Invalid length: %d", (long)length);
        if (!BuiltinDigests.md5.isSupported()) {
            throw new UnsupportedOperationException(BuiltinDigests.md5.getAlgorithm() + " hash not supported");
        }
        Digest digest = BuiltinDigests.md5.create();
        digest.init();
        long effectiveLength = length;
        byte[] digestBuf = new byte[(int)Math.min(effectiveLength, 2048L)];
        ByteBuffer wb = ByteBuffer.wrap(digestBuf);
        boolean hashMatches = false;
        byte[] hashValue = null;
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        boolean traceEnabled = this.log.isTraceEnabled();
        ServerSession session = this.getServerSession();
        try (SeekableByteChannel channel = accessor.openFile(this, null, path, null, Collections.emptySet(), new FileAttribute[0]);){
            channel.position(startOffset);
            if (NumberUtils.length((byte[])quickCheckHash) <= 0) {
                hashMatches = true;
            } else {
                int readLen = channel.read(wb);
                if (readLen < 0) {
                    throw new EOFException("EOF while read initial buffer from " + path);
                }
                effectiveLength -= (long)readLen;
                digest.update(digestBuf, 0, readLen);
                hashValue = digest.digest();
                hashMatches = Arrays.equals(quickCheckHash, hashValue);
                if (hashMatches) {
                    if (effectiveLength > 0L) {
                        digest = BuiltinDigests.md5.create();
                        digest.init();
                        digest.update(digestBuf, 0, readLen);
                        hashValue = null;
                    }
                } else if (traceEnabled) {
                    this.log.trace("doMD5Hash({})({}) offset={}, length={} - quick-hash mismatched expected={}, actual={}", new Object[]{session, path, startOffset, length, BufferUtils.toHex((char)':', (byte[])quickCheckHash), BufferUtils.toHex((char)':', (byte[])hashValue)});
                }
            }
            if (hashMatches) {
                while (effectiveLength > 0L) {
                    int remainLen = Math.min(digestBuf.length, (int)effectiveLength);
                    ByteBuffer bb = wb;
                    if (remainLen < digestBuf.length) {
                        bb = ByteBuffer.wrap(digestBuf, 0, remainLen);
                    }
                    bb.clear();
                    int readLen = channel.read(bb);
                    if (readLen < 0) break;
                    effectiveLength -= (long)readLen;
                    digest.update(digestBuf, 0, readLen);
                }
                if (hashValue == null) {
                    hashValue = digest.digest();
                }
            } else {
                hashValue = GenericUtils.EMPTY_BYTE_ARRAY;
            }
            accessor.closeFile(this, null, path, null, channel, Collections.emptySet());
        }
        if (traceEnabled) {
            this.log.trace("doMD5Hash({})({}) offset={}, length={} - matches={}, quick={} hash={}", new Object[]{session, path, startOffset, length, hashMatches, BufferUtils.toHex((char)':', (byte[])quickCheckHash), BufferUtils.toHex((char)':', (byte[])hashValue)});
        }
        return hashValue;
    }

    protected abstract void doCheckFileHash(int var1, String var2, String var3, Collection<String> var4, long var5, long var7, int var9, Buffer var10) throws Exception;

    protected void doReadLink(Buffer buffer, int id) throws IOException {
        AbstractMap.SimpleImmutableEntry<Path, String> link;
        String path = buffer.getString();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doReadLink({})[id={}] SSH_FXP_READLINK path={}", new Object[]{this.getServerSession(), id, path});
            }
            link = this.doReadLink(id, path);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 19, path);
            return;
        }
        this.sendLink(this.prepareReply(buffer), id, (Path)link.getKey(), (String)link.getValue());
    }

    protected AbstractMap.SimpleImmutableEntry<Path, String> doReadLink(int id, String path) throws IOException {
        Path link = this.resolveFile(path);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        String target = accessor.resolveLinkTarget(this, link);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doReadLink({})[id={}] path={}[{}]: {}", new Object[]{this.getServerSession(), id, path, link, target});
        }
        return new AbstractMap.SimpleImmutableEntry<Path, String>(link, target);
    }

    protected void doRename(Buffer buffer, int id) throws IOException {
        String oldPath = buffer.getString();
        String newPath = buffer.getString();
        int flags = 0;
        int version = this.getVersion();
        if (version >= 5) {
            flags = buffer.getInt();
        }
        try {
            this.doRename(id, oldPath, newPath, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 18, oldPath, newPath, flags);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doRename(int id, String oldPath, String newPath, int flags) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doRename({})[id={}] SSH_FXP_RENAME (oldPath={}, newPath={}, flags=0x{})", new Object[]{this.getServerSession(), id, oldPath, newPath, Integer.toHexString(flags)});
        }
        List<CopyOption> opts = Collections.emptyList();
        if (flags != 0) {
            opts = new ArrayList();
            if ((flags & 2) == 2) {
                opts.add(StandardCopyOption.ATOMIC_MOVE);
            }
            if ((flags & 1) == 1) {
                opts.add(StandardCopyOption.REPLACE_EXISTING);
            }
        }
        this.doRename(id, oldPath, newPath, opts);
    }

    protected void doRename(int id, String oldPath, String newPath, Collection<CopyOption> opts) throws IOException {
        Path o = this.resolveFile(oldPath);
        Path n = this.resolveFile(newPath);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session = this.getServerSession();
        listener.moving(session, o, n, opts);
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            accessor.renameFile(this, o, n, opts);
        }
        catch (IOException | Error | RuntimeException e) {
            listener.moved(session, o, n, opts, e);
            throw e;
        }
        listener.moved(session, o, n, opts, null);
    }

    protected void doPosixRename(Buffer buffer, int id) throws IOException {
        String oldPath = buffer.getString();
        String newPath = buffer.getString();
        try {
            int flags = 3;
            this.doRename(id, oldPath, newPath, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 200, 18, oldPath, newPath);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doCopyData(Buffer buffer, int id) throws IOException {
        String readHandle = buffer.getString();
        long readOffset = buffer.getLong();
        long readLength = buffer.getLong();
        String writeHandle = buffer.getString();
        long writeOffset = buffer.getLong();
        try {
            this.doCopyData(id, readHandle, readOffset, readLength, writeHandle, writeOffset);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 200, "copy-data", readHandle, readOffset, readLength, writeHandle, writeOffset);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doCopyData(int var1, String var2, long var3, long var5, String var7, long var8) throws IOException;

    protected void doCopyFile(Buffer buffer, int id) throws IOException {
        String srcFile = buffer.getString();
        String dstFile = buffer.getString();
        boolean overwriteDestination = buffer.getBoolean();
        try {
            this.doCopyFile(id, srcFile, dstFile, overwriteDestination);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 200, "copy-file", srcFile, dstFile, overwriteDestination);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doCopyFile(int id, String srcFile, String dstFile, boolean overwriteDestination) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doCopyFile({})[id={}] SSH_FXP_EXTENDED[{}] (src={}, dst={}, overwrite=0x{})", new Object[]{this.getServerSession(), id, "copy-file", srcFile, dstFile, overwriteDestination});
        }
        this.doCopyFile(id, srcFile, dstFile, overwriteDestination ? Collections.singletonList(StandardCopyOption.REPLACE_EXISTING) : Collections.emptyList());
    }

    protected void doCopyFile(int id, String srcFile, String dstFile, Collection<CopyOption> opts) throws IOException {
        Path src = this.resolveFile(srcFile);
        Path dst = this.resolveFile(dstFile);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.copyFile(this, src, dst, opts);
    }

    protected void doBlock(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long offset = buffer.getLong();
        long length = buffer.getLong();
        int mask = buffer.getInt();
        try {
            this.doBlock(id, handle, offset, length, mask);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 22, handle, offset, length, mask);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doBlock(int var1, String var2, long var3, long var5, int var7) throws IOException;

    protected void doUnblock(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long offset = buffer.getLong();
        long length = buffer.getLong();
        try {
            this.doUnblock(id, handle, offset, length);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 23, handle, offset, length);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doUnblock(int var1, String var2, long var3, long var5) throws IOException;

    protected void doStat(Buffer buffer, int id) throws IOException {
        Map<String, Object> attrs;
        String path = buffer.getString();
        int flags = 65535;
        int version = this.getVersion();
        if (version >= 4) {
            flags = buffer.getInt();
        }
        try {
            attrs = this.doStat(id, path, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 17, path, flags);
            return;
        }
        this.sendAttrs(this.prepareReply(buffer), id, attrs);
    }

    protected Map<String, Object> doStat(int id, String path, int flags) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doStat({})[id={}] SSH_FXP_STAT (path={}, flags=0x{})", new Object[]{this.getServerSession(), id, path, Integer.toHexString(flags)});
        }
        Path p = this.resolveFile(path);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        boolean followLinks = this.resolvePathResolutionFollowLinks(17, "", p);
        LinkOption[] options = accessor.resolveFileAccessLinkOptions(this, p, 17, "", followLinks);
        return this.resolveFileAttributes(p, flags, !followLinks, options);
    }

    protected void doRealPath(Buffer buffer, int id) throws IOException {
        AbstractMap.SimpleImmutableEntry<Path, Boolean> result;
        Map attrs;
        block20: {
            String path = buffer.getString();
            boolean debugEnabled = this.log.isDebugEnabled();
            ServerSession session = this.getServerSession();
            if (debugEnabled) {
                this.log.debug("doRealPath({})[id={}] SSH_FXP_REALPATH (path={})", new Object[]{session, id, path});
            }
            if (GenericUtils.isEmpty((CharSequence)(path = GenericUtils.trimToEmpty((String)path)))) {
                path = ".";
            }
            attrs = Collections.emptyMap();
            try {
                int version = this.getVersion();
                if (version < 6) {
                    Path p = this.resolveFile(path);
                    LinkOption[] options = this.getPathResolutionLinkOption(16, "", p);
                    result = this.doRealPathV345(id, path, p, options);
                    break block20;
                }
                int control = 1;
                if (buffer.available() > 0) {
                    control = buffer.getUByte();
                    if (debugEnabled) {
                        this.log.debug("doRealPath({}) - control=0x{} for path={}", new Object[]{session, Integer.toHexString(control), path});
                    }
                }
                LinkedList<String> extraPaths = new LinkedList<String>();
                while (buffer.available() > 0) {
                    extraPaths.add(buffer.getString());
                }
                Path p = this.resolveFile(path);
                LinkOption[] options = this.getPathResolutionLinkOption(16, "", p);
                result = this.doRealPathV6(id, path, extraPaths, p, options);
                p = (Path)result.getKey();
                Boolean status = (Boolean)result.getValue();
                switch (control) {
                    case 2: {
                        if (status == null) {
                            attrs = this.handleUnknownStatusFileAttributes(p, 65535, options);
                            break;
                        }
                        if (status.booleanValue()) {
                            try {
                                attrs = this.getAttributes(p, options);
                            }
                            catch (IOException e) {
                                this.debug("doRealPath({}) - failed ({}) to retrieve attributes of {}: {}", session, e.getClass().getSimpleName(), p, e.getMessage(), e);
                            }
                            break;
                        }
                        if (debugEnabled) {
                            this.log.debug("doRealPath({}) - dummy attributes for non-existing file: {}", (Object)session, (Object)p);
                        }
                        break;
                    }
                    case 3: {
                        if (status == null) {
                            attrs = this.handleUnknownStatusFileAttributes(p, 65535, options);
                            break;
                        }
                        if (status.booleanValue()) {
                            attrs = this.getAttributes(p, options);
                            break;
                        }
                        throw new NoSuchFileException(p.toString(), p.toString(), "Real path N/A for target");
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.log.warn("doRealPath({}) unknown control value 0x{} for path={}", new Object[]{session, Integer.toHexString(control), p});
                    }
                }
            }
            catch (IOException | RuntimeException e) {
                this.sendStatus(this.prepareReply(buffer), id, e, 16, path);
                return;
            }
        }
        this.sendPath(this.prepareReply(buffer), id, (Path)result.getKey(), attrs);
    }

    protected AbstractMap.SimpleImmutableEntry<Path, Boolean> doRealPathV6(int id, String path, Collection<String> extraPaths, Path p, LinkOption ... options) throws IOException {
        int numExtra = GenericUtils.size(extraPaths);
        if (numExtra > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doRealPathV6({})[id={}] path={}, extra={}", new Object[]{this.getServerSession(), id, path, extraPaths});
            }
            StringBuilder sb = new StringBuilder(GenericUtils.length((CharSequence)path) + numExtra * 8);
            sb.append(path);
            for (String p2 : extraPaths) {
                p = p.resolve(p2);
                options = this.getPathResolutionLinkOption(16, "", p);
                sb.append('/').append(p2);
            }
            path = sb.toString();
        }
        return this.validateRealPath(id, path, p, options);
    }

    protected AbstractMap.SimpleImmutableEntry<Path, Boolean> doRealPathV345(int id, String path, Path p, LinkOption ... options) throws IOException {
        return this.validateRealPath(id, path, p, options);
    }

    protected AbstractMap.SimpleImmutableEntry<Path, Boolean> validateRealPath(int id, String path, Path f, LinkOption ... options) throws IOException {
        Path p = this.normalize(f);
        Boolean status = IoUtils.checkFileExistsAnySymlinks((Path)p, (!IoUtils.followLinks((LinkOption[])options) ? 1 : 0) != 0);
        return new AbstractMap.SimpleImmutableEntry<Path, Boolean>(p, status);
    }

    protected void doRemoveDirectory(Buffer buffer, int id) throws IOException {
        String path = buffer.getString();
        try {
            this.doRemoveDirectory(id, path);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 15, path);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doRemoveDirectory(int id, String path) throws IOException {
        Path p = this.resolveFile(path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doRemoveDirectory({})[id={}] SSH_FXP_RMDIR (path={})[{}]", new Object[]{this.getServerSession(), id, path, p});
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        boolean followLinks = this.resolvePathResolutionFollowLinks(15, "", p);
        Boolean symlinkCheck = this.validateParentExistWithNoSymlinksIfNeverFollowSymlinks(p, !followLinks);
        if (!Boolean.TRUE.equals(symlinkCheck)) {
            throw new AccessDeniedException(p.toString(), p.toString(), "Parent directories do not exist ore are prohibited symlinks");
        }
        LinkOption[] options = accessor.resolveFileAccessLinkOptions(this, p, 15, "", false);
        if (!Files.isDirectory(p, options)) {
            throw this.signalRemovalPreConditionFailure(id, path, p, new NotDirectoryException(p.toString()), true);
        }
        this.doRemove(id, p, true);
    }

    protected void doRemove(int id, Path p, boolean isDirectory) throws IOException {
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session = this.getServerSession();
        listener.removing(session, p, isDirectory);
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            accessor.removeFile(this, p, isDirectory);
        }
        catch (IOException | Error | RuntimeException e) {
            listener.removed(session, p, isDirectory, e);
            throw e;
        }
        listener.removed(session, p, isDirectory, null);
    }

    protected void doMakeDirectory(Buffer buffer, int id) throws IOException {
        String path = buffer.getString();
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            this.doMakeDirectory(id, path, attrs);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 14, path, attrs);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doMakeDirectory(int id, String path, Map<String, ?> attrs) throws IOException {
        Path resolvedPath = this.resolveFile(path);
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doMakeDirectory({})[id={}] SSH_FXP_MKDIR (path={}[{}], attrs={})", new Object[]{session, id, path, resolvedPath, attrs});
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        LinkOption[] options = accessor.resolveFileAccessLinkOptions(this, resolvedPath, 14, "", false);
        boolean followLinks = this.resolvePathResolutionFollowLinks(14, "", resolvedPath);
        SftpPathImpl.withAttributeCache(resolvedPath, p -> {
            Boolean symlinkCheck = this.validateParentExistWithNoSymlinksIfNeverFollowSymlinks((Path)p, !followLinks);
            if (!Boolean.TRUE.equals(symlinkCheck)) {
                throw new AccessDeniedException(p.toString(), p.toString(), "Parent directories do not exist ore are prohibited symlinks");
            }
            Boolean fileExists = IoUtils.checkFileExists((Path)p, (LinkOption[])options);
            if (fileExists == null) {
                throw new AccessDeniedException(p.toString(), p.toString(), "Cannot validate make-directory existence");
            }
            if (fileExists.booleanValue()) {
                if (Files.isDirectory(p, options)) {
                    throw new FileAlreadyExistsException(p.toString(), p.toString(), "Target directory already exists");
                }
                throw new FileAlreadyExistsException(p.toString(), p.toString(), "Already exists as a file");
            }
            return null;
        });
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.creating(session, resolvedPath, attrs);
        try {
            accessor.createDirectory(this, resolvedPath);
            this.doSetAttributes(14, "", resolvedPath, attrs, followLinks);
        }
        catch (IOException | Error | RuntimeException e) {
            listener.created(session, resolvedPath, attrs, e);
            throw e;
        }
        listener.created(session, resolvedPath, attrs, null);
    }

    protected void doRemove(Buffer buffer, int id) throws IOException {
        String path = buffer.getString();
        try {
            this.doRemoveFile(id, path);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 13, path);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doRemoveFile(int id, String path) throws IOException {
        Path resolvedPath = this.resolveFile(path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doRemoveFile({})[id={}] SSH_FXP_REMOVE (path={}[{}])", new Object[]{this.getServerSession(), id, path, resolvedPath});
        }
        boolean followLinks = this.resolvePathResolutionFollowLinks(13, "", resolvedPath);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        LinkOption[] options = accessor.resolveFileAccessLinkOptions(this, resolvedPath, 13, "", false);
        SftpPathImpl.withAttributeCache(resolvedPath, p -> {
            Boolean status = this.checkSymlinkState((Path)p, followLinks, options);
            if (status == null) {
                throw this.signalRemovalPreConditionFailure(id, path, (Path)p, (IOException)new AccessDeniedException(p.toString(), p.toString(), "Cannot determine existence of remove candidate"), false);
            }
            if (!status.booleanValue()) {
                throw this.signalRemovalPreConditionFailure(id, path, (Path)p, (IOException)new NoSuchFileException(p.toString(), p.toString(), "Removal candidate not found"), false);
            }
            if (Files.isDirectory(p, options)) {
                throw this.signalRemovalPreConditionFailure(id, path, (Path)p, (IOException)new SftpException(24, p.toString() + " is a folder"), false);
            }
            return null;
        });
        this.doRemove(id, resolvedPath, false);
    }

    protected <E extends IOException> E signalRemovalPreConditionFailure(int id, String pathValue, Path path, E thrown, boolean isRemoveDirectory) throws IOException {
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("signalRemovalPreConditionFailure(id={})[{}] signal {} for (directory={}) {}: {}", new Object[]{id, pathValue, thrown.getClass().getSimpleName(), isRemoveDirectory, path, thrown.getMessage()});
        }
        listener.removing(session, path, isRemoveDirectory);
        listener.removed(session, path, isRemoveDirectory, thrown);
        return thrown;
    }

    protected void doExtended(Buffer buffer, int id) throws IOException {
        String extension = buffer.getString();
        try {
            SftpEventListener listener = this.getSftpEventListenerProxy();
            ServerSession session = this.getServerSession();
            listener.receivedExtension(session, extension, id);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 200, extension);
            return;
        }
        this.executeExtendedCommand(buffer, id, extension);
    }

    protected void executeExtendedCommand(Buffer buffer, int id, String extension) throws IOException {
        switch (extension) {
            case "text-seek": {
                this.doTextSeek(buffer, id);
                break;
            }
            case "version-select": {
                this.doVersionSelect(buffer, id);
                break;
            }
            case "copy-file": {
                this.doCopyFile(buffer, id);
                break;
            }
            case "copy-data": {
                this.doCopyData(buffer, id);
                break;
            }
            case "md5-hash": 
            case "md5-hash-handle": {
                this.doMD5Hash(buffer, id, extension);
                break;
            }
            case "check-file-handle": 
            case "check-file-name": {
                this.doCheckFileHash(buffer, id, extension);
                break;
            }
            case "fsync@openssh.com": {
                this.doOpenSSHFsync(buffer, id);
                break;
            }
            case "space-available": {
                this.doSpaceAvailable(buffer, id);
                break;
            }
            case "hardlink@openssh.com": {
                this.doOpenSSHHardLink(buffer, id);
                break;
            }
            case "lsetstat@openssh.com": {
                this.doSetStat(buffer, id, extension, -1, Boolean.FALSE);
                break;
            }
            case "posix-rename@openssh.com": {
                this.doPosixRename(buffer, id);
                break;
            }
            case "limits@openssh.com": {
                this.doOpenSSHLimits(buffer, id);
                break;
            }
            default: {
                this.doUnsupportedExtension(buffer, id, extension);
            }
        }
    }

    protected void doUnsupportedExtension(Buffer buffer, int id, String extension) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("executeExtendedCommand({}) received unsupported SSH_FXP_EXTENDED({})", (Object)this.getServerSession(), (Object)extension);
        }
        this.sendStatus(this.prepareReply(buffer), id, 8, "Command SSH_FXP_EXTENDED(" + extension + ") is unsupported or not implemented");
    }

    protected void appendExtensions(Buffer buffer, String supportedVersions) {
        ArrayList<String> extras;
        ServerSession session = this.getServerSession();
        this.appendVersionsExtension(buffer, supportedVersions, session);
        this.appendNewlineExtension(buffer, session);
        this.appendVendorIdExtension(buffer, VersionProperties.getVersionProperties(), session);
        this.appendOpenSSHExtensions(buffer, session);
        this.appendAclSupportedExtension(buffer, session);
        Map<String, OptionalFeature> extensions = this.getSupportedClientExtensions(session);
        int numExtensions = MapEntryUtils.size(extensions);
        ArrayList<String> arrayList = extras = numExtensions <= 0 ? Collections.emptyList() : new ArrayList<String>(numExtensions);
        if (numExtensions > 0) {
            boolean debugEnabled = this.log.isDebugEnabled();
            for (Map.Entry<String, OptionalFeature> ee : extensions.entrySet()) {
                String name = ee.getKey();
                OptionalFeature f = ee.getValue();
                if (!f.isSupported()) {
                    if (!debugEnabled) continue;
                    this.log.debug("appendExtensions({}) skip unsupported extension={}", (Object)session, (Object)name);
                    continue;
                }
                extras.add(name);
            }
        }
        this.appendSupportedExtension(buffer, extras);
        this.appendSupported2Extension(buffer, extras);
    }

    protected int appendAclSupportedExtension(Buffer buffer, ServerSession session) {
        Collection<Integer> maskValues = this.resolveAclSupportedCapabilities(session);
        int mask = AclSupportedParser.AclCapabilities.constructAclCapabilities(maskValues);
        if (mask != 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("appendAclSupportedExtension({}) capabilities={}", (Object)session, AclSupportedParser.AclCapabilities.decodeAclCapabilities(mask));
            }
            buffer.putString("acl-supported");
            int lenPos = buffer.wpos();
            buffer.putUInt(0L);
            buffer.putInt((long)mask);
            BufferUtils.updateLengthPlaceholder((Buffer)buffer, (int)lenPos);
        }
        return mask;
    }

    protected Collection<Integer> resolveAclSupportedCapabilities(ServerSession session) {
        String override = (String)SftpModuleProperties.ACL_SUPPORTED_MASK.getOrNull((PropertyResolver)session);
        if (override == null) {
            return DEFAULT_ACL_SUPPORTED_MASK;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveAclSupportedCapabilities({}) override='{}'", (Object)session, (Object)override);
        }
        if (override.length() == 0) {
            return Collections.emptySet();
        }
        String[] names = GenericUtils.split((String)override, (char)',');
        HashSet<Integer> maskValues = new HashSet<Integer>(names.length);
        for (String n : names) {
            Integer v = (Integer)ValidateUtils.checkNotNull((Object)AclSupportedParser.AclCapabilities.getAclCapabilityValue(n), (String)"Unknown ACL capability: %s", (Object)n);
            maskValues.add(v);
        }
        return maskValues;
    }

    protected List<AbstractOpenSSHExtensionParser.OpenSSHExtension> appendOpenSSHExtensions(Buffer buffer, ServerSession session) {
        List<AbstractOpenSSHExtensionParser.OpenSSHExtension> extList = this.resolveOpenSSHExtensions(session);
        if (GenericUtils.isEmpty(extList)) {
            return extList;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("appendOpenSSHExtensions({}): {}", (Object)session, extList);
        }
        for (AbstractOpenSSHExtensionParser.OpenSSHExtension ext : extList) {
            buffer.putString(ext.getName());
            buffer.putString(ext.getVersion());
        }
        return extList;
    }

    protected List<AbstractOpenSSHExtensionParser.OpenSSHExtension> resolveOpenSSHExtensions(ServerSession session) {
        Object[] pairs;
        int numExts;
        String value = (String)SftpModuleProperties.OPENSSH_EXTENSIONS.getOrNull((PropertyResolver)session);
        if (value == null) {
            return DEFAULT_OPEN_SSH_EXTENSIONS;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveOpenSSHExtensions({}) override='{}'", (Object)session, (Object)value);
        }
        if ((numExts = GenericUtils.length((Object[])(pairs = GenericUtils.split((String)value, (char)',')))) <= 0) {
            return Collections.emptyList();
        }
        ArrayList<AbstractOpenSSHExtensionParser.OpenSSHExtension> extList = new ArrayList<AbstractOpenSSHExtensionParser.OpenSSHExtension>(numExts);
        for (Object nvp : pairs) {
            if (GenericUtils.isEmpty((CharSequence)(nvp = GenericUtils.trimToEmpty((String)nvp)))) continue;
            int pos = ((String)nvp).indexOf(61);
            ValidateUtils.checkTrue((pos > 0 && pos < ((String)nvp).length() - 1 ? 1 : 0) != 0, (String)"Malformed OpenSSH extension spec: %s", (Object)nvp);
            String name = GenericUtils.trimToEmpty((String)((String)nvp).substring(0, pos));
            String version = GenericUtils.trimToEmpty((String)((String)nvp).substring(pos + 1));
            extList.add(new AbstractOpenSSHExtensionParser.OpenSSHExtension(name, ValidateUtils.checkNotNullAndNotEmpty((String)version, (String)"No version specified for OpenSSH extension %s", (Object)name)));
        }
        return extList;
    }

    protected Map<String, OptionalFeature> getSupportedClientExtensions(ServerSession session) {
        String value = (String)SftpModuleProperties.CLIENT_EXTENSIONS.getOrNull((PropertyResolver)session);
        if (value == null) {
            return DEFAULT_SUPPORTED_CLIENT_EXTENSIONS;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getSupportedClientExtensions({}) override='{}'", (Object)session, (Object)value);
        }
        if (value.length() <= 0) {
            return Collections.emptyMap();
        }
        if (value.indexOf(44) <= 0) {
            return Collections.singletonMap(value, OptionalFeature.TRUE);
        }
        String[] comps = GenericUtils.split((String)value, (char)',');
        LinkedHashMap<String, OptionalFeature> result = new LinkedHashMap<String, OptionalFeature>(comps.length);
        for (String c : comps) {
            result.put(c, OptionalFeature.TRUE);
        }
        return result;
    }

    protected String appendVersionsExtension(Buffer buffer, String value, ServerSession session) {
        if (GenericUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("appendVersionsExtension({}) value={}", (Object)session, (Object)value);
        }
        buffer.putString("versions");
        buffer.putString(value);
        return value;
    }

    protected String appendNewlineExtension(Buffer buffer, ServerSession session) {
        String value = this.resolveNewlineValue(session);
        if (GenericUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("appendNewlineExtension({}) value={}", (Object)session, (Object)BufferUtils.toHex((char)':', (byte[])value.getBytes(StandardCharsets.UTF_8)));
        }
        buffer.putString("newline");
        buffer.putString(value);
        return value;
    }

    protected String resolveNewlineValue(ServerSession session) {
        return (String)SftpModuleProperties.NEWLINE_VALUE.getRequired((PropertyResolver)session);
    }

    protected Map<String, ?> appendVendorIdExtension(Buffer buffer, Map<String, ?> versionProperties, ServerSession session) {
        if (MapEntryUtils.isEmpty(versionProperties)) {
            return versionProperties;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("appendVendorIdExtension({}): {}", (Object)session, versionProperties);
        }
        buffer.putString("vendor-id");
        PropertyResolver resolver = PropertyResolverUtils.toPropertyResolver(Collections.unmodifiableMap(versionProperties));
        int lenPos = buffer.wpos();
        buffer.putUInt(0L);
        buffer.putString(resolver.getStringProperty("groupId", this.getClass().getPackage().getName()));
        buffer.putString(resolver.getStringProperty("artifactId", this.getClass().getSimpleName()));
        buffer.putString(resolver.getStringProperty("version", "SSHD-UNKNOWN"));
        buffer.putLong(0L);
        BufferUtils.updateLengthPlaceholder((Buffer)buffer, (int)lenPos);
        return versionProperties;
    }

    protected void appendSupportedExtension(Buffer buffer, Collection<String> extras) {
        buffer.putString("supported");
        int lenPos = buffer.wpos();
        buffer.putUInt(0L);
        buffer.putInt(701L);
        buffer.putUInt(0L);
        buffer.putInt(63L);
        buffer.putUInt(0L);
        buffer.putUInt(0L);
        buffer.putStringList(extras, false);
        BufferUtils.updateLengthPlaceholder((Buffer)buffer, (int)lenPos);
    }

    protected void appendSupported2Extension(Buffer buffer, Collection<String> extras) {
        buffer.putString("supported2");
        int lenPos = buffer.wpos();
        buffer.putUInt(0L);
        buffer.putInt(701L);
        buffer.putUInt(0L);
        buffer.putInt(15L);
        buffer.putUInt(0L);
        buffer.putUInt(0L);
        buffer.putShort(0);
        buffer.putShort(0);
        buffer.putStringList(Collections.emptyList(), true);
        buffer.putStringList(extras, true);
        BufferUtils.updateLengthPlaceholder((Buffer)buffer, (int)lenPos);
    }

    protected void sendHandle(Buffer buffer, int id, String handle) throws IOException {
        buffer.putByte((byte)102);
        buffer.putInt((long)id);
        buffer.putString(handle);
        this.send(buffer);
    }

    protected void sendAttrs(Buffer buffer, int id, Map<String, ?> attributes) throws IOException {
        buffer.putByte((byte)105);
        buffer.putInt((long)id);
        this.writeAttrs(buffer, attributes);
        this.send(buffer);
    }

    protected void sendLink(Buffer buffer, int id, Path file, String link) throws IOException {
        buffer.putByte((byte)104);
        buffer.putInt((long)id);
        buffer.putUInt(1L);
        String unixPath = link.replace(File.separatorChar, '/');
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.putRemoteFileName(this, file, buffer, unixPath, true);
        Map attrs = Collections.emptyMap();
        int version = this.getVersion();
        if (version == 3) {
            String longName = SftpHelper.getLongName(unixPath, attrs);
            accessor.putRemoteFileName(this, file, buffer, longName, false);
        }
        this.writeAttrs(buffer, attrs);
        SftpHelper.indicateEndOfNamesList(buffer, this.getVersion(), (PropertyResolver)this.getServerSession());
        this.send(buffer);
    }

    protected void sendPath(Buffer buffer, int id, Path f, Map<String, ?> attrs) throws IOException {
        buffer.putByte((byte)104);
        buffer.putInt((long)id);
        buffer.putUInt(1L);
        String originalPath = f.toString();
        String unixPath = originalPath.replace(File.separatorChar, '/');
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.putRemoteFileName(this, f, buffer, unixPath, true);
        int version = this.getVersion();
        if (version == 3) {
            String longName = this.getLongName(f, this.getShortName(f), attrs);
            accessor.putRemoteFileName(this, f, buffer, longName, false);
        }
        this.writeAttrs(buffer, attrs);
        SftpHelper.indicateEndOfNamesList(buffer, this.getVersion(), (PropertyResolver)this.getServerSession());
        this.send(buffer);
    }

    protected int doReadDir(int id, String handle, DirectoryHandle dir, Buffer buffer, int maxSize, boolean followLinks) throws IOException {
        ServerSession session = this.getServerSession();
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        LinkOption[] options = accessor.resolveFileAccessLinkOptions(this, dir.getFile(), 12, "", followLinks);
        int nb = 0;
        TreeMap<String, Path> entries = new TreeMap<String, Path>(Comparator.naturalOrder());
        while ((dir.isSendDot() || dir.isSendDotDot() || dir.hasNext()) && buffer.wpos() < maxSize) {
            if (dir.isSendDot()) {
                this.writeDirEntry(id, dir, entries, buffer, nb, dir.getFile(), ".", options);
                dir.markDotSent();
            } else if (dir.isSendDotDot()) {
                Path dirPath = dir.getFile();
                Path parentPath = dirPath.getParent();
                if (parentPath != null) {
                    this.writeDirEntry(id, dir, entries, buffer, nb, parentPath, "..", options);
                }
                dir.markDotDotSent();
            } else {
                SftpClient.Attributes attributes;
                Path f = dir.next();
                String shortName = this.getShortName(f);
                if (f instanceof SftpPath && (attributes = ((SftpPath)((Object)f)).getAttributes()) != null) {
                    entries.put(shortName, f);
                    this.writeDirEntry(session, id, buffer, nb, f, shortName, attributes);
                    ++nb;
                    continue;
                }
                this.writeDirEntry(id, dir, entries, buffer, nb, f, shortName, options);
            }
            ++nb;
        }
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.readEntries(session, handle, dir, entries);
        return nb;
    }

    protected void writeDirEntry(ServerSession session, int id, Buffer buffer, int index, Path f, String shortName, SftpClient.Attributes attributes) throws IOException {
        int version = this.getVersion();
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.putRemoteFileName(this, f, buffer, shortName, true);
        if (version == 3) {
            String longName = this.getLongName(f, shortName, attributes);
            accessor.putRemoteFileName(this, f, buffer, longName, false);
            if (this.log.isTraceEnabled()) {
                this.log.trace("writeDirEntry({}) id={})[{}] - writing entry {} [{}]: {}", new Object[]{session, id, index, shortName, longName, attributes});
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("writeDirEntry({}) id={})[{}] - writing entry {}: {}", new Object[]{session, id, index, shortName, attributes});
        }
        SftpHelper.writeAttributes(buffer, attributes, version);
    }

    protected void writeDirEntry(int id, DirectoryHandle dir, Map<String, Path> entries, Buffer buffer, int index, Path f, String shortName, LinkOption ... options) throws IOException {
        boolean followLinks = this.resolvePathResolutionFollowLinks(12, "", f);
        NavigableMap<String, Object> attrs = this.resolveFileAttributes(f, 65535, !followLinks, options);
        entries.put(shortName, f);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        ServerSession session = this.getServerSession();
        accessor.putRemoteFileName(this, f, buffer, shortName, true);
        int version = this.getVersion();
        if (version == 3) {
            String longName = this.getLongName(f, shortName, options);
            accessor.putRemoteFileName(this, f, buffer, longName, false);
            if (this.log.isTraceEnabled()) {
                this.log.trace("writeDirEntry({} id={})[{}] - {} [{}]: {}", new Object[]{session, id, index, shortName, longName, attrs});
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("writeDirEntry({} id={})[{}] - {}: {}", new Object[]{session, id, index, shortName, attrs});
        }
        this.writeAttrs(buffer, attrs);
    }

    protected String getLongName(Path f, String shortName, LinkOption ... options) throws IOException {
        return this.getLongName(f, shortName, true, options);
    }

    protected String getLongName(Path f, String shortName, boolean sendAttrs, LinkOption ... options) throws IOException {
        Map<Object, Object> attributes = sendAttrs ? this.getAttributes(f, options) : Collections.emptyMap();
        return this.getLongName(f, shortName, attributes);
    }

    protected String getLongName(Path f, String shortName, Map<String, ?> attributes) throws IOException {
        return SftpHelper.getLongName(shortName, attributes);
    }

    protected String getLongName(Path f, String shortName, SftpClient.Attributes attributes) throws IOException {
        return this.getLongName(f, shortName, MapEntryUtils.MapBuilder.builder().put((Object)"owner", (Object)attributes.getOwner()).put((Object)"group", (Object)attributes.getGroup()).put((Object)"size", (Object)attributes.getSize()).put((Object)"isDirectory", (Object)attributes.isDirectory()).put((Object)"isSymbolicLink", (Object)attributes.isSymbolicLink()).put((Object)"permissions", SftpHelper.permissionsToAttributes(attributes.getPermissions())).put((Object)"lastModifiedTime", (Object)attributes.getModifyTime()).build());
    }

    protected String getShortName(Path f) throws IOException {
        Path nrm = this.normalize(f);
        int count = nrm.getNameCount();
        if (OsUtils.isUNIX()) {
            Path name = f.getFileName();
            if (name == null) {
                Path p = this.resolveFile(".");
                name = p.getFileName();
            }
            if (name == null && count > 0) {
                name = nrm.getFileName();
            }
            if (name != null) {
                return name.toString();
            }
            return nrm.toString();
        }
        if (count > 0) {
            Path name = nrm.getFileName();
            return name.toString();
        }
        return nrm.toString().replace(File.separatorChar, '/');
    }

    protected NavigableMap<String, Object> resolveFileAttributes(Path path, int flags, boolean neverFollowSymLinks, LinkOption ... options) throws IOException {
        return (NavigableMap)SftpPathImpl.withAttributeCache(path, file -> {
            Boolean status = this.checkSymlinkState((Path)file, neverFollowSymLinks, options);
            if (status == null) {
                return this.handleUnknownStatusFileAttributes((Path)file, flags, options);
            }
            if (!status.booleanValue()) {
                throw new NoSuchFileException(file.toString(), file.toString(), "Attributes N/A for target");
            }
            return this.getAttributes((Path)file, flags, options);
        });
    }

    public Boolean checkSymlinkState(Path path, boolean neverFollowSymLinks, LinkOption[] options) {
        Boolean status = this.validateParentExistWithNoSymlinksIfNeverFollowSymlinks(path, neverFollowSymLinks);
        if (!Boolean.FALSE.equals(status)) {
            status = IoUtils.checkFileExists((Path)path, (LinkOption[])options);
        }
        return status;
    }

    public Boolean validateParentExistWithNoSymlinksIfNeverFollowSymlinks(Path path, boolean neverFollowSymLinks) {
        Boolean status = true;
        if (neverFollowSymLinks && path.getParent() != null) {
            status = IoUtils.checkFileExistsAnySymlinks((Path)path.getParent(), (boolean)true);
        }
        return status;
    }

    protected void writeAttrs(Buffer buffer, Map<String, ?> attributes) {
        SftpHelper.writeAttrs(buffer, this.getVersion(), attributes);
    }

    protected NavigableMap<String, Object> getAttributes(Path file, LinkOption ... options) throws IOException {
        return this.getAttributes(file, 65535, options);
    }

    protected NavigableMap<String, Object> handleUnknownStatusFileAttributes(Path file, int flags, LinkOption ... options) throws IOException {
        UnsupportedAttributePolicy policy = this.getUnsupportedAttributePolicy();
        switch (policy) {
            case Ignore: {
                break;
            }
            case ThrowException: {
                throw new AccessDeniedException(file.toString(), file.toString(), "Cannot determine existence for attributes of target");
            }
            case Warn: {
                this.log.warn("handleUnknownStatusFileAttributes({})[{}] cannot determine existence", (Object)this.getServerSession(), (Object)file);
                break;
            }
            default: {
                this.log.warn("handleUnknownStatusFileAttributes({})[{}] unknown policy: {}", new Object[]{this.getServerSession(), file, policy});
            }
        }
        return this.getAttributes(file, flags, options);
    }

    protected NavigableMap<String, Object> getAttributes(Path path, int flags, LinkOption ... options) throws IOException {
        NavigableMap attrs = (NavigableMap)SftpPathImpl.withAttributeCache(path, file -> this.resolveReportedFileAttributes((Path)file, flags, options));
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        return accessor.resolveReportedFileAttributes(this, path, flags, attrs, options);
    }

    protected NavigableMap<String, Object> resolveReportedFileAttributes(Path file, int flags, LinkOption ... options) throws IOException {
        FileSystem fs = file.getFileSystem();
        Set<String> supportedViews = fs.supportedFileAttributeViews();
        TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        List<String> views = GenericUtils.isEmpty(supportedViews) ? Collections.emptyList() : (supportedViews.contains("unix") ? SftpFileSystemAccessor.DEFAULT_UNIX_VIEW : GenericUtils.map(supportedViews, v -> v + ":*"));
        for (String v2 : views) {
            NavigableMap<String, Object> ta = this.readFileAttributes(file, v2, options);
            if (!MapEntryUtils.isNotEmpty(ta)) continue;
            attrs.putAll(ta);
        }
        NavigableMap<String, Object> completions = this.resolveMissingFileAttributes(file, flags, attrs, options);
        if (MapEntryUtils.isNotEmpty(completions)) {
            attrs.putAll(completions);
        }
        return attrs;
    }

    protected NavigableMap<String, Object> resolveMissingFileAttributes(Path file, int flags, Map<String, Object> current, LinkOption ... options) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        ServerSession session = this.getServerSession();
        TreeMap<String, Object> attrs = null;
        for (Map.Entry re : SftpFileSystemAccessor.FILEATTRS_RESOLVERS.entrySet()) {
            String name = (String)re.getKey();
            Object value = MapEntryUtils.isEmpty(current) ? null : current.get(name);
            FileInfoExtractor x = (FileInfoExtractor)re.getValue();
            try {
                Object resolved = this.resolveMissingFileAttributeValue(file, name, value, x, options);
                if (Objects.equals(resolved, value)) continue;
                if (attrs == null) {
                    attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                }
                attrs.put(name, resolved);
                if (!debugEnabled) continue;
                this.log.debug("resolveMissingFileAttributes({})[{}[{}]] replace {} with {}", new Object[]{session, file, name, value, resolved});
            }
            catch (IOException e) {
                this.warn("resolveMissingFileAttributes({})[{}[{}]] failed ({}) to resolve missing value: {}", session, file, name, e.getClass().getSimpleName(), e.getMessage(), e);
            }
        }
        if (attrs == null) {
            return Collections.emptyNavigableMap();
        }
        return attrs;
    }

    protected Object resolveMissingFileAttributeValue(Path file, String name, Object value, FileInfoExtractor<?> x, LinkOption ... options) throws IOException {
        if (value != null) {
            return value;
        }
        return x.infoOf(file, options);
    }

    protected NavigableMap<String, Object> addMissingAttribute(Path file, NavigableMap<String, Object> current, String name, FileInfoExtractor<?> x, LinkOption ... options) throws IOException {
        Object value;
        Object object = value = MapEntryUtils.isEmpty(current) ? null : (Object)current.get(name);
        if (value != null) {
            return current;
        }
        value = x.infoOf(file, options);
        if (value == null) {
            return current;
        }
        if (current == null) {
            current = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        }
        current.put(name, value);
        return current;
    }

    protected NavigableMap<String, Object> readFileAttributes(Path file, String view, LinkOption ... options) throws IOException {
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            Map<String, ?> attrs = accessor.readFileAttributes(this, file, view, options);
            if (MapEntryUtils.isEmpty(attrs)) {
                return Collections.emptyNavigableMap();
            }
            TreeMap<String, Object> sorted = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            sorted.putAll(attrs);
            return sorted;
        }
        catch (IOException e) {
            return this.handleReadFileAttributesException(file, view, options, e);
        }
    }

    protected NavigableMap<String, Object> handleReadFileAttributesException(Path file, String view, LinkOption[] options, IOException e) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("handleReadFileAttributesException(" + file + ")[" + view + "] details", (Throwable)e);
        }
        UnsupportedAttributePolicy policy = this.getUnsupportedAttributePolicy();
        switch (policy) {
            case Ignore: {
                break;
            }
            case Warn: {
                this.log.warn("handleReadFileAttributesException({})[{}] {}", new Object[]{file, view, e.toString()});
                break;
            }
            case ThrowException: {
                throw e;
            }
            default: {
                this.log.warn("handleReadFileAttributesException({})[{}] Unknown policy ({}) for {}", new Object[]{file, view, policy, e.toString()});
            }
        }
        return Collections.emptyNavigableMap();
    }

    protected void doSetAttributes(int cmd, String extension, Path file, Map<String, ?> attributes, boolean followLinks) throws IOException {
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session = this.getServerSession();
        listener.modifyingAttributes(session, file, attributes);
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            LinkOption[] options = accessor.resolveFileAccessLinkOptions(this, file, cmd, extension, followLinks);
            this.setFileAttributes(file, attributes, options);
        }
        catch (IOException | Error | RuntimeException e) {
            listener.modifiedAttributes(session, file, attributes, e);
            throw e;
        }
        listener.modifiedAttributes(session, file, attributes, null);
    }

    protected LinkOption[] getPathResolutionLinkOption(int cmd, String extension, Path path) throws IOException {
        boolean followLinks = this.resolvePathResolutionFollowLinks(cmd, extension, path);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        return accessor.resolveFileAccessLinkOptions(this, path, cmd, extension, followLinks);
    }

    protected boolean resolvePathResolutionFollowLinks(int cmd, String extension, Path path) throws IOException {
        return (Boolean)SftpModuleProperties.AUTO_FOLLOW_LINKS.getRequired((PropertyResolver)this.getServerSession());
    }

    protected void setFileAttributes(Path file, Map<String, ?> attributes, LinkOption ... options) throws IOException {
        TreeSet<String> unsupported = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        block33: for (Map.Entry<String, ?> ae : attributes.entrySet()) {
            String attribute = ae.getKey();
            Object value = ae.getValue();
            String view = null;
            switch (attribute) {
                case "size": {
                    long newSize = ((Number)value).longValue();
                    SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
                    HashSet<Enum> openOptions = new HashSet<Enum>();
                    openOptions.add(StandardOpenOption.WRITE);
                    if (!IoUtils.followLinks((LinkOption[])options)) {
                        openOptions.add(LinkOption.NOFOLLOW_LINKS);
                    }
                    SeekableByteChannel channel = accessor.openFile(this, null, file, null, openOptions, new FileAttribute[0]);
                    try {
                        channel.truncate(newSize);
                        accessor.closeFile(this, null, file, null, channel, openOptions);
                        continue block33;
                    }
                    finally {
                        if (channel == null) continue block33;
                        channel.close();
                        continue block33;
                    }
                }
                case "uid": {
                    view = "unix";
                    break;
                }
                case "gid": {
                    view = "unix";
                    break;
                }
                case "owner": {
                    view = "posix";
                    value = this.toUser(file, (UserPrincipal)value);
                    break;
                }
                case "group": {
                    view = "posix";
                    value = this.toGroup(file, (GroupPrincipal)value);
                    break;
                }
                case "permissions": {
                    view = "posix";
                    break;
                }
                case "acl": {
                    view = "acl";
                    break;
                }
                case "creationTime": {
                    view = "basic";
                    break;
                }
                case "lastModifiedTime": {
                    view = "basic";
                    break;
                }
                case "lastAccessTime": {
                    view = "basic";
                    break;
                }
                case "extended": {
                    view = "extended";
                    break;
                }
            }
            if (GenericUtils.length((CharSequence)view) <= 0 || value == null) continue;
            try {
                this.setFileAttribute(file, view, attribute, value, options);
            }
            catch (Exception e) {
                this.handleSetFileAttributeFailure(file, view, attribute, value, unsupported, e);
            }
        }
        this.handleUnsupportedAttributes(unsupported);
    }

    protected void handleSetFileAttributeFailure(Path file, String view, String attribute, Object value, Collection<String> unsupported, Exception e) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (e instanceof UnsupportedOperationException) {
            if (debugEnabled) {
                this.log.debug("handleSetFileAttributeFailure({})[{}] {}:{}={} unsupported: {}", new Object[]{this.getServerSession(), file, view, attribute, value, e.getMessage()});
            }
        } else {
            this.warn("handleSetFileAttributeFailure({})[{}] {}:{}={} - failed ({}) to set: {}", this.getServerSession(), file, view, attribute, value, e.getClass().getSimpleName(), e.getMessage(), e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        unsupported.add(attribute);
    }

    protected void setFileAttribute(Path file, String view, String attribute, Object value, LinkOption ... options) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("setFileAttribute({})[{}] {}:{}={}", new Object[]{this.getServerSession(), file, view, attribute, value});
        }
        if ("acl".equalsIgnoreCase(attribute) && "acl".equalsIgnoreCase(view)) {
            List acl = (List)value;
            this.setFileAccessControl(file, acl, options);
        } else if ("permissions".equalsIgnoreCase(attribute)) {
            Set perms = (Set)value;
            this.setFilePermissions(file, perms, options);
        } else if ("owner".equalsIgnoreCase(attribute) || "group".equalsIgnoreCase(attribute)) {
            this.setFileOwnership(file, attribute, (Principal)value, options);
        } else if ("creationTime".equalsIgnoreCase(attribute) || "lastModifiedTime".equalsIgnoreCase(attribute) || "lastAccessTime".equalsIgnoreCase(attribute)) {
            this.setFileTime(file, view, attribute, (FileTime)value, options);
        } else if ("extended".equalsIgnoreCase(attribute) && "extended".equalsIgnoreCase(view)) {
            Map extensions = (Map)value;
            this.setFileExtensions(file, extensions, options);
        } else {
            this.setFileRawViewAttribute(file, view, attribute, value, options);
        }
    }

    protected void setFileTime(Path file, String view, String attribute, FileTime value, LinkOption ... options) throws IOException {
        if (value == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setFileTime({})[{}] {}:{}={}", new Object[]{this.getServerSession(), file, view, attribute, value});
        }
        this.setFileRawViewAttribute(file, view, attribute, value, options);
    }

    protected void setFileRawViewAttribute(Path file, String view, String attribute, Object value, LinkOption ... options) throws IOException {
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.setFileAttribute(this, file, view, attribute, value, options);
    }

    protected void setFileOwnership(Path file, String attribute, Principal value, LinkOption ... options) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setFileOwnership({})[{}] {}={}", new Object[]{this.getServerSession(), file, attribute, value});
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        if ("owner".equalsIgnoreCase(attribute)) {
            accessor.setFileOwner(this, file, value, options);
        } else if ("group".equalsIgnoreCase(attribute)) {
            accessor.setGroupOwner(this, file, value, options);
        } else {
            throw new UnsupportedOperationException("Unknown ownership attribute: " + attribute);
        }
    }

    protected void setFileExtensions(Path file, Map<String, byte[]> extensions, LinkOption ... options) throws IOException {
        int version = this.getVersion();
        if (version < 6) {
            if (MapEntryUtils.isNotEmpty(extensions) && this.log.isDebugEnabled()) {
                this.log.debug("setFileExtensions({})[{}]: {}", new Object[]{this.getServerSession(), file, extensions.keySet()});
            }
        } else {
            if (MapEntryUtils.isEmpty(extensions)) {
                return;
            }
            throw new UnsupportedOperationException("File extensions not supported");
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.applyExtensionFileAttributes(this, file, extensions, options);
    }

    protected void setFilePermissions(Path file, Set<PosixFilePermission> perms, LinkOption ... options) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("setFilePermissions({})[{}] {}", new Object[]{this.getServerSession(), file, perms});
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.setFilePermissions(this, file, perms, options);
    }

    protected void setFileAccessControl(Path file, List<AclEntry> acl, LinkOption ... options) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("setFileAccessControl({})[{}] {}", new Object[]{this.getServerSession(), file, acl});
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.setFileAccessControl(this, file, acl, options);
    }

    protected void handleUnsupportedAttributes(Collection<String> attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        String attrsList = GenericUtils.join(attributes, (char)',');
        UnsupportedAttributePolicy policy = this.getUnsupportedAttributePolicy();
        switch (policy) {
            case Ignore: {
                break;
            }
            case Warn: {
                this.log.warn("Unsupported attributes: {}", (Object)attrsList);
                break;
            }
            case ThrowException: {
                throw new UnsupportedOperationException("Unsupported attributes: " + attrsList);
            }
            default: {
                this.log.warn("Unknown policy ''{}'' for attributes={}", (Object)policy, (Object)attrsList);
            }
        }
    }

    protected GroupPrincipal toGroup(Path file, GroupPrincipal name) throws IOException {
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            return accessor.resolveGroupOwner(this, file, name);
        }
        catch (IOException e) {
            this.handleUserPrincipalLookupServiceException(GroupPrincipal.class, name.toString(), e);
            return null;
        }
    }

    protected UserPrincipal toUser(Path file, UserPrincipal name) throws IOException {
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            return accessor.resolveFileOwner(this, file, name);
        }
        catch (IOException e) {
            this.handleUserPrincipalLookupServiceException(UserPrincipal.class, name.toString(), e);
            return null;
        }
    }

    protected void handleUserPrincipalLookupServiceException(Class<? extends Principal> principalType, String name, IOException e) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("handleUserPrincipalLookupServiceException({})[{}] details", new Object[]{principalType.getSimpleName(), name, e});
        }
        UnsupportedAttributePolicy policy = this.getUnsupportedAttributePolicy();
        switch (policy) {
            case Ignore: {
                break;
            }
            case Warn: {
                this.log.warn("handleUserPrincipalLookupServiceException({})[{}] failed: {}", new Object[]{principalType.getSimpleName(), name, e.toString()});
                break;
            }
            case ThrowException: {
                throw e;
            }
            default: {
                this.log.warn("Unknown policy ''{}'' for principal={} [{}]", new Object[]{policy, principalType.getSimpleName(), name});
            }
        }
    }

    protected Map<String, Object> readAttrs(Buffer buffer) throws IOException {
        return SftpHelper.readAttrs(buffer, this.getVersion());
    }

    protected <H extends Handle> H validateHandle(String handle, Handle h, Class<H> type) throws IOException {
        if (h == null) {
            throw new NoSuchFileException(handle, handle, "No such current handle");
        }
        Class<?> t = h.getClass();
        if (!type.isAssignableFrom(t)) {
            throw new InvalidHandleException(handle, h, type);
        }
        return (H)((Handle)type.cast(h));
    }

    protected void sendStatus(Buffer buffer, int id, Throwable e, int cmd, Object ... args) throws IOException {
        SftpErrorStatusDataHandler handler = this.getErrorStatusDataHandler();
        int subStatus = handler.resolveSubStatus(this, id, e, cmd, args);
        String message = handler.resolveErrorMessage(this, id, e, subStatus, cmd, args);
        String lang = handler.resolveErrorLanguage(this, id, e, subStatus, cmd, args);
        this.sendStatus(buffer, id, subStatus, message, lang);
    }

    protected void sendStatus(Buffer buffer, int id, int substatus, String msg) throws IOException {
        this.sendStatus(buffer, id, substatus, msg != null ? msg : "", "");
    }

    protected void sendStatus(Buffer buffer, int id, int substatus, String msg, String lang) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doSendStatus({})[id={}] SSH_FXP_STATUS (substatus={}, lang={}, msg={})", new Object[]{this.getServerSession(), id, SftpConstants.getStatusName(substatus), lang, msg});
        }
        buffer.putByte((byte)101);
        buffer.putInt((long)id);
        buffer.putInt((long)substatus);
        buffer.putString(msg);
        buffer.putString(lang);
        this.send(buffer);
    }

    protected abstract Buffer prepareReply(Buffer var1);

    protected abstract void send(Buffer var1) throws IOException;

    protected Path resolveNormalizedLocation(String remotePath) throws IOException, InvalidPathException {
        Path resolvedPath = this.resolveFile(remotePath);
        return this.normalize(resolvedPath);
    }

    protected Path normalize(Path f) {
        if (f == null) {
            return null;
        }
        Path abs = f.isAbsolute() ? f : f.toAbsolutePath();
        return abs.normalize();
    }

    protected Path resolveFile(String remotePath) throws IOException, InvalidPathException {
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        Path localPath = accessor.resolveLocalFilePath(this, this.getDefaultDirectory(), remotePath);
        if (this.log.isTraceEnabled()) {
            this.log.trace("resolveFile({}) {} => {}", new Object[]{this.getServerSession(), remotePath, localPath});
        }
        return localPath;
    }
}

