/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.delivery;

import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityUtils;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.DeliveryFailureStrategy;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.stanza.Stanza;

public class StanzaRelayBroker
implements StanzaRelay {
    protected StanzaRelay internalRelay;
    protected StanzaRelay externalRelay;
    protected ServerRuntimeContext serverRuntimeContext;

    public void setInternalRelay(StanzaRelay internalRelay) {
        this.internalRelay = internalRelay;
    }

    public void setExternalRelay(StanzaRelay externalRelay) {
        this.externalRelay = externalRelay;
    }

    public void setServerRuntimeContext(ServerRuntimeContext serverRuntimeContext) {
        this.serverRuntimeContext = serverRuntimeContext;
    }

    public void relay(Entity receiver, Stanza stanza, DeliveryFailureStrategy deliveryFailureStrategy) throws DeliveryException {
        boolean toServerTLD = receiver == null || !receiver.isNodeSet() && EntityUtils.isAddressingServer(receiver, this.serverRuntimeContext.getServerEnitity());
        boolean toComponent = EntityUtils.isAddressingServerComponent(receiver, this.serverRuntimeContext.getServerEnitity());
        if (toServerTLD) {
            throw new RuntimeException("server as the direct receiver of stanza not yet implemented");
        }
        boolean relayToExternal = this.serverRuntimeContext.getServerFeatures().isRelayingToFederationServers();
        if (EntityUtils.isAddressingServer(receiver, this.serverRuntimeContext.getServerEnitity()) || toComponent) {
            this.internalRelay.relay(receiver, stanza, deliveryFailureStrategy);
        } else {
            if (!relayToExternal) {
                throw new IllegalStateException("this server is not relaying to external currently");
            }
            this.externalRelay.relay(receiver, stanza, deliveryFailureStrategy);
        }
    }
}

