/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc;

import java.util.ArrayList;
import java.util.List;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityUtils;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.DeliveryFailureStrategy;
import org.apache.vysper.xmpp.delivery.failure.IgnoreFailureStrategy;
import org.apache.vysper.xmpp.modules.DefaultDiscoAwareModule;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.handler.MUCIqAdminHandler;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.handler.MUCMessageHandler;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.handler.MUCPresenceHandler;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Conference;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Occupant;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Room;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.storage.OccupantStorageProvider;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.storage.RoomStorageProvider;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ComponentInfoRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoElement;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequest;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Item;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ItemRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ServiceDiscoveryRequestException;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.protocol.StanzaProcessor;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.components.Component;
import org.apache.vysper.xmpp.server.components.ComponentStanzaProcessor;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUCModule
extends DefaultDiscoAwareModule
implements Component,
ComponentInfoRequestListener,
ItemRequestListener {
    private String subdomain = "chat";
    private Conference conference;
    private Entity fullDomain;
    private final Logger logger = LoggerFactory.getLogger(MUCModule.class);
    private ServerRuntimeContext serverRuntimeContext;
    private ComponentStanzaProcessor stanzaProcessor;

    public MUCModule(String subdomain) {
        this(subdomain, new Conference("Conference"));
    }

    public MUCModule() {
        this.conference = new Conference("Conference");
    }

    public MUCModule(String subdomain, Conference conference) {
        this.subdomain = subdomain;
        this.conference = conference;
    }

    public void initialize(ServerRuntimeContext serverRuntimeContext) {
        super.initialize(serverRuntimeContext);
        this.serverRuntimeContext = serverRuntimeContext;
        this.fullDomain = EntityUtils.createComponentDomain((String)this.subdomain, (ServerRuntimeContext)serverRuntimeContext);
        ComponentStanzaProcessor processor = new ComponentStanzaProcessor(serverRuntimeContext);
        processor.addHandler((StanzaHandler)new MUCPresenceHandler(this.conference));
        processor.addHandler((StanzaHandler)new MUCMessageHandler(this.conference, this.fullDomain));
        processor.addHandler((StanzaHandler)new MUCIqAdminHandler(this.conference));
        this.stanzaProcessor = processor;
        RoomStorageProvider roomStorageProvider = (RoomStorageProvider)serverRuntimeContext.getStorageProvider(RoomStorageProvider.class);
        OccupantStorageProvider occupantStorageProvider = (OccupantStorageProvider)serverRuntimeContext.getStorageProvider(OccupantStorageProvider.class);
        if (roomStorageProvider == null) {
            this.logger.warn("No room storage provider found, using the default (in memory)");
        } else {
            this.conference.setRoomStorageProvider(roomStorageProvider);
        }
        if (occupantStorageProvider == null) {
            this.logger.warn("No occupant storage provider found, using the default (in memory)");
        } else {
            this.conference.setOccupantStorageProvider(occupantStorageProvider);
        }
        this.conference.initialize();
    }

    public String getName() {
        return "XEP-0045 Multi-user chat";
    }

    public String getVersion() {
        return "1.24";
    }

    protected void addItemRequestListeners(List<ItemRequestListener> itemRequestListeners) {
        itemRequestListeners.add(this);
    }

    public List<InfoElement> getComponentInfosFor(InfoRequest request) throws ServiceDiscoveryRequestException {
        if (!this.fullDomain.getDomain().equals(request.getTo().getDomain())) {
            return null;
        }
        if (request.getTo().getNode() == null) {
            List<InfoElement> serverInfos = this.conference.getServerInfosFor(request);
            return serverInfos;
        }
        Room room = this.conference.findRoom(request.getTo().getBareJID());
        if (room == null) {
            return null;
        }
        if (request.getTo().getResource() != null) {
            Occupant occupant = room.findOccupantByNick(request.getTo().getResource());
            if (occupant != null) {
                this.relayDiscoStanza(occupant.getJid(), request, "http://jabber.org/protocol/disco#info");
            }
            return null;
        }
        return room.getInfosFor(request);
    }

    protected void addComponentInfoRequestListeners(List<ComponentInfoRequestListener> componentInfoRequestListeners) {
        componentInfoRequestListeners.add(this);
    }

    public List<Item> getItemsFor(InfoRequest request) throws ServiceDiscoveryRequestException {
        Room room;
        Entity to = request.getTo();
        if (to.getNode() == null) {
            if (this.fullDomain.equals(to)) {
                List<Item> conferenceItems = this.conference.getItemsFor(request);
                return conferenceItems;
            }
            if (this.serverRuntimeContext.getServerEnitity().equals(to)) {
                ArrayList<Item> componentItem = new ArrayList<Item>();
                componentItem.add(new Item(this.fullDomain));
                return componentItem;
            }
            return null;
        }
        if (this.fullDomain.getDomain().equals(to.getDomain()) && (room = this.conference.findRoom(to.getBareJID())) != null) {
            if (to.getResource() != null) {
                Occupant occupant = room.findOccupantByNick(to.getResource());
                if (occupant != null) {
                    this.relayDiscoStanza(occupant.getJid(), request, "http://jabber.org/protocol/disco#items");
                }
            } else {
                return room.getItemsFor(request);
            }
        }
        return null;
    }

    private void relayDiscoStanza(Entity receiver, InfoRequest request, String ns) {
        StanzaBuilder builder = StanzaBuilder.createIQStanza((Entity)request.getFrom(), (Entity)receiver, (IQStanzaType)IQStanzaType.GET, (String)request.getID());
        builder.startInnerElement("query", ns);
        if (request.getNode() != null) {
            builder.addAttribute("node", request.getNode());
        }
        try {
            this.serverRuntimeContext.getStanzaRelay().relay(receiver, (Stanza)builder.build(), (DeliveryFailureStrategy)new IgnoreFailureStrategy());
        }
        catch (DeliveryException e) {
            // empty catch block
        }
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public StanzaProcessor getStanzaProcessor() {
        return this.stanzaProcessor;
    }
}

