/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.base.handler;

import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.delivery.failure.ReturnErrorToSenderFailureStrategy;
import org.apache.vysper.xmpp.modules.core.base.handler.XMPPCoreStanzaHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.MessageStanza;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

public class MessageHandler
extends XMPPCoreStanzaHandler {
    public String getName() {
        return "message";
    }

    protected boolean verifyType(Stanza stanza) {
        return MessageStanza.isOfType(stanza);
    }

    protected Stanza executeCore(XMPPCoreStanza stanza, ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext) {
        String threadId = null;
        XMLElement threadElement = null;
        try {
            threadElement = stanza.getSingleInnerElementsNamed("thread");
            if (threadElement != null && threadElement.getSingleInnerText() != null) {
                try {
                    threadId = threadElement.getSingleInnerText().getText();
                }
                catch (Exception _) {
                    threadId = null;
                }
            }
        }
        catch (XMLSemanticError _) {
            threadId = null;
        }
        String subject = null;
        XMLElement subjectElement = null;
        try {
            subjectElement = stanza.getSingleInnerElementsNamed("subject");
            if (subjectElement != null && subjectElement.getSingleInnerText() != null) {
                try {
                    subject = subjectElement.getSingleInnerText().getText();
                }
                catch (Exception _) {
                    subject = null;
                }
            }
        }
        catch (XMLSemanticError _) {
            subject = null;
        }
        if (isOutboundStanza) {
            if (!serverRuntimeContext.getServerFeatures().isRelayingMessages() || sessionContext != null && sessionContext.getAttribute("stanza.message.no_receive") != null) {
                return null;
            }
            Entity from = stanza.getFrom();
            if (from == null || !from.isResourceSet()) {
                String resource = serverRuntimeContext.getResourceRegistry().getUniqueResourceForSession(sessionContext);
                if (resource == null) {
                    throw new IllegalStateException("could not determine unique resource");
                }
                from = new EntityImpl(sessionContext.getInitiatingEntity(), resource);
                StanzaBuilder stanzaBuilder = new StanzaBuilder(stanza.getName(), stanza.getNamespaceURI());
                for (Attribute attribute : stanza.getAttributes()) {
                    if ("from".equals(attribute.getName())) continue;
                    stanzaBuilder.addAttribute(attribute);
                }
                stanzaBuilder.addAttribute("from", from.getFullQualifiedName());
                for (XMLElement preparedElement : stanza.getInnerElements()) {
                    stanzaBuilder.addPreparedElement(preparedElement);
                }
                stanza = XMPPCoreStanza.getWrapper((Stanza)stanzaBuilder.build());
            }
            StanzaRelay stanzaRelay = serverRuntimeContext.getStanzaRelay();
            try {
                stanzaRelay.relay(stanza.getTo(), stanza, new ReturnErrorToSenderFailureStrategy(stanzaRelay));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (sessionContext != null) {
            sessionContext.getResponseWriter().write(stanza);
        } else {
            throw new IllegalStateException("handling offline messages not implemented");
        }
        return null;
    }
}

