/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.server.response;

import java.util.List;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLElementBuilder;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.authorization.SASLMechanism;
import org.apache.vysper.xmpp.modules.extension.xep0077_inbandreg.InBandRegistrationModule;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.server.XMPPVersion;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerResponses {
    public Stanza getStreamOpenerForError(boolean forClient, Entity from, XMPPVersion version, Stanza errorStanza) {
        return (Stanza)this.getStreamOpener(forClient, from, null, version, errorStanza).build();
    }

    public Stanza getStreamOpenerForClient(Entity from, XMPPVersion version, SessionContext sessionContext) {
        Stanza innerFeatureStanza;
        if (sessionContext.getState() == SessionState.INITIATED) {
            innerFeatureStanza = this.getFeaturesForEncryption(sessionContext);
        } else if (sessionContext.getState() == SessionState.ENCRYPTED) {
            innerFeatureStanza = this.getFeaturesForAuthentication(sessionContext.getServerRuntimeContext().getServerFeatures().getAuthenticationMethods());
        } else if (sessionContext.getState() == SessionState.AUTHENTICATED) {
            sessionContext.setIsReopeningXMLStream();
            innerFeatureStanza = this.getFeaturesForSession();
        } else {
            throw new IllegalStateException("unsupported state for responding with stream opener");
        }
        StanzaBuilder stanzaBuilder = this.getStreamOpener(true, from, sessionContext.getXMLLang(), version, sessionContext.getSessionId(), innerFeatureStanza);
        return (Stanza)stanzaBuilder.build();
    }

    public Stanza getStreamOpenerForServerAcceptor(Entity from, XMPPVersion version, SessionContext sessionContext, boolean tlsConfigured) {
        XMLElement features = null;
        if (XMPPVersion.VERSION_1_0.equals(version)) {
            XMLElementBuilder featureBuilder = new XMLElementBuilder("features", "http://etherx.jabber.org/streams");
            if (sessionContext.getState() == SessionState.INITIATED) {
                if (tlsConfigured) {
                    ((XMLElementBuilder)featureBuilder.startInnerElement("starttls", "urn:ietf:params:xml:ns:xmpp-tls")).endInnerElement();
                }
                ((XMLElementBuilder)featureBuilder.startInnerElement("dialback", "urn:xmpp:features:dialback")).endInnerElement();
            } else if (sessionContext.getState() == SessionState.ENCRYPTED) {
                ((XMLElementBuilder)featureBuilder.startInnerElement("dialback", "urn:xmpp:features:dialback")).endInnerElement();
            } else {
                throw new IllegalStateException("unsupported state for responding with stream opener");
            }
            features = featureBuilder.build();
        }
        StanzaBuilder stanzaBuilder = this.getStreamOpener(false, from, sessionContext.getXMLLang(), version, sessionContext.getSessionId(), features);
        stanzaBuilder.declareNamespace("db", "jabber:server:dialback");
        return (Stanza)stanzaBuilder.build();
    }

    public Stanza getStreamOpenerForServerConnector(Entity from, Entity to, XMPPVersion version, SessionContext sessionContext) {
        StanzaBuilder stanzaBuilder = this.getStreamOpener(false, from, sessionContext.getXMLLang(), version, null, null);
        stanzaBuilder.addAttribute("to", to.getDomain());
        stanzaBuilder.declareNamespace("db", "jabber:server:dialback");
        return (Stanza)stanzaBuilder.build();
    }

    public StanzaBuilder getStreamOpener(boolean forClient, Entity from, String xmlLang, XMPPVersion version, Stanza innerStanza) {
        return this.getStreamOpener(forClient, from, xmlLang, version, null, innerStanza);
    }

    public StanzaBuilder getStreamOpener(boolean forClient, Entity from, String xmlLang, XMPPVersion version, String sessionId, XMLElement innerStanza) {
        StanzaBuilder stanzaBuilder = (StanzaBuilder)((StanzaBuilder)new StanzaBuilder("stream", "http://etherx.jabber.org/streams", "stream").declareNamespace("", forClient ? "jabber:client" : "jabber:server")).addAttribute("from", from.getFullQualifiedName());
        if (xmlLang != null) {
            stanzaBuilder.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", xmlLang);
        }
        if (version != null) {
            stanzaBuilder.addAttribute("version", version.toString());
        }
        if (sessionId != null) {
            stanzaBuilder.addAttribute("id", sessionId);
        }
        if (innerStanza != null) {
            stanzaBuilder.addPreparedElement(innerStanza);
        }
        return stanzaBuilder;
    }

    public Stanza getFeaturesForEncryption(SessionContext sessionContext) {
        StanzaBuilder stanzaBuilder = this.startFeatureStanza();
        stanzaBuilder.startInnerElement("starttls", "urn:ietf:params:xml:ns:xmpp-tls");
        if (sessionContext.getServerRuntimeContext().getServerFeatures().isStartTLSRequired()) {
            ((StanzaBuilder)stanzaBuilder.startInnerElement("required", "urn:ietf:params:xml:ns:xmpp-tls")).endInnerElement();
        }
        stanzaBuilder.endInnerElement();
        if (sessionContext.getServerRuntimeContext().getModule(InBandRegistrationModule.class) != null) {
            stanzaBuilder.startInnerElement("register", "http://jabber.org/features/iq-register");
        }
        return (Stanza)stanzaBuilder.build();
    }

    public Stanza getFeaturesForAuthentication(List<SASLMechanism> authenticationMethods) {
        StanzaBuilder stanzaBuilder = this.startFeatureStanza();
        stanzaBuilder.startInnerElement("mechanisms", "urn:ietf:params:xml:ns:xmpp-sasl");
        for (SASLMechanism authenticationMethod : authenticationMethods) {
            ((StanzaBuilder)((StanzaBuilder)stanzaBuilder.startInnerElement("mechanism", "urn:ietf:params:xml:ns:xmpp-sasl")).addText(authenticationMethod.getName())).endInnerElement();
        }
        stanzaBuilder.endInnerElement();
        return (Stanza)stanzaBuilder.build();
    }

    public Stanza getFeaturesForSession() {
        StanzaBuilder stanzaBuilder = this.startFeatureStanza();
        ((StanzaBuilder)((StanzaBuilder)stanzaBuilder.startInnerElement("bind", "urn:ietf:params:xml:ns:xmpp-bind")).startInnerElement("required", "urn:ietf:params:xml:ns:xmpp-bind")).endInnerElement();
        stanzaBuilder.endInnerElement();
        ((StanzaBuilder)((StanzaBuilder)stanzaBuilder.startInnerElement("session", "urn:ietf:params:xml:ns:xmpp-session")).startInnerElement("required", "urn:ietf:params:xml:ns:xmpp-session")).endInnerElement();
        stanzaBuilder.endInnerElement();
        return (Stanza)stanzaBuilder.build();
    }

    protected StanzaBuilder startFeatureStanza() {
        StanzaBuilder stanzaBuilder = new StanzaBuilder("features", "http://etherx.jabber.org/streams", "stream");
        return stanzaBuilder;
    }

    public Stanza getTLSProceed() {
        StanzaBuilder stanzaBuilder = new StanzaBuilder("proceed", "urn:ietf:params:xml:ns:xmpp-tls");
        return (Stanza)stanzaBuilder.build();
    }

    public Stanza getAuthAborted() {
        StanzaBuilder stanzaBuilder = new StanzaBuilder("aborted", "urn:ietf:params:xml:ns:xmpp-tls");
        return (Stanza)stanzaBuilder.build();
    }
}

