/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package org.apache.vysper.charset;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

/**
 * utility class for charsets
 *
 * @author The Apache MINA Project (dev@mina.apache.org)
 */
public class CharsetUtil {

    /**
     * Charset decoder for UTF-8
     */
    public static final CharsetDecoder UTF8_DECODER = Charset.forName("UTF-8").newDecoder();

    /**
     * Charset encoder for UTF-8
     */
    public static final CharsetEncoder UTF8_ENCODER = Charset.forName("UTF-8").newEncoder();
}