/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package org.apache.vysper.xmpp.authorization;

import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.Stanza;

/**
 * describes a SASL mechanism. used to describe server-supported SASL mechanisms, as announced in a
 * features/mechanism stanza and activated in a auth-stanza
 *
 * @author The Apache MINA Project (dev@mina.apache.org)
 */
public interface SASLMechanism {

    /**
     * name of the mechanism, used to uniquely identify the mechanism in server/client communication
     */
    String getName();

    /**
     * called by the server to handle mechanism specific logic as client issues a auth-stanza.
     */
    Stanza started(SessionContext sessionContext, SessionStateHolder sessionStateHolder, Stanza authStanza);

}
