/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.json.jcr;

import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

@Deprecated
public class JsonItemWriter {
    private static DateFormat calendarFormat;
    private final Set<String> propertyNamesToIgnore;
    public static final String ECMA_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    public static final Locale DATE_FORMAT_LOCALE;

    public JsonItemWriter(Set<String> propertyNamesToIgnore) {
        this.propertyNamesToIgnore = propertyNamesToIgnore;
    }

    public void dump(NodeIterator it, Writer out) throws RepositoryException, JSONException {
        JSONWriter w = new JSONWriter(out);
        w.array();
        while (it.hasNext()) {
            this.dump(it.nextNode(), w, 1, 1);
        }
        w.endArray();
    }

    public void dump(Node node, Writer w, int maxRecursionLevels) throws RepositoryException, JSONException {
        this.dump(node, w, maxRecursionLevels, false);
    }

    @Deprecated
    public void dump(Node node, Writer w, int maxRecursionLevels, boolean tidy) throws RepositoryException, JSONException {
        JSONWriter jw = new JSONWriter(w);
        this.dump(node, jw, 0, maxRecursionLevels);
    }

    public void dump(Property p, Writer w) throws JSONException, ValueFormatException, RepositoryException {
        JSONWriter jw = new JSONWriter(w);
        jw.object();
        this.writeProperty(jw, p);
        jw.endObject();
    }

    protected void dump(Node node, JSONWriter w, int currentRecursionLevel, int maxRecursionLevels) throws RepositoryException, JSONException {
        w.object();
        PropertyIterator props = node.getProperties();
        while (props.hasNext()) {
            Property prop = props.nextProperty();
            if (this.propertyNamesToIgnore != null && this.propertyNamesToIgnore.contains(prop.getName())) continue;
            this.writeProperty(w, prop);
        }
        if (this.recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
            NodeIterator children = node.getNodes();
            while (children.hasNext()) {
                Node n = children.nextNode();
                this.dumpSingleNode(n, w, currentRecursionLevel, maxRecursionLevels);
            }
        }
        w.endObject();
    }

    protected void dumpSingleNode(Node n, JSONWriter w, int currentRecursionLevel, int maxRecursionLevels) throws RepositoryException, JSONException {
        if (this.recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
            w.key(n.getName());
            this.dump(n, w, currentRecursionLevel + 1, maxRecursionLevels);
        }
    }

    protected boolean recursionLevelActive(int currentRecursionLevel, int maxRecursionLevels) {
        return maxRecursionLevels < 0 || currentRecursionLevel < maxRecursionLevels;
    }

    protected void writeProperty(JSONWriter w, Property p) throws ValueFormatException, RepositoryException, JSONException {
        if (p.getType() == 2) {
            w.key(":" + p.getName());
            if (!p.isMultiple()) {
                w.value(p.getLength());
            } else {
                long[] sizes = p.getLengths();
                w.array();
                for (int i = 0; i < sizes.length; ++i) {
                    w.value(sizes[i]);
                }
                w.endArray();
            }
            return;
        }
        w.key(p.getName());
        if (!p.isMultiple()) {
            this.dumpValue(w, p.getValue());
        } else {
            w.array();
            for (Value v : p.getValues()) {
                this.dumpValue(w, v);
            }
            w.endArray();
        }
    }

    protected void dumpValue(JSONWriter w, Value v) throws ValueFormatException, IllegalStateException, RepositoryException, JSONException {
        switch (v.getType()) {
            case 2: {
                w.value(0L);
                break;
            }
            case 5: {
                w.value(JsonItemWriter.format(v.getDate()));
                break;
            }
            case 6: {
                w.value(v.getBoolean());
                break;
            }
            case 3: {
                w.value(v.getLong());
                break;
            }
            case 4: {
                w.value(v.getDouble());
                break;
            }
            default: {
                w.value(v.getString());
            }
        }
    }

    public static synchronized String format(Calendar date) {
        if (calendarFormat == null) {
            calendarFormat = new SimpleDateFormat(ECMA_DATE_FORMAT, DATE_FORMAT_LOCALE);
        }
        return calendarFormat.format(date.getTime());
    }

    static {
        DATE_FORMAT_LOCALE = Locale.US;
    }
}

