// Copyright (C) 1999-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of ccscript.
// 
// The exception is that, if you link the ccscript library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccscript library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name ccscript.  If you copy code from other releases into a copy of
// ccscript, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for ccscript, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include <cc++/url.h>
#include <cc++/export.h>
#include <cstdio>
#include <cstdlib>
#include "script.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

static class RandomModule : public ScriptModule
{
private:
	char *getSession(ScriptInterp *interp, Line *line,  Session **session);
	char *checkScript(Line *line, ScriptImage *img);
	time_t now;

public:
	RandomModule() : ScriptModule("random") 
	{
		srand((int)time(&now));
	};
}	rnd;


char *RandomModule::checkScript(Line *line, ScriptImage *img)
{
	const char *cp = strchr(line->cmd, '.');
	if(!cp)
		return "requires .seed, .digits";

	if(!stricmp(cp, ".seed"))
	{
		if(line->argc > 1)
			return "invalid number of arguments";
		else
			return NULL;
	}
	else if(isdigit(*(cp + 1)))
	{
		if(line->argc < 1)
			return "arguments required";
		return NULL;
	}
	return "unknown member";
}

char *RandomModule::getSession(ScriptInterp *interp, Line *line, Session **session)
{
	const char *cp = strchr(line->cmd, '.');
	unsigned range, count = 1, roll;
	int val, offset = 0, min = 1, max = 0, reroll = 0;
	Script::Symbol *sym;
	char buf[11];

	if(!cp)
		return "random-member-invalid";

	if(!stricmp(cp, ".seed"))
	{
		cp = interp->getValue();
		if(!cp)
		{
			snprintf(buf, 11, "%d", time(&now));
			cp = buf;
		}
		srand(atoi(cp));
		return NULL;		
	}
	range = atoi(++cp);
	if(!range)
		return "random-range-invalid";

	cp = interp->getKeyword("count");
	if(cp)
		count = atoi(cp);

	cp = interp->getKeyword("seed");
	if(cp)
		srand(atoi(cp));

	cp = interp->getKeyword("offset");
	if(cp)
		offset = atoi(cp);

	cp = interp->getKeyword("min");
	if(cp)
		min = atoi(cp);

	cp = interp->getKeyword("max");
	if(cp)
		max = atoi(cp);

	cp = interp->getKeyword("reroll");
	if(cp)
		reroll = atoi(cp);

	while(NULL != (sym = interp->getVariable(10)))
	{
		
		if(sym->flags.type != NORMAL)
			continue;
		if(sym->flags.readonly)
			continue;

retry:
		val = offset;
		roll = count;

		while(roll--)
			val += 1 + (int)(((double)(range)) * rand()/(RAND_MAX + 1.0));

		if(val < min)
			val = min;

		if(val <= reroll)
			goto retry;

		if(val > max && max)
			val = max;

		snprintf(sym->data, sym->flags.size + 1, "%d", val);
		if(sym->flags.initial)
			sym->flags.initial = false;
		if(sym->flags.commit)
			interp->commit(sym);			
	}
	return NULL;
}

#ifdef	CCXX_NAMESPACES
};
#endif



