/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.utils.concurrent;

import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.EmptyException;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.IStructure;
import java.util.concurrent.atomic.AtomicReference;

public class LockFreeQueue<T>
extends IStructure<T> {
    public LockFreeQueue() {
        IStructure.Node<Object> dummy = new IStructure.Node<Object>(null);
        this.tail = new AtomicReference<IStructure.Node<Object>>(dummy);
        this.head = new AtomicReference<IStructure.Node<Object>>(dummy);
    }

    @Override
    public void add(T item) {
        IStructure.Node<T> node = new IStructure.Node<T>(item);
        while (true) {
            IStructure.Node last2 = (IStructure.Node)this.tail.get();
            IStructure.Node next2 = last2.next.get();
            if (last2 != this.tail.get()) continue;
            if (next2 == null) {
                if (!last2.next.compareAndSet(next2, node)) continue;
                this.tail.compareAndSet(last2, node);
                this.size = new Integer(this.size + 1);
                return;
            }
            this.tail.compareAndSet(last2, next2);
        }
    }

    @Override
    public T get() throws EmptyException {
        Object value2;
        while (true) {
            IStructure.Node first = (IStructure.Node)this.head.get();
            IStructure.Node last2 = (IStructure.Node)this.tail.get();
            IStructure.Node next2 = first.next.get();
            if (first != this.head.get()) continue;
            if (first == last2) {
                if (next2 == null) {
                    throw new EmptyException();
                }
                this.tail.compareAndSet(last2, next2);
                continue;
            }
            value2 = next2.value;
            if (this.head.compareAndSet(first, next2)) break;
        }
        this.size = new Integer(this.size - 1);
        return value2;
    }

    @Override
    public boolean isEmpty() {
        IStructure.Node first = (IStructure.Node)this.head.get();
        IStructure.Node last2 = (IStructure.Node)this.tail.get();
        IStructure.Node next2 = first.next.get();
        return first == this.head.get() && first == last2 && next2 == null;
    }
}

