/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalAStar3.BenchmarkRouter;
import com.sun.electric.tool.routing.experimentalAStar3.MyRouteJob;
import com.sun.electric.tool.routing.experimentalAStar3.PathConversionData;
import com.sun.electric.tool.routing.experimentalAStar3.SegmentComparator;
import com.sun.electric.tool.routing.experimentalAStar3.concurrency.RouteJob;
import com.sun.electric.tool.routing.experimentalAStar3.concurrency.RoutingMain;
import com.sun.electric.tool.routing.experimentalAStar3.datastructures.Point3D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AStarRouter
extends BenchmarkRouter {
    public RoutingFrame.RoutingParameter numRegionsPerSide = new RoutingFrame.RoutingParameter((RoutingFrame)this, "regionsps", "Number of regions per side:", 8);
    RoutingMain router;
    private double nodeSize;
    private int nodeOffsetX = 0;
    private int nodeOffsetY = 0;
    private List<RoutingFrame.RoutingLayer> allLayers;
    private List<RoutingFrame.RoutingContact> allContacts;

    public AStarRouter() {
        this.setBenchmarkParameters(16, 60, 2);
    }

    public void setBenchmarkParameters(int threads, int runtime, int numregionsperside) {
        this.numThreads.setTempIntValue(threads);
        this.maxRuntime.setTempIntValue(runtime);
        this.numRegionsPerSide.setTempIntValue(numregionsperside);
    }

    @Override
    public String getAlgorithmName() {
        return "A* - 3";
    }

    private int nextPowerOf2(int value2) {
        int x2;
        assert (value2 > 0);
        for (x2 = 1; value2 > x2; x2 *= 2) {
        }
        return x2;
    }

    private double calculateNodeSize(List<RoutingFrame.RoutingLayer> allLayers) {
        double maxMinWidth = 0.0;
        for (RoutingFrame.RoutingLayer layer : allLayers) {
            if (!(maxMinWidth < layer.getMinWidth() / 2.0 + layer.getMinSpacing(layer))) continue;
            maxMinWidth = layer.getMinSpacing(layer) + layer.getMinWidth() / 2.0;
        }
        return maxMinWidth * 2.0;
    }

    private int cellUnitToNode(double c) {
        return (int)Math.floor(c / this.getNodeSize());
    }

    private int cellCoordXToNode(double c) {
        return this.cellUnitToNode(c) + this.nodeOffsetX;
    }

    private int cellCoordYToNode(double c) {
        return this.cellUnitToNode(c) + this.nodeOffsetY;
    }

    public double nodeCoordXToCellCentered(int n) {
        return this.getNodeSize() * (double)(n - this.nodeOffsetX) + this.getNodeSize() / 2.0;
    }

    public double nodeCoordYToCellCentered(int n) {
        return this.getNodeSize() * (double)(n - this.nodeOffsetY) + this.getNodeSize() / 2.0;
    }

    public double nodeCoordXToCell(int n) {
        return this.getNodeSize() * (double)(n - this.nodeOffsetX);
    }

    public double nodeCoordYToCell(int n) {
        return this.getNodeSize() * (double)(n - this.nodeOffsetY);
    }

    private RoutingFrame.RoutingLayer getLayerFromZ(int z) {
        return this.allLayers.get(z);
    }

    private int getZFromLayer(RoutingFrame.RoutingLayer layer) {
        return layer.getMetalNumber() - 1;
    }

    @Override
    protected void runRouting(Cell cell, List<RoutingFrame.RoutingSegment> segmentsToRoute, List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts, List<RoutingFrame.RoutingGeometry> blockages) {
        long startTime = System.currentTimeMillis();
        this.allLayers = allLayers;
        this.allContacts = allContacts;
        Job.getUserInterface().startProgressDialog("Routing " + segmentsToRoute.size() + " segments", null);
        Job.getUserInterface().setProgressNote("Initialising...");
        Job.getUserInterface().setProgressValue(0);
        this.setNodeSize(this.calculateNodeSize(allLayers));
        int min_x = this.cellUnitToNode(cell.getBounds().getMinX());
        int min_y = this.cellUnitToNode(cell.getBounds().getMinY());
        int max_x = this.cellUnitToNode(cell.getBounds().getMaxX());
        int max_y = this.cellUnitToNode(cell.getBounds().getMaxY());
        int border = 10;
        int real_width = max_x - min_x + 1;
        int real_height = max_y - min_y + 1;
        int width = real_width + 20;
        int height = real_height + 20;
        int quadlen = this.nextPowerOf2(width > height ? width : height);
        if (quadlen < 128) {
            quadlen = 128;
        }
        this.nodeOffsetX = -min_x + (quadlen - real_width) / 2;
        this.nodeOffsetY = -min_y + (quadlen - real_height) / 2;
        this.router = new RoutingMain(quadlen, quadlen, this.getMetalLayerCount(allLayers), this.numRegionsPerSide.getTempIntValue(), this.numThreads.getTempIntValue());
        for (RoutingFrame.RoutingGeometry routingGeometry : blockages) {
            Rectangle2D bounds = routingGeometry.getBounds();
            int startX = this.cellCoordXToNode(bounds.getX());
            int startY = this.cellCoordYToNode(bounds.getY());
            int endX = this.cellCoordXToNode(Math.ceil(bounds.getX() + bounds.getWidth()));
            int endY = this.cellCoordYToNode(Math.ceil(bounds.getY() + bounds.getHeight()));
            this.router.setBlockage(startX, startY, endX, endY, this.getZFromLayer(routingGeometry.getLayer()));
        }
        this.router.placePortals();
        Collections.sort(segmentsToRoute, new SegmentComparator());
        Job.getUserInterface().setProgressNote("Scheduling segments to route...");
        for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            RoutingFrame.RoutePoint rpSTART = new RoutingFrame.RoutePoint(RoutingFrame.RoutingContact.STARTPOINT, rs.getStartEnd().getLocation(), 0);
            RoutingFrame.RoutePoint rpEND = new RoutingFrame.RoutePoint(RoutingFrame.RoutingContact.FINISHPOINT, rs.getFinishEnd().getLocation(), 0);
            Point3D ptSTART = new Point3D(this.cellCoordXToNode(rpSTART.getLocation().getX()), this.cellCoordYToNode(rpSTART.getLocation().getY()), this.getZFromLayer(rs.getStartLayers().get(0)));
            Point3D ptEND = new Point3D(this.cellCoordXToNode(rpEND.getLocation().getX()), this.cellCoordYToNode(rpEND.getLocation().getY()), this.getZFromLayer(rs.getFinishLayers().get(0)));
            MyRouteJob job = new MyRouteJob(ptSTART, ptEND, this);
            job.routingSegment = rs;
            this.router.submitRouteJob(job);
        }
        Job.getUserInterface().setProgressNote("Routing segments...");
        long restTime = (long)(this.maxRuntime.getIntValue() * 1000) - (System.currentTimeMillis() - startTime);
        this.router.setMaxRuntimeMillis(restTime);
        this.router.waitForCompletion();
        Job.getUserInterface().stopProgressDialog();
    }

    private int getMetalLayerCount(List<RoutingFrame.RoutingLayer> allLayers) {
        int highestMetalNumber = 0;
        for (RoutingFrame.RoutingLayer routingLayer : allLayers) {
            if (!routingLayer.isMetal()) continue;
            highestMetalNumber = Math.max(highestMetalNumber, routingLayer.getMetalNumber());
        }
        return highestMetalNumber;
    }

    synchronized void routeJobCompleted(RouteJob job) {
        Job.getUserInterface().setProgressValue(this.router.getProgress());
        List<Point3D> path = job.getPath();
        if (path != null) {
            RoutingFrame.RoutingSegment segment = job.routingSegment;
            path = this.optimizePath(path);
            PathConversionData data2 = new PathConversionData();
            List<RoutingFrame.RoutePoint> routePoints = this.convertPathToRoutePoints(path, segment, data2);
            if (path.size() == 1) {
                RoutingFrame.RoutingLayer layer = segment.getFinishLayers().get(0);
                segment.addWireEnd(routePoints.get(0));
                segment.addWireEnd(routePoints.get(1));
                segment.addWireEnd(routePoints.get(2));
                segment.addWire(new RoutingFrame.RouteWire(segment.getStartLayers().get(0), routePoints.get(0), routePoints.get(1), layer.getMinWidth()));
                segment.addWire(new RoutingFrame.RouteWire(layer, routePoints.get(1), routePoints.get(2), layer.getMinWidth()));
                return;
            }
            RoutingFrame.RoutingLayer layer = segment.getStartLayers().get(0);
            segment.addWireEnd(routePoints.get(0));
            segment.addWireEnd(routePoints.get(1));
            segment.addWire(new RoutingFrame.RouteWire(layer, routePoints.get(0), routePoints.get(1), layer.getMinWidth()));
            if (data2.startPointsAdded == 1) {
                segment.addWireEnd(routePoints.get(2));
                segment.addWire(new RoutingFrame.RouteWire(layer, routePoints.get(1), routePoints.get(2), layer.getMinWidth()));
            }
            for (int i = 0; i < path.size() - 1; ++i) {
                layer = path.get(i).getZ() != path.get(i + 1).getZ() ? this.getLayerFromZ(path.get(i + 1).getZ()) : this.getLayerFromZ(path.get(i).getZ());
                int currentRoutePointIndex = i + 2 + data2.startPointsAdded;
                segment.addWireEnd(routePoints.get(currentRoutePointIndex));
                segment.addWire(new RoutingFrame.RouteWire(layer, routePoints.get(currentRoutePointIndex - 1), routePoints.get(currentRoutePointIndex), layer.getMinWidth()));
            }
            if (data2.endPointsAdded == 1) {
                segment.addWireEnd(routePoints.get(routePoints.size() - 2));
                segment.addWire(new RoutingFrame.RouteWire(layer, routePoints.get(routePoints.size() - 3), routePoints.get(routePoints.size() - 2), layer.getMinWidth()));
            }
            layer = segment.getFinishLayers().get(0);
            segment.addWireEnd(routePoints.get(routePoints.size() - 1));
            segment.addWire(new RoutingFrame.RouteWire(layer, routePoints.get(routePoints.size() - 2), routePoints.get(routePoints.size() - 1), layer.getMinWidth()));
        }
    }

    public RoutingFrame.RoutingContact getVia(RoutingFrame.RoutingLayer l1, RoutingFrame.RoutingLayer l2) {
        for (RoutingFrame.RoutingContact rc : this.allContacts) {
            if ((rc.getFirstLayer() != l1 || rc.getSecondLayer() != l2) && (rc.getFirstLayer() != l2 || rc.getSecondLayer() != l1)) continue;
            return rc;
        }
        throw new IllegalArgumentException("Between the layers " + l1.getName() + " and " + l2.getName() + ", no via contact could be found.");
    }

    private List<Point3D> optimizePath(List<Point3D> path) {
        if (path.size() < 3) {
            return path;
        }
        ArrayList<Point3D> result2 = new ArrayList<Point3D>();
        Point3D last2 = null;
        Point3D previousToLast = null;
        result2.add(path.get(0));
        int i = 0;
        for (Point3D cur : path) {
            if (last2 != null) {
                if (last2.getZ() != cur.getZ() && i > 1) {
                    result2.add(last2);
                }
                if (previousToLast != null && previousToLast.getX() != cur.getX() && previousToLast.getY() != cur.getY()) {
                    result2.add(last2);
                }
            }
            previousToLast = last2;
            last2 = cur;
            ++i;
        }
        if (path.get(path.size() - 2).getZ() == path.get(path.size() - 1).getZ()) {
            result2.add(path.get(path.size() - 1));
        }
        return result2;
    }

    private List<RoutingFrame.RoutePoint> convertPathToRoutePoints(List<Point3D> path, RoutingFrame.RoutingSegment segment, PathConversionData data2) {
        ArrayList<RoutingFrame.RoutePoint> result2 = new ArrayList<RoutingFrame.RoutePoint>();
        RoutingFrame.RoutePoint startPoint = new RoutingFrame.RoutePoint(RoutingFrame.RoutingContact.STARTPOINT, segment.getStartEnd().getLocation(), 0);
        result2.add(startPoint);
        RoutingFrame.RoutePoint endPoint = new RoutingFrame.RoutePoint(RoutingFrame.RoutingContact.FINISHPOINT, segment.getFinishEnd().getLocation(), 0);
        RoutingFrame.RoutePoint smoothedEndPoint = null;
        Point3D first = null;
        Point3D second = null;
        if (path.size() > 1) {
            first = path.get(0);
            second = path.get(1);
            if (first.getX() != second.getX()) {
                result2.add(new RoutingFrame.RoutePoint(segment.getStartLayers().get(0).getPin(), new Point2D.Double(startPoint.getLocation().getX(), this.nodeCoordYToCellCentered(first.getY())), 0));
                data2.startPointsAdded = 1;
            } else {
                result2.add(new RoutingFrame.RoutePoint(segment.getStartLayers().get(0).getPin(), new Point2D.Double(this.nodeCoordXToCellCentered(first.getX()), startPoint.getLocation().getY()), 0));
                data2.startPointsAdded = 1;
            }
            Point3D last2 = null;
            for (Point3D cur : path) {
                RoutingFrame.RoutingContact pin = null;
                if (last2 != null) {
                    pin = last2.getZ() != cur.getZ() ? this.getVia(this.getLayerFromZ(last2.getZ()), this.getLayerFromZ(cur.getZ())) : this.getLayerFromZ(last2.getZ()).getPin();
                    result2.add(new RoutingFrame.RoutePoint(pin, new Point2D.Double(this.nodeCoordXToCellCentered(last2.getX()), this.nodeCoordYToCellCentered(last2.getY())), 0));
                    if (cur == path.get(path.size() - 1) && this.getLayerFromZ(cur.getZ()) != segment.getFinishLayers().get(0)) {
                        pin = this.getVia(this.getLayerFromZ(cur.getZ()), segment.getFinishLayers().get(0));
                        result2.add(new RoutingFrame.RoutePoint(pin, new Point2D.Double(this.nodeCoordXToCellCentered(cur.getX()), this.nodeCoordYToCellCentered(cur.getY())), 0));
                    }
                }
                last2 = cur;
            }
            first = path.get(path.size() - 2);
            second = path.get(path.size() - 1);
            if (first.getX() != second.getX()) {
                smoothedEndPoint = new RoutingFrame.RoutePoint(segment.getFinishLayers().get(0).getPin(), new Point2D.Double(endPoint.getLocation().getX(), this.nodeCoordYToCellCentered(first.getY())), 0);
                data2.endPointsAdded = 1;
            } else {
                smoothedEndPoint = new RoutingFrame.RoutePoint(segment.getFinishLayers().get(0).getPin(), new Point2D.Double(this.nodeCoordXToCellCentered(first.getX()), endPoint.getLocation().getY()), 0);
                data2.endPointsAdded = 1;
            }
        } else {
            smoothedEndPoint = new RoutingFrame.RoutePoint(segment.getFinishLayers().get(0).getPin(), new Point2D.Double(endPoint.getLocation().getX(), startPoint.getLocation().getY()), 0);
            data2.endPointsAdded = 1;
        }
        if (smoothedEndPoint != null) {
            result2.add(smoothedEndPoint);
        }
        result2.add(endPoint);
        return result2;
    }

    public void setNodeSize(double nodeSize) {
        this.nodeSize = nodeSize;
    }

    public double getNodeSize() {
        return this.nodeSize;
    }
}

