/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import scala.CountedIterator;
import scala.CountedIterator$class;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.BufferedIterator$class;
import scala.collection.GenTraversableOnce;
import scala.collection.GenTraversableOnce$class;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce$class;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$Empty$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public abstract class Iterator$class {
    public static Iterator seq(Iterator $this) {
        return $this;
    }

    public static boolean isEmpty(Iterator $this) {
        return !$this.hasNext();
    }

    public static boolean isTraversableAgain(Iterator $this) {
        return false;
    }

    public static boolean hasDefiniteSize(Iterator $this) {
        return $this.isEmpty();
    }

    public static Iterator take(Iterator $this, int n) {
        return $this.slice(0, n);
    }

    public static Iterator drop(Iterator $this, int n) {
        return $this.slice(n, Integer.MAX_VALUE);
    }

    public static Iterator slice(Iterator $this, int from2, int until$1) {
        int lo$1;
        for (int toDrop = lo$1 = Predef$.MODULE$.intWrapper(from2).max(0); toDrop > 0 && $this.hasNext(); --toDrop) {
            $this.next();
        }
        return new Iterator<A>($this, until$1, lo$1){
            private int remaining;
            private final Iterator $outer;

            private int remaining() {
                return this.remaining;
            }

            private void remaining_$eq(int n) {
                this.remaining = n;
            }

            public boolean hasNext() {
                return this.remaining() > 0 && this.$outer.hasNext();
            }

            public A next() {
                A a;
                if (this.remaining() > 0) {
                    this.remaining_$eq(this.remaining() - 1);
                    a = this.$outer.next();
                } else {
                    a = Iterator$.MODULE$.empty().next();
                }
                return a;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.remaining = n - n2;
            }
        };
    }

    public static Iterator map(Iterator $this, Function1 f$2) {
        return new Iterator<B>($this, f$2){
            private final Iterator $outer;
            private final Function1 f$2;

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            public B next() {
                return (B)this.f$2.apply(this.$outer.next());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.f$2 = iterator2;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
            }
        };
    }

    public static Iterator $plus$plus(Iterator $this, Function0 that$1) {
        return new Iterator<B>($this, that$1){
            private Iterator<B> cur;
            private Iterator<B> it;
            private final Iterator $outer;
            private final Function0 that$1;
            private volatile int bitmap$priv$0;

            private Iterator<B> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<B> iterator2) {
                this.cur = iterator2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private Iterator<B> it() {
                if ((this.bitmap$priv$0 & 1) != 0) return this.it;
                Iterator$.anon.20 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$priv$0 & 1) == 0) {
                        this.it = ((GenTraversableOnce)this.that$1.apply()).toIterator();
                        this.bitmap$priv$0 |= 1;
                    }
                    // ** MonitorExit[this] (shouldn't be in output)
                    this.that$1 = null;
                    return this.it;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.cur().hasNext()) return true;
                if (this.cur() != this.$outer) return false;
                if (!this.it().hasNext()) return false;
                this.cur_$eq(this.it());
                if (!true) return false;
                return true;
            }

            public B next() {
                this.hasNext();
                return this.cur().next();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.that$1 = iterator2;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.cur = $outer;
            }
        };
    }

    public static Iterator flatMap(Iterator $this, Function1 f$3) {
        return new Iterator<B>($this, f$3){
            private Iterator<B> cur;
            private final Iterator $outer;
            private final Function1 f$3;

            private Iterator<B> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<B> iterator2) {
                this.cur = iterator2;
            }

            public boolean hasNext() {
                boolean bl;
                block2: {
                    while (true) {
                        if (this.cur().hasNext()) {
                            bl = true;
                            break block2;
                        }
                        if (!this.$outer.hasNext()) break;
                        this.cur_$eq(((GenTraversableOnce)this.f$3.apply(this.$outer.next())).toIterator());
                    }
                    bl = false;
                }
                return bl;
            }

            public B next() {
                return (B)(this.hasNext() ? this.cur() : Iterator$.MODULE$.empty()).next();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.f$3 = iterator2;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.cur = Iterator$.MODULE$.empty();
            }
        };
    }

    public static Iterator filter(Iterator $this, Function1 p$1) {
        return new Iterator<A>($this, p$1){
            private A hd;
            private boolean hdDefined;
            private final Iterator $outer;
            private final Function1 p$1;

            private A hd() {
                return this.hd;
            }

            private void hd_$eq(A a) {
                this.hd = a;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean bl) {
                this.hdDefined = bl;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.hdDefined()) return true;
                do {
                    if (!this.$outer.hasNext()) return false;
                    this.hd_$eq(this.$outer.next());
                } while (!BoxesRunTime.unboxToBoolean(this.p$1.apply(this.hd())));
                this.hdDefined_$eq(true);
                if (!true) return false;
                return true;
            }

            public A next() {
                A a;
                if (this.hasNext()) {
                    this.hdDefined_$eq(false);
                    a = this.hd();
                } else {
                    a = Iterator$.MODULE$.empty().next();
                }
                return a;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.p$1 = iterator2;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.hdDefined = false;
            }
        };
    }

    public static Iterator withFilter(Iterator $this, Function1 p) {
        return $this.filter(p);
    }

    public static Iterator filterNot(Iterator $this, Function1 p$4) {
        return $this.filter(new Serializable($this, p$4){
            public static final long serialVersionUID;
            public final Function1 p$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(A a) {
                return !BoxesRunTime.unboxToBoolean(this.p$4.apply(a));
            }
            {
                this.p$4 = iterator2;
            }
        });
    }

    public static Iterator collect(Iterator $this, PartialFunction pf$1) {
        BufferedIterator self$1 = $this.buffered();
        return new Iterator<B>($this, pf$1, self$1){
            private final PartialFunction pf$1;
            private final BufferedIterator self$1;

            private void skip() {
                while (this.self$1.hasNext() && !this.pf$1.isDefinedAt(this.self$1.head())) {
                    this.self$1.next();
                }
            }

            public boolean hasNext() {
                this.skip();
                return this.self$1.hasNext();
            }

            public B next() {
                this.skip();
                return (B)this.pf$1.apply(this.self$1.next());
            }
            {
                this.pf$1 = iterator2;
                this.self$1 = var3_3;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
            }
        };
    }

    public static Iterator scanLeft(Iterator $this, Object z$1, Function2 op$1) {
        return new Iterator<B>($this, z$1, op$1){
            private boolean hasNext;
            private B elem;
            private final Iterator $outer;
            private final Function2 op$1;

            public boolean hasNext() {
                return this.hasNext;
            }

            private void hasNext_$eq(boolean bl) {
                this.hasNext = bl;
            }

            private B elem() {
                return this.elem;
            }

            private void elem_$eq(B b) {
                this.elem = b;
            }

            /*
             * WARNING - void declaration
             */
            public B next() {
                A a;
                if (this.hasNext()) {
                    void var1_1;
                    B res = this.elem();
                    if (this.$outer.hasNext()) {
                        this.elem_$eq(this.op$1.apply(this.elem(), this.$outer.next()));
                    } else {
                        this.hasNext_$eq(false);
                    }
                    a = var1_1;
                } else {
                    a = Iterator$.MODULE$.empty().next();
                }
                return (B)a;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.op$1 = var3_3;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.hasNext = true;
                this.elem = iterator2;
            }
        };
    }

    public static Iterator scanRight(Iterator $this, Object z, Function2 op) {
        return ((IterableLike)$this.toBuffer().scanRight(z, op, Buffer$.MODULE$.canBuildFrom())).iterator();
    }

    public static Iterator takeWhile(Iterator $this, Function1 p$2) {
        return new Iterator<A>($this, p$2){
            private A hd;
            private boolean hdDefined;
            private Iterator<A> tail;
            private final Function1 p$2;

            private A hd() {
                return this.hd;
            }

            private void hd_$eq(A a) {
                this.hd = a;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean bl) {
                this.hdDefined = bl;
            }

            private Iterator<A> tail() {
                return this.tail;
            }

            private void tail_$eq(Iterator<A> iterator2) {
                this.tail = iterator2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.hdDefined()) return true;
                if (!this.tail().hasNext()) return false;
                this.hd_$eq(this.tail().next());
                if (BoxesRunTime.unboxToBoolean(this.p$2.apply(this.hd()))) {
                    this.hdDefined_$eq(true);
                } else {
                    this.tail_$eq(Iterator$.MODULE$.empty());
                }
                if (!this.hdDefined()) return false;
                return true;
            }

            public A next() {
                A a;
                if (this.hasNext()) {
                    this.hdDefined_$eq(false);
                    a = this.hd();
                } else {
                    a = Iterator$.MODULE$.empty().next();
                }
                return a;
            }
            {
                this.p$2 = iterator2;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.hdDefined = false;
                this.tail = $outer;
            }
        };
    }

    public static Tuple2 partition(Iterator $this, Function1 p$5) {
        BufferedIterator self$2 = $this.buffered();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Scala_collection_Iterator$PartitionIterator$1
        implements Iterator<A>,
        ScalaObject {
            private final Function1<A, Object> p;
            private Scala_collection_Iterator$PartitionIterator$1 other;
            private final Queue<A> lookahead;
            public final Iterator $outer;
            private final BufferedIterator self$2;

            public Scala_collection_Iterator$PartitionIterator$1 other() {
                return this.other;
            }

            public void other_$eq(Scala_collection_Iterator$PartitionIterator$1 var1_1) {
                this.other = var1_1;
            }

            public Queue<A> lookahead() {
                return this.lookahead;
            }

            public void skip() {
                while (this.self$2.hasNext() && !BoxesRunTime.unboxToBoolean(this.p.apply(this.self$2.head()))) {
                    this.other().lookahead().$plus$eq((Object)this.self$2.next());
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (!this.lookahead().isEmpty()) return true;
                this.skip();
                if (this.self$2.hasNext()) return true;
                return false;
            }

            public A next() {
                A a;
                if (this.lookahead().isEmpty()) {
                    this.skip();
                    a = this.self$2.next();
                } else {
                    a = this.lookahead().dequeue();
                }
                return a;
            }

            public Iterator scala$collection$Iterator$PartitionIterator$$$outer() {
                return this.$outer;
            }

            public Scala_collection_Iterator$PartitionIterator$1(Iterator<A> p, Function1<A, Object> function1) {
                this.p = p;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.self$2 = function1;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.lookahead = new Queue<A>();
            }
        }
        Scala_collection_Iterator$PartitionIterator$1 l = new Scala_collection_Iterator$PartitionIterator$1($this, p$5, self$2);
        Scala_collection_Iterator$PartitionIterator$1 r = new Scala_collection_Iterator$PartitionIterator$1($this, (Function1)new Serializable($this, p$5){
            public static final long serialVersionUID;
            public final Function1 p$5;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(A a) {
                return !BoxesRunTime.unboxToBoolean(this.p$5.apply(a));
            }
            {
                this.p$5 = iterator2;
            }
        }, self$2);
        l.other_$eq(r);
        r.other_$eq(l);
        return new Tuple2<Scala_collection_Iterator$PartitionIterator$1, Scala_collection_Iterator$PartitionIterator$1>(l, r);
    }

    public static Tuple2 span(Iterator $this, Function1 p$6) {
        BufferedIterator self$3 = $this.buffered();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Scala_collection_Iterator$Leading$1
        implements Iterator<A>,
        ScalaObject {
            private boolean isDone;
            private final Queue<A> lookahead;
            public final Iterator $outer;
            private final Function1 p$6;
            private final BufferedIterator self$3;

            private boolean isDone() {
                return this.isDone;
            }

            private void isDone_$eq(boolean bl) {
                this.isDone = bl;
            }

            public Queue<A> lookahead() {
                return this.lookahead;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean advance() {
                if (!this.self$3.hasNext()) return false;
                if (!BoxesRunTime.unboxToBoolean(this.p$6.apply(this.self$3.head()))) return false;
                this.lookahead().$plus$eq((Object)this.self$3.next());
                if (!true) return false;
                return true;
            }

            public void finish() {
                while (this.advance()) {
                }
                this.isDone_$eq(true);
            }

            public boolean hasNext() {
                return this.lookahead().nonEmpty() || this.advance();
            }

            public A next() {
                block0: {
                    if (!this.lookahead().isEmpty()) break block0;
                    this.advance();
                }
                return this.lookahead().dequeue();
            }

            public Iterator scala$collection$Iterator$Leading$$$outer() {
                return this.$outer;
            }

            public Scala_collection_Iterator$Leading$1(Iterator<A> iterator2) {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.p$6 = iterator2;
                this.self$3 = var3_3;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.isDone = false;
                this.lookahead = new Queue<A>();
            }
        }
        Scala_collection_Iterator$Leading$1 leading$1 = new Scala_collection_Iterator$Leading$1($this, p$6, self$3);
        Iterator trailing = new Iterator<A>($this, self$3, leading$1){
            private BufferedIterator it;
            private final BufferedIterator self$3;
            private final Scala_collection_Iterator$Leading$1 leading$1;
            private volatile int bitmap$priv$0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private BufferedIterator it() {
                if ((this.bitmap$priv$0 & 1) != 0) return this.it;
                Iterator$.anon.26 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$priv$0 & 1) == 0) {
                        this.leading$1.finish();
                        this.it = this.self$3;
                        this.bitmap$priv$0 |= 1;
                    }
                    // ** MonitorExit[this] (shouldn't be in output)
                    this.self$3 = null;
                    this.leading$1 = null;
                    return this.it;
                }
            }

            public boolean hasNext() {
                return this.it().hasNext();
            }

            public A next() {
                return this.it().next();
            }

            public String toString() {
                return "unknown-if-empty iterator";
            }
            {
                this.self$3 = iterator2;
                this.leading$1 = var3_3;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
            }
        };
        return new Tuple2<Scala_collection_Iterator$Leading$1, Iterator$.anon.26>(leading$1, trailing);
    }

    public static Iterator dropWhile(Iterator $this, Function1 p$3) {
        BufferedIterator self$4 = $this.buffered();
        return new Iterator<A>($this, p$3, self$4){
            private boolean dropped;
            private final Function1 p$3;
            private final BufferedIterator self$4;

            private boolean dropped() {
                return this.dropped;
            }

            private void dropped_$eq(boolean bl) {
                this.dropped = bl;
            }

            private void skip() {
                if (!this.dropped()) {
                    while (this.self$4.hasNext() && BoxesRunTime.unboxToBoolean(this.p$3.apply(this.self$4.head()))) {
                        this.self$4.next();
                    }
                    this.dropped_$eq(true);
                }
            }

            public boolean hasNext() {
                this.skip();
                return this.self$4.hasNext();
            }

            public A next() {
                this.skip();
                return this.self$4.next();
            }
            {
                this.p$3 = iterator2;
                this.self$4 = var3_3;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.dropped = false;
            }
        };
    }

    public static Iterator zip(Iterator $this, Iterator that$2) {
        return new Iterator<Tuple2<A, B>>($this, that$2){
            public final Iterator $outer;
            public final Iterator that$2;

            public boolean hasNext() {
                return this.$outer.hasNext() && this.that$2.hasNext();
            }

            public Tuple2<A, B> next() {
                return new Tuple2<A, A>(this.$outer.next(), this.that$2.next());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.that$2 = iterator2;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
            }
        };
    }

    public static Iterator padTo(Iterator $this, int len$2, Object elem$4) {
        return new Iterator<A1>($this, len$2, elem$4){
            private int count;
            private final Iterator $outer;
            private final int len$2;
            private final Object elem$4;

            private int count() {
                return this.count;
            }

            private void count_$eq(int n) {
                this.count = n;
            }

            public boolean hasNext() {
                return this.$outer.hasNext() || this.count() < this.len$2;
            }

            public A1 next() {
                this.count_$eq(this.count() + 1);
                return (A1)(this.$outer.hasNext() ? this.$outer.next() : (this.count() <= this.len$2 ? this.elem$4 : Iterator$.MODULE$.empty().next()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.len$2 = n;
                this.elem$4 = var3_3;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.count = 0;
            }
        };
    }

    public static Iterator zipWithIndex(Iterator $this) {
        return new Iterator<Tuple2<A, Object>>($this){
            private int idx;
            public final Iterator $outer;

            public int idx() {
                return this.idx;
            }

            public void idx_$eq(int n) {
                this.idx = n;
            }

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            public Tuple2<A, Object> next() {
                void var1_1;
                Tuple2<A, Integer> ret = new Tuple2<A, Integer>(this.$outer.next(), BoxesRunTime.boxToInteger(this.idx()));
                this.idx_$eq(this.idx() + 1);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.idx = 0;
            }
        };
    }

    public static Iterator zipAll(Iterator $this, Iterator that$3, Object thisElem$1, Object thatElem$1) {
        return new Iterator<Tuple2<A1, B1>>($this, that$3, thisElem$1, thatElem$1){
            public final Iterator $outer;
            public final Iterator that$3;
            public final Object thisElem$1;
            public final Object thatElem$1;

            public boolean hasNext() {
                return this.$outer.hasNext() || this.that$3.hasNext();
            }

            public Tuple2<A1, B1> next() {
                return this.$outer.hasNext() ? (this.that$3.hasNext() ? new Tuple2<A, A>(this.$outer.next(), this.that$3.next()) : new Tuple2<A, Object>(this.$outer.next(), this.thatElem$1)) : (this.that$3.hasNext() ? new Tuple2<Object, A>(this.thisElem$1, this.that$3.next()) : (Tuple2)Iterator$.MODULE$.empty().next());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.that$3 = iterator2;
                this.thisElem$1 = var3_3;
                this.thatElem$1 = var4_4;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
            }
        };
    }

    public static void foreach(Iterator $this, Function1 f2) {
        while ($this.hasNext()) {
            f2.apply($this.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean forall(Iterator $this, Function1 p) {
        void var2_2;
        boolean res = true;
        while (res && $this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean(p.apply($this.next()));
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean exists(Iterator $this, Function1 p) {
        void var2_2;
        boolean res = false;
        while (!res && $this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean(p.apply($this.next()));
        }
        return (boolean)var2_2;
    }

    public static boolean contains(Iterator $this, Object elem$5) {
        return $this.exists(new Serializable($this, elem$5){
            public static final long serialVersionUID;
            public final Object elem$5;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean apply(A a) {
                void y1;
                void x1;
                A a2 = a;
                Object object = this.elem$5;
                return a2 == object ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))));
            }
            {
                this.elem$5 = iterator2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Option find(Iterator $this, Function1 p) {
        void var2_2;
        None$ res = None$.MODULE$;
        while (((Option)res).isEmpty() && $this.hasNext()) {
            Object e = $this.next();
            if (!BoxesRunTime.unboxToBoolean(p.apply(e))) continue;
            res = new Some(e);
        }
        return var2_2;
    }

    public static int indexWhere(Iterator $this, Function1 p) {
        int i = 0;
        boolean found = false;
        while (!found && $this.hasNext()) {
            if (BoxesRunTime.unboxToBoolean(p.apply($this.next()))) {
                found = true;
                continue;
            }
            ++i;
        }
        return found ? i : -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(Iterator $this, Object elem2) {
        int i = 0;
        boolean found = false;
        while (!found && $this.hasNext()) {
            void y1;
            void x1;
            Object object = elem2;
            Object a = $this.next();
            if (a == object ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))))) {
                found = true;
                continue;
            }
            ++i;
        }
        return found ? i : -1;
    }

    public static BufferedIterator buffered(Iterator $this) {
        return new BufferedIterator<A>($this){
            private A hd;
            private boolean hdDefined;
            private final Iterator $outer;

            private A hd() {
                return this.hd;
            }

            private void hd_$eq(A a) {
                this.hd = a;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean bl) {
                this.hdDefined = bl;
            }

            public A head() {
                if (!this.hdDefined()) {
                    this.hd_$eq(this.next());
                    this.hdDefined_$eq(true);
                }
                return this.hd();
            }

            public boolean hasNext() {
                return this.hdDefined() || this.$outer.hasNext();
            }

            public A next() {
                A a;
                if (this.hdDefined()) {
                    this.hdDefined_$eq(false);
                    a = this.hd();
                } else {
                    a = this.$outer.next();
                }
                return a;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                BufferedIterator$class.$init$(this);
                this.hdDefined = false;
            }
        };
    }

    public static Iterator.GroupedIterator grouped(Iterator $this, int size2) {
        return new Iterator.GroupedIterator($this, $this, size2, size2);
    }

    public static Iterator.GroupedIterator sliding(Iterator $this, int size2, int step) {
        return new Iterator.GroupedIterator($this, $this, size2, step);
    }

    public static int sliding$default$2(Iterator $this) {
        return 1;
    }

    public static int length(Iterator $this) {
        return $this.size();
    }

    public static Tuple2 duplicate(Iterator $this) {
        Queue gap$1 = new Queue();
        ObjectRef ahead$1 = new ObjectRef(null);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Scala_collection_Iterator$Partner$1
        implements Iterator<A>,
        ScalaObject {
            public final Iterator $outer;
            private final Queue gap$1;
            private final ObjectRef ahead$1;

            public boolean hasNext() {
                Iterator iterator2 = this.scala$collection$Iterator$Partner$$$outer();
                synchronized (iterator2) {
                    boolean bl = this != (Iterator)this.ahead$1.elem && !this.gap$1.isEmpty() || this.scala$collection$Iterator$Partner$$$outer().hasNext();
                    return bl;
                }
            }

            /*
             * WARNING - void declaration
             */
            public A next() {
                Iterator iterator2 = this.scala$collection$Iterator$Partner$$$outer();
                synchronized (iterator2) {
                    A a;
                    if (this.gap$1.isEmpty()) {
                        this.ahead$1.elem = this;
                    }
                    if (this == (Iterator)this.ahead$1.elem) {
                        void var3_2;
                        A e = this.scala$collection$Iterator$Partner$$$outer().next();
                        this.gap$1.enqueue(Predef$.MODULE$.genericWrapArray(new Object[]{e}));
                        a = var3_2;
                    } else {
                        a = this.gap$1.dequeue();
                    }
                    A a2 = a;
                    return a2;
                }
            }

            private boolean compareGap(Queue<A> queue) {
                return this.gap$1 == queue;
            }

            public int hashCode() {
                return this.gap$1.hashCode();
            }

            public boolean equals(Object other) {
                Object object = other;
                return object instanceof Scala_collection_Iterator$Partner$1 ? ((Scala_collection_Iterator$Partner$1)object).compareGap(this.gap$1) && this.gap$1.isEmpty() : super.equals(other);
            }

            public Iterator scala$collection$Iterator$Partner$$$outer() {
                return this.$outer;
            }

            public Scala_collection_Iterator$Partner$1(Iterator<A> iterator2) {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.gap$1 = iterator2;
                this.ahead$1 = var3_3;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
            }
        }
        return new Tuple2<Scala_collection_Iterator$Partner$1, Scala_collection_Iterator$Partner$1>(new Scala_collection_Iterator$Partner$1($this, gap$1, ahead$1), new Scala_collection_Iterator$Partner$1($this, gap$1, ahead$1));
    }

    public static Iterator patch(Iterator $this, int from$1, Iterator patchElems$1, int replaced$1) {
        return new Iterator<B>($this, from$1, patchElems$1, replaced$1){
            private Iterator<A> origElems;
            private int i;
            private final int from$1;
            private final Iterator patchElems$1;
            private final int replaced$1;

            private Iterator<A> origElems() {
                return this.origElems;
            }

            private void origElems_$eq(Iterator<A> iterator2) {
                this.origElems = iterator2;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return this.i() < this.from$1 ? this.origElems().hasNext() : this.patchElems$1.hasNext() || this.origElems().hasNext();
            }

            /*
             * WARNING - void declaration
             */
            public B next() {
                void var1_1;
                A result2 = this.i() >= this.from$1 && this.patchElems$1.hasNext() ? this.patchElems$1.next() : this.origElems().next();
                this.i_$eq(this.i() + 1);
                if (this.i() == this.from$1) {
                    this.origElems_$eq(this.origElems().drop(this.replaced$1));
                }
                return var1_1;
            }
            {
                this.from$1 = n;
                this.patchElems$1 = var3_3;
                this.replaced$1 = n2;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.origElems = $outer;
                this.i = 0;
            }
        };
    }

    public static void copyToArray(Iterator $this, Object xs, int start, int len) {
        int end = start + package$.MODULE$.min(len, ScalaRunTime$.MODULE$.array_length(xs));
        for (int i = start; $this.hasNext() && i < end; ++i) {
            ScalaRunTime$.MODULE$.array_update(xs, i, $this.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean sameElements(Iterator $this, Iterator that) {
        while ($this.hasNext() && that.hasNext()) {
            void y1;
            void x1;
            Object a = that.next();
            Object a2 = $this.next();
            if (a2 == a ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))))) continue;
            return false;
        }
        return !$this.hasNext() && !that.hasNext();
    }

    public static Traversable toTraversable(Iterator $this) {
        return $this.toStream();
    }

    public static Iterator toIterator(Iterator $this) {
        return $this;
    }

    public static Stream toStream(Iterator $this) {
        Stream stream;
        if ($this.hasNext()) {
            Serializable serializable2 = new Serializable($this){
                public static final long serialVersionUID;
                public final Iterator $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Stream<A> apply() {
                    return this.$outer.toStream();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
            Object a = $this.next();
            stream = new Stream.Cons(a, serializable2);
        } else {
            stream = Stream$Empty$.MODULE$;
        }
        return stream;
    }

    public static String toString(Iterator $this) {
        return new StringBuilder().append((Object)($this.hasNext() ? "non-empty" : "empty")).append((Object)" iterator").toString();
    }

    public static Iterator append(Iterator $this, Iterator that$4) {
        return $this.$plus$plus(new Serializable($this, that$4){
            public static final long serialVersionUID;
            public final Iterator that$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Iterator<B> apply() {
                return this.that$4;
            }
            {
                this.that$4 = iterator2;
            }
        });
    }

    public static int findIndexOf(Iterator $this, Function1 p) {
        return $this.indexWhere(p);
    }

    public static CountedIterator counted(Iterator $this) {
        return new CountedIterator<A>($this){
            private int cnt;
            private final Iterator $outer;

            private int cnt() {
                return this.cnt;
            }

            private void cnt_$eq(int n) {
                this.cnt = n;
            }

            public int count() {
                return this.cnt();
            }

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            public A next() {
                this.cnt_$eq(this.cnt() + 1);
                return this.$outer.next();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                CountedIterator$class.$init$(this);
                this.cnt = 0;
            }
        };
    }

    public static void readInto(Iterator $this, Object xs, int start, int sz) {
        int i = start;
        while ($this.hasNext() && i - start < sz) {
            ScalaRunTime$.MODULE$.array_update(xs, i, $this.next());
            ++i;
        }
    }

    public static void readInto(Iterator $this, Object xs, int start) {
        $this.readInto(xs, start, ScalaRunTime$.MODULE$.array_length(xs) - start);
    }

    public static void readInto(Iterator $this, Object xs) {
        $this.readInto(xs, 0, ScalaRunTime$.MODULE$.array_length(xs));
    }

    public static void $init$(Iterator $this) {
    }
}

